/*
 * Decompiled with CFR 0.152.
 */
package com.holmos.reflect.reflectCheck.comparator;

import com.holmos.reflect.basetool.HolmosCollectionTool;
import com.holmos.reflect.reflectCheck.HolmosMatchingScoreCalculator;
import com.holmos.reflect.reflectCheck.HolmosReflectionComparator;
import com.holmos.reflect.reflectCheck.comparator.HolmosComparator;
import com.holmos.reflect.reflectCheck.difference.HolmosCollectionIgnoreOrderDifference;
import com.holmos.reflect.reflectCheck.difference.HolmosDifference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

public class HolmosIgnoreOrderCollectionComparator
implements HolmosComparator {
    @Override
    public boolean canCompare(Object leftValue, Object rightValue) {
        if (leftValue == null || rightValue == null) {
            return false;
        }
        return !(!leftValue.getClass().isArray() && !(leftValue instanceof Collection) || !rightValue.getClass().isArray() && !(rightValue instanceof Collection));
    }

    @Override
    public HolmosDifference compare(Object leftValue, Object rightValue, boolean onlyIfFirstDifference, HolmosReflectionComparator holmosReflectionComparator) {
        ArrayList<Object> rightList;
        ArrayList<Object> leftList = new ArrayList<Object>(HolmosCollectionTool.convertToCollection(leftValue));
        boolean isEqual = this.isEqualIgnoreOrder(leftList, rightList = new ArrayList<Object>(HolmosCollectionTool.convertToCollection(rightValue)), holmosReflectionComparator);
        if (isEqual) {
            return null;
        }
        HolmosCollectionIgnoreOrderDifference collectionIgnoreOrderDifference = new HolmosCollectionIgnoreOrderDifference(leftValue, rightValue, leftList, rightList, "\u65e0\u5e8f\u6570\u7ec4\u6216\u8005List\u6bd4\u8f83\u5668");
        if (onlyIfFirstDifference) {
            return collectionIgnoreOrderDifference;
        }
        this.fillAllDifferenceElments(leftList, rightList, holmosReflectionComparator, collectionIgnoreOrderDifference);
        this.fillBestMatches(leftList, rightList, collectionIgnoreOrderDifference);
        return collectionIgnoreOrderDifference;
    }

    protected boolean isEqualIgnoreOrder(ArrayList<Object> leftList, ArrayList<Object> rightList, HolmosReflectionComparator holmosReflectionComparator) {
        Iterator<Object> leftIterator = leftList.iterator();
        Iterator<Object> rightIterator = rightList.iterator();
        block0: while (leftIterator.hasNext()) {
            Object leftValue = leftIterator.next();
            rightIterator = rightList.iterator();
            while (rightIterator.hasNext()) {
                Object rightValue = rightIterator.next();
                if (holmosReflectionComparator.getDifference(leftValue, rightValue, true) != null) continue;
                leftIterator.remove();
                rightIterator.remove();
                continue block0;
            }
        }
        return leftList.isEmpty() && rightList.isEmpty();
    }

    protected boolean isEqualIgnoreOrderRecursively(ArrayList<Object> leftList, ArrayList<Object> rightList, HolmosReflectionComparator holmosReflectionComparator) {
        if (rightList.isEmpty() && leftList.isEmpty()) {
            return true;
        }
        if (rightList.isEmpty() || leftList.isEmpty()) {
            return false;
        }
        Iterator<Object> iterator = leftList.iterator();
        if (iterator.hasNext()) {
            Object left = iterator.next();
            for (Object right : rightList) {
                if (holmosReflectionComparator.getDifference(left, right, true) != null) continue;
                leftList.remove(left);
                rightList.remove(right);
                if (!this.isEqualIgnoreOrderRecursively(leftList, rightList, holmosReflectionComparator)) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    protected void fillAllDifferenceElments(ArrayList<Object> leftList, ArrayList<Object> rightList, HolmosReflectionComparator reflectionComparator, HolmosCollectionIgnoreOrderDifference difference) {
        int leftIndex = 0;
        while (leftIndex < leftList.size()) {
            Object leftValue = leftList.get(leftIndex);
            int rightIndex = 0;
            while (rightIndex < rightList.size()) {
                Object rightValue = rightList.get(rightIndex);
                HolmosDifference elementDifference = reflectionComparator.getDifference(leftValue, rightValue);
                difference.addElementDifference(leftIndex, rightIndex, elementDifference);
                ++rightIndex;
            }
            ++leftIndex;
        }
    }

    protected void removeMatchIndexes(ArrayList<Integer> leftIndexes, ArrayList<Integer> rightIndexes, HolmosCollectionIgnoreOrderDifference difference) {
        Iterator<Integer> leftIterator = leftIndexes.iterator();
        Iterator<Integer> rightIterator = rightIndexes.iterator();
        while (leftIterator.hasNext()) {
            int leftIndex = leftIterator.next();
            while (rightIterator.hasNext()) {
                int rightIndex = rightIterator.next();
                if (difference.getElementDifference().get(leftIndex).get(rightIndex) != null) continue;
                leftIterator.remove();
                rightIterator.remove();
            }
        }
    }

    protected void setBestMatchIndexes(ArrayList<Integer> leftIndexes, ArrayList<Integer> rightIndexes, HolmosCollectionIgnoreOrderDifference difference) {
        int score = Integer.MAX_VALUE;
        HolmosMatchingScoreCalculator matchingScoreCalculator = this.getMatchingScoreCalculator();
        for (Integer leftIndex : leftIndexes) {
            score = Integer.MAX_VALUE;
            for (Integer rightIndex : rightIndexes) {
                int matchScore = matchingScoreCalculator.calculateMatchingScore(difference);
                if (score <= matchScore) continue;
                score = matchScore;
                difference.setBestMatch(leftIndex, rightIndex);
            }
        }
    }

    protected void fillBestMatches(ArrayList<Object> leftList, ArrayList<Object> rightList, HolmosCollectionIgnoreOrderDifference collectionIgnoreOrderDifference) {
        ArrayList<Integer> leftIndexes = this.createIndexList(leftList.size());
        ArrayList<Integer> rightIndexes = this.createIndexList(rightList.size());
        this.removeMatchIndexes(leftIndexes, rightIndexes, collectionIgnoreOrderDifference);
        this.setBestMatchIndexes(leftIndexes, rightIndexes, collectionIgnoreOrderDifference);
    }

    protected ArrayList<Integer> createIndexList(int size) {
        ArrayList<Integer> indexes = new ArrayList<Integer>();
        int i = 0;
        while (i < size) {
            indexes.add(i);
            ++i;
        }
        return indexes;
    }

    protected HolmosMatchingScoreCalculator getMatchingScoreCalculator() {
        return new HolmosMatchingScoreCalculator();
    }
}

