/*
 * Decompiled with CFR 0.152.
 */
package com.holmos.reflect.reflectCheck.report;

import com.holmos.reflect.reflectCheck.HolmosDifferenceVisitor;
import com.holmos.reflect.reflectCheck.difference.HolmosClassDifference;
import com.holmos.reflect.reflectCheck.difference.HolmosCollectionDifference;
import com.holmos.reflect.reflectCheck.difference.HolmosCollectionIgnoreOrderDifference;
import com.holmos.reflect.reflectCheck.difference.HolmosDifference;
import com.holmos.reflect.reflectCheck.difference.HolmosMapDifference;
import com.holmos.reflect.reflectCheck.difference.HolmosObjectDifference;
import com.holmos.reflect.reflectCheck.report.HolmosDefaultDifferentReport;
import com.holmos.reflect.reflectCheck.report.HolmosDifferenceView;
import com.holmos.reflect.tool.HolmosObjectFormatter;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.ClassUtils;

public class HolmosDefalutDifferenceView
implements HolmosDifferenceView {
    protected boolean isUnorderCollectionFormatted = false;
    protected HolmosObjectFormatter objectFormatter = new HolmosObjectFormatter();
    protected HolmosDifferenceFormatterVisitor holmosDifferenceFormatterVisitor = new HolmosDifferenceFormatterVisitor();

    @Override
    public String createView(HolmosDifference difference) {
        return difference.accept(this.holmosDifferenceFormatterVisitor, null);
    }

    protected String formatDifference(HolmosDifference holmosDifference, String fieldName) {
        return this.formatValues(fieldName, holmosDifference.getLeftValue(), holmosDifference.getRightValue());
    }

    protected String formatDifference(HolmosObjectDifference objectDifference, String fieldName) {
        StringBuilder result = new StringBuilder();
        for (Map.Entry<String, HolmosDifference> fieldDifference : objectDifference.getFieldDifferences().entrySet()) {
            String innerFieldName = this.createFieldName(fieldName, fieldDifference.getKey(), true);
            result.append(fieldDifference.getValue().accept(this.holmosDifferenceFormatterVisitor, innerFieldName));
        }
        return result.toString();
    }

    private String createFieldName(String fieldName, String innerFieldName, boolean includePoint) {
        if (fieldName == null) {
            return innerFieldName;
        }
        if (includePoint) {
            return String.valueOf(fieldName) + "." + innerFieldName;
        }
        return String.valueOf(fieldName) + innerFieldName;
    }

    protected String formatDifference(HolmosClassDifference classDifference, String fieldName) {
        StringBuilder result = new StringBuilder();
        result.append("\u9884\u671f\u7684\u5bf9\u8c61\u7c7b\u578b:").append(ClassUtils.getShortClassName(classDifference.getLeftClass()));
        result.append(", \u5b9e\u9645\u7684\u5bf9\u8c61\u7c7b\u578b: ").append(ClassUtils.getShortClassName(classDifference.getRightClass())).append("\n");
        return result.toString();
    }

    protected String formatDifference(HolmosCollectionDifference collectionDifference, String fieldName) {
        String innerFieldName;
        StringBuilder result = new StringBuilder();
        for (Map.Entry<Integer, HolmosDifference> elementDifferences : collectionDifference.getAllElementsDifferences().entrySet()) {
            String innerFieldName2 = this.createFieldName(fieldName, "[" + elementDifferences.getKey() + "]", false);
            result.append(elementDifferences.getValue().accept(this.holmosDifferenceFormatterVisitor, innerFieldName2));
        }
        List<?> leftList = collectionDifference.getLeftList();
        List<?> rightList = collectionDifference.getRightList();
        for (Integer leftIndex : collectionDifference.getLeftMissingIndexes()) {
            innerFieldName = this.createFieldName(fieldName, "[" + leftIndex + "]", false);
            result.append(this.formatValues(innerFieldName, leftList.get(leftIndex), (Object)HolmosDefaultDifferentReport.MatchType.NO_MATCH));
        }
        for (Integer rightIndex : collectionDifference.getRightMissingIndexes()) {
            innerFieldName = this.createFieldName(fieldName, "[" + rightIndex + "]", false);
            result.append(this.formatValues(innerFieldName, (Object)HolmosDefaultDifferentReport.MatchType.NO_MATCH, rightList.get(rightIndex)));
        }
        return result.toString();
    }

    protected String formatDifference(HolmosMapDifference mapDifference, String fieldName) {
        String innerFieldName;
        StringBuilder result = new StringBuilder();
        for (Map.Entry<Object, HolmosDifference> mapValueDifference : mapDifference.getValueDifferences().entrySet()) {
            String innerFieldName2 = this.createFieldName(fieldName, this.formatObject(mapValueDifference.getKey()), true);
            result.append(mapValueDifference.getValue().accept(this.holmosDifferenceFormatterVisitor, innerFieldName2));
        }
        Map<?, ?> leftMap = mapDifference.getLeftMap();
        Map<?, ?> rightMap = mapDifference.getRightMap();
        for (Object leftKey : mapDifference.getLeftMissingKeys()) {
            innerFieldName = this.createFieldName(fieldName, this.formatObject(leftKey), true);
            result.append(this.formatValues(innerFieldName, leftMap.get(leftKey), ""));
        }
        for (Object rightKey : mapDifference.getRightMissingKeys()) {
            innerFieldName = this.createFieldName(fieldName, this.formatObject(rightKey), true);
            result.append(this.formatValues(innerFieldName, rightMap.get(rightKey), ""));
        }
        return result.toString();
    }

    protected String formatDifference(HolmosCollectionIgnoreOrderDifference collectionIgnoreOrderDifference, String fieldName) {
        StringBuilder result = new StringBuilder();
        result.append(String.valueOf(fieldName) + ":");
        if (collectionIgnoreOrderDifference.getLeftList().size() != collectionIgnoreOrderDifference.getRightList().size()) {
            result.append("\u4e24\u4e2a\u5f85\u6bd4\u8f83\u7684\u6570\u7ec4\u6216\u8005\u96c6\u5408\u7684\u957f\u5ea6\u4e0d\u4e00\u81f4,\u5de6\u503c(\u7b2c\u4e00\u4e2a\u6570\u7ec4\u6216\u8005\u96c6\u5408)\u7684\u957f\u5ea6\u4e3a:" + collectionIgnoreOrderDifference.getLeftList().size() + "\u53f3\u503c(\u7b2c\u4e8c\u4e2a\u6570\u7ec4\u6216\u96c6\u5408)\u7684\u957f\u5ea6\u4e3a:" + collectionIgnoreOrderDifference.getRightList().size());
        }
        Map<Integer, Integer> bestMatchIndexes = collectionIgnoreOrderDifference.getBestMatchIndexes();
        for (Map.Entry<Integer, Integer> match : bestMatchIndexes.entrySet()) {
            HolmosDifference elementDifference;
            String innerFieldName;
            int leftIndex = match.getKey();
            int rightIndex = match.getValue();
            if (leftIndex == -1) {
                innerFieldName = this.createFieldName(fieldName, "[x," + rightIndex + "]", false);
                result.append(this.formatValues(innerFieldName, (Object)HolmosDefaultDifferentReport.MatchType.NO_MATCH, collectionIgnoreOrderDifference.getRightList().get(rightIndex)));
            }
            if (rightIndex == -1) {
                innerFieldName = this.createFieldName(fieldName, "[x," + rightIndex + "]", false);
                result.append(this.formatValues(innerFieldName, collectionIgnoreOrderDifference.getLeftList().get(leftIndex), (Object)HolmosDefaultDifferentReport.MatchType.NO_MATCH));
            }
            if ((elementDifference = collectionIgnoreOrderDifference.getElementDifference(leftIndex, rightIndex)) == null) continue;
            String innerFieldName2 = this.createFieldName(fieldName, "[" + leftIndex + "," + rightIndex + "]", false);
            result.append(elementDifference.accept(this.holmosDifferenceFormatterVisitor, innerFieldName2));
        }
        return result.toString();
    }

    private String formatObject(Object object) {
        if (object == HolmosDefaultDifferentReport.MatchType.NO_MATCH) {
            return "\u6ca1\u6709\u5339\u914d\u9879";
        }
        return this.objectFormatter.format(object);
    }

    private String formatValues(String fieldName, Object leftValue, Object rightValue) {
        String rightValueFormatted;
        String leftValueFormatted = this.formatObject(leftValue);
        String result = this.formatToOneLine(fieldName, leftValueFormatted, rightValueFormatted = this.formatObject(rightValue));
        if (result.length() > 110) {
            result = this.formatToMultiLines(fieldName, leftValueFormatted, rightValueFormatted);
        }
        return result;
    }

    private String formatToOneLine(String fieldName, String expectedStr, String actualStr) {
        StringBuilder result = new StringBuilder();
        if (fieldName != null) {
            result.append(String.valueOf(fieldName) + ":");
        }
        result.append("\u9884\u671f\u503c\u4e3a:" + expectedStr);
        result.append("  \u5b9e\u9645\u503c\u4e3a:" + actualStr);
        return result.toString();
    }

    private String formatToMultiLines(String fieldName, String expectedStr, String actualStr) {
        StringBuilder result = new StringBuilder();
        if (fieldName != null) {
            result.append(String.valueOf(fieldName) + ":\n");
        }
        result.append("\u9884\u671f\u503c\u4e3a:" + expectedStr);
        result.append("\n  \u5b9e\u9645\u503c\u4e3a:" + actualStr);
        result.append("\n");
        return result.toString();
    }

    protected class HolmosDifferenceFormatterVisitor
    implements HolmosDifferenceVisitor<String, String> {
        protected HolmosDifferenceFormatterVisitor() {
        }

        @Override
        public String visit(HolmosDifference difference, String fieldName) {
            return HolmosDefalutDifferenceView.this.formatDifference(difference, fieldName);
        }

        @Override
        public String visit(HolmosObjectDifference objectDifference, String fieldName) {
            return HolmosDefalutDifferenceView.this.formatDifference(objectDifference, fieldName);
        }

        @Override
        public String visit(HolmosClassDifference classDifference, String fieldName) {
            return HolmosDefalutDifferenceView.this.formatDifference(classDifference, fieldName);
        }

        @Override
        public String visit(HolmosMapDifference mapDifference, String fieldName) {
            return HolmosDefalutDifferenceView.this.formatDifference(mapDifference, fieldName);
        }

        @Override
        public String visit(HolmosCollectionDifference collectionDifference, String fieldName) {
            return HolmosDefalutDifferenceView.this.formatDifference(collectionDifference, fieldName);
        }

        @Override
        public String visit(HolmosCollectionIgnoreOrderDifference collectionIgnoreOrderDifference, String fieldName) {
            return HolmosDefalutDifferenceView.this.formatDifference(collectionIgnoreOrderDifference, fieldName);
        }
    }
}

