/*
 * Decompiled with CFR 0.152.
 */
package com.holmos.reflect.reflectCheck.report;

import com.holmos.reflect.reflectCheck.difference.HolmosDifference;
import com.holmos.reflect.reflectCheck.report.HolmosDifferenceView;
import com.holmos.reflect.tool.HolmosObjectFormatter;
import junit.framework.AssertionFailedError;

public class HolmosSimpleDifferenceView
implements HolmosDifferenceView {
    private HolmosObjectFormatter objectFormatter = new HolmosObjectFormatter();

    @Override
    public String createView(HolmosDifference difference) {
        String expectedStr = this.objectFormatter.format(difference.getLeftValue());
        String actualStr = this.objectFormatter.format(difference.getRightValue());
        String formattedOnOneLine = this.formatToOneLine(expectedStr, actualStr);
        if (AssertionFailedError.class.getName().length() + 2 + formattedOnOneLine.length() < 110) {
            return formattedOnOneLine;
        }
        return this.formatToTwoLines(expectedStr, actualStr);
    }

    public String formatToOneLine(String expectedStr, String actualStr) {
        return "\u9884\u671f\u503c: " + expectedStr + ", \u5b9e\u9645\u503c: " + actualStr;
    }

    public String formatToTwoLines(String expectedStr, String actualStr) {
        StringBuilder result = new StringBuilder();
        result.append("\n\u9884\u671f\u503c: ").append(expectedStr);
        result.append("\n\u5b9e\u9645\u503c: ").append(actualStr);
        return result.toString();
    }
}

