/*
 * Decompiled with CFR 0.152.
 */
package com.holmos.reflect.reflectCheck.report;

import com.holmos.reflect.reflectCheck.HolmosDifferenceVisitor;
import com.holmos.reflect.reflectCheck.difference.HolmosClassDifference;
import com.holmos.reflect.reflectCheck.difference.HolmosCollectionDifference;
import com.holmos.reflect.reflectCheck.difference.HolmosCollectionIgnoreOrderDifference;
import com.holmos.reflect.reflectCheck.difference.HolmosDifference;
import com.holmos.reflect.reflectCheck.difference.HolmosMapDifference;
import com.holmos.reflect.reflectCheck.difference.HolmosObjectDifference;
import com.holmos.reflect.reflectCheck.report.HolmosDefaultDifferentReport;
import com.holmos.reflect.reflectCheck.report.HolmosDifferenceView;
import com.holmos.reflect.tool.HolmosObjectFormatter;
import java.util.Map;

public class HolmosTreeDifferenceView
implements HolmosDifferenceView {
    protected HolmosObjectFormatter objectFormatter = new HolmosObjectFormatter();
    protected HolmosTreeDifferenceFormatterVisitor differenceFormatterVisitor = new HolmosTreeDifferenceFormatterVisitor();

    @Override
    public String createView(HolmosDifference difference) {
        return difference.accept(this.differenceFormatterVisitor, null);
    }

    protected String formatDifference(HolmosDifference difference, String fieldName) {
        return this.formatValues(fieldName, difference.getLeftValue(), difference.getRightValue());
    }

    private String formatValues(String fieldName, Object leftValue, Object rightValue) {
        StringBuilder result = new StringBuilder();
        result.append(fieldName == null ? "" : fieldName);
        result.append("\u9884\u671f\u503c\u4e3a:\n");
        result.append(this.objectFormatter.format(leftValue));
        result.append("\n");
        result.append("\u5b9e\u9645\u503c\u4e3a:\n");
        result.append(this.objectFormatter.format(rightValue));
        result.append("\n");
        return result.toString();
    }

    protected String formatDifference(HolmosObjectDifference objectDifference, String fieldName) {
        StringBuilder result = new StringBuilder();
        result.append(this.formatDifference((HolmosDifference)objectDifference, fieldName));
        for (Map.Entry<String, HolmosDifference> fieldDifference : objectDifference.getFieldDifferences().entrySet()) {
            String innerFieldName = this.createFieldName(fieldName, fieldDifference.getKey(), true);
            result.append(this.formatDifference((HolmosDifference)((Object)fieldDifference), innerFieldName));
        }
        return result.toString();
    }

    protected String formatDifference(HolmosClassDifference classDifference, String fieldName) {
        StringBuilder result = new StringBuilder();
        result.append(fieldName == null ? "" : fieldName);
        result.append("\u9884\u671f\u7c7b\u578b\u4e3a:" + classDifference.getLeftValue() + "\n");
        result.append("\u5b9e\u9645\u7c7b\u578b\u4e3a:" + classDifference.getRightValue() + "\n");
        return result.toString();
    }

    protected String formatDifference(HolmosCollectionDifference collectionDifference, String fieldName) {
        String innerFileldName;
        StringBuilder result = new StringBuilder();
        for (Map.Entry<Integer, HolmosDifference> elementDifference : collectionDifference.getAllElementsDifferences().entrySet()) {
            String innerFieldName = this.createFieldName(fieldName, "[" + elementDifference.getKey() + "]", false);
            result.append(collectionDifference.accept(this.differenceFormatterVisitor, innerFieldName));
        }
        for (Integer leftMiss : collectionDifference.getLeftMissingIndexes()) {
            innerFileldName = this.createFieldName(fieldName, "[" + leftMiss.toString() + "]", false);
            result.append(this.formatValues(innerFileldName, "", collectionDifference.getRightList().get(leftMiss)));
        }
        for (Integer rightMiss : collectionDifference.getLeftMissingIndexes()) {
            innerFileldName = this.createFieldName(fieldName, "[" + rightMiss.toString() + "]", false);
            result.append(this.formatValues(innerFileldName, collectionDifference.getRightList().get(rightMiss), ""));
        }
        return result.toString();
    }

    protected String formatDifference(HolmosMapDifference mapDifference, String fieldName) {
        String innerFieldName;
        StringBuilder result = new StringBuilder();
        result.append(this.formatDifference((HolmosDifference)mapDifference, fieldName));
        for (Map.Entry<Object, HolmosDifference> elementDifference : mapDifference.getValueDifferences().entrySet()) {
            innerFieldName = this.createFieldName(fieldName, this.formatObject(elementDifference.getKey()), false);
            result.append(mapDifference.accept(this.differenceFormatterVisitor, innerFieldName));
        }
        for (Object leftMiss : mapDifference.getLeftMissingKeys()) {
            innerFieldName = this.createFieldName(fieldName, this.formatObject(leftMiss), false);
            result.append(this.formatValues(innerFieldName, "", this.objectFormatter.format(leftMiss)));
        }
        return result.toString();
    }

    private String formatObject(Object object) {
        if (object == HolmosDefaultDifferentReport.MatchType.NO_MATCH) {
            return "\u6ca1\u6709\u5339\u914d\u9879";
        }
        return this.objectFormatter.format(object);
    }

    protected String formatDifference(HolmosCollectionIgnoreOrderDifference collectionIgnoreOrderDifference, String fieldName) {
        StringBuilder result = new StringBuilder();
        result.append(this.formatDifference((HolmosDifference)collectionIgnoreOrderDifference, fieldName));
        for (Map.Entry<Integer, Integer> matchIndex : collectionIgnoreOrderDifference.getBestMatchIndexes().entrySet()) {
            String innerFieldName;
            Integer leftIndex = matchIndex.getKey();
            Integer rightIndex = matchIndex.getValue();
            if (leftIndex == -1) {
                innerFieldName = this.createFieldName(fieldName, "[" + rightIndex + "]", false);
                result.append(this.formatValues(innerFieldName, (Object)HolmosDefaultDifferentReport.MatchType.NO_MATCH, collectionIgnoreOrderDifference.getRightList().get(rightIndex)));
                continue;
            }
            if (rightIndex == -1) {
                innerFieldName = this.createFieldName(fieldName, "[" + leftIndex + "]", false);
                result.append(this.formatValues(innerFieldName, collectionIgnoreOrderDifference.getRightList().get(leftIndex), (Object)HolmosDefaultDifferentReport.MatchType.NO_MATCH));
                continue;
            }
            HolmosDifference difference = collectionIgnoreOrderDifference.getElementDifference(leftIndex, rightIndex);
            if (difference == null) continue;
            String innerFieldName2 = this.createFieldName(fieldName, "[" + leftIndex + "," + rightIndex + "]", false);
            difference.accept(this.differenceFormatterVisitor, innerFieldName2);
        }
        return result.toString();
    }

    private String createFieldName(String fieldName, String innerFieldName, boolean includePoint) {
        StringBuilder fullName = new StringBuilder();
        if (fieldName == null || fieldName == "") {
            fullName.append(innerFieldName);
        } else if (includePoint) {
            fullName.append(String.valueOf(fieldName) + "." + innerFieldName);
        } else {
            fullName.append(String.valueOf(fieldName) + innerFieldName);
        }
        return fullName.toString();
    }

    protected class HolmosTreeDifferenceFormatterVisitor
    implements HolmosDifferenceVisitor<String, String> {
        protected HolmosTreeDifferenceFormatterVisitor() {
        }

        @Override
        public String visit(HolmosDifference difference, String fieldName) {
            return HolmosTreeDifferenceView.this.formatDifference(difference, fieldName);
        }

        @Override
        public String visit(HolmosObjectDifference objectDifference, String fieldName) {
            return HolmosTreeDifferenceView.this.formatDifference(objectDifference, fieldName);
        }

        @Override
        public String visit(HolmosClassDifference classDifference, String fieldName) {
            return HolmosTreeDifferenceView.this.formatDifference(classDifference, fieldName);
        }

        @Override
        public String visit(HolmosMapDifference mapDifference, String fieldName) {
            return HolmosTreeDifferenceView.this.formatDifference(mapDifference, fieldName);
        }

        @Override
        public String visit(HolmosCollectionDifference collectionDifference, String fieldName) {
            return HolmosTreeDifferenceView.this.formatDifference(collectionDifference, fieldName);
        }

        @Override
        public String visit(HolmosCollectionIgnoreOrderDifference collectionIgnoreOrderDifference, String fieldName) {
            return HolmosTreeDifferenceView.this.formatDifference(collectionIgnoreOrderDifference, fieldName);
        }
    }
}

