/*
 * Decompiled with CFR 0.152.
 */
package com.holmos.reflect.utils;

import com.holmos.reflect.error.HolmosReflectAssertError;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;

public class HolmosReflectionUtils {
    public static <T> T createInstanceAsType(String typeName, boolean isAccessible) {
        try {
            Class<?> typeForInstance = Class.forName(typeName);
            return (T)HolmosReflectionUtils.createInstanceAsType(typeForInstance, isAccessible);
        }
        catch (ClassNotFoundException e) {
            throw new HolmosReflectAssertError("\u521b\u5efa\u65e0\u53c2\u5bf9\u8c61\u5b9e\u4f8b\u5931\u8d25!");
        }
    }

    public static <T> T createInstanceAsType(Class<T> typeForInstance, boolean isAccessible) {
        return HolmosReflectionUtils.createInstanceOfType(typeForInstance, isAccessible, new Class[0], new Object[0]);
    }

    public static <T> T createInstanceOfType(Class<T> typeForInstance, boolean isAccessible, Class[] argumentsType, Object[] arguments) {
        if (typeForInstance.isMemberClass() || Modifier.isStatic(typeForInstance.getModifiers())) {
            throw new HolmosReflectAssertError("\u5bf9\u4e8e\u6210\u5458\u5185\u90e8\u7c7b\u548c\u9759\u6001\u7c7b\uff0cHolmos\u6846\u67b6\u65e0\u6cd5\u4e3a\u5176\u521b\u5efa\u5bf9\u8c61\u5b9e\u4f8b!\u8be6\u60c5\u8bf7\u89c1java\u4e2d\u5173\u4e8e\u6210\u5458\u5185\u90e8\u7c7b\u548c\u9759\u6001\u7c7b\u7684\u5b9a\u4e49!\u8bf7\u53c2\u7167:http://baike.baidu.com/view/6497553.htm\u548chttp://baike.baidu.com/view/3671198.htm");
        }
        try {
            Constructor<T> constructor = typeForInstance.getDeclaredConstructor(argumentsType);
            if (isAccessible) {
                constructor.setAccessible(isAccessible);
            }
            return constructor.newInstance(arguments);
        }
        catch (InvocationTargetException e) {
            throw new HolmosReflectAssertError("\u521b\u5efa" + typeForInstance.getName() + "\u5bf9\u8c61\u7684\u65f6\u5019\u53d1\u751f\u9519\u8bef!");
        }
        catch (Exception e) {
            throw new HolmosReflectAssertError("\u521b\u5efa" + typeForInstance.getName() + "\u5bf9\u8c61\u7684\u65f6\u5019\u53d1\u751f\u9519\u8bef!");
        }
    }

    public static Object getFieldValue(Object object, Field field) {
        try {
            field.setAccessible(true);
            return field.get(object);
        }
        catch (IllegalArgumentException e) {
            throw new HolmosReflectAssertError("\u5b57\u6bb5" + field.getName() + "\u7684\u503c\u83b7\u53d6\u5931\u8d25!");
        }
        catch (IllegalAccessException e) {
            throw new HolmosReflectAssertError("\u5b57\u6bb5" + field.getName() + "\u7684\u503c\u83b7\u53d6\u5931\u8d25!");
        }
    }

    public static Object getFieldValue(Object object, String fieldName) {
        try {
            Field field = object.getClass().getDeclaredField(fieldName);
            return HolmosReflectionUtils.getFieldValue(object, field);
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static void setFieldValue(Object object, Field field, Object value) {
        try {
            field.setAccessible(true);
            field.set(object, value);
        }
        catch (IllegalArgumentException e) {
            throw new HolmosReflectAssertError("\u5b57\u6bb5" + field.getName() + "\u7684\u503c\u8bbe\u7f6e\u5931\u8d25!");
        }
        catch (IllegalAccessException e) {
            throw new HolmosReflectAssertError("\u5b57\u6bb5" + field.getName() + "\u7684\u503c\u8bbe\u7f6e\u5931\u8d25!");
        }
    }

    public static void setFieldsValue(Object object, ArrayList<Field> fields, Object value) {
        for (Field field : fields) {
            HolmosReflectionUtils.setFieldValue(object, field, value);
        }
    }

    public static void setFieldValueThroughSetter(Object object, Method setter, Object value) {
        if (HolmosReflectionUtils.isSetterMethod(setter)) {
            try {
                setter.invoke(object, value);
            }
            catch (IllegalArgumentException e) {
                throw new HolmosReflectAssertError("\u901a\u8fc7setter\u65b9\u6cd5\u8d4b\u503c\u5931\u8d25!");
            }
            catch (IllegalAccessException e) {
                throw new HolmosReflectAssertError("\u901a\u8fc7setter\u65b9\u6cd5\u8d4b\u503c\u5931\u8d25!");
            }
            catch (InvocationTargetException e) {
                throw new HolmosReflectAssertError("\u901a\u8fc7setter\u65b9\u6cd5\u8d4b\u503c\u5931\u8d25!");
            }
        } else {
            throw new HolmosReflectAssertError("\u901a\u8fc7setter\u65b9\u6cd5\u8d4b\u503c\u5931\u8d25!");
        }
    }

    public static void setFieldValueThroughSetters(Object object, ArrayList<Method> setters, Object value) {
        for (Method setter : setters) {
            HolmosReflectionUtils.setFieldValueThroughSetter(object, setter, value);
        }
    }

    public static void setFieldValueThroughFieldsOrSetters(Object object, ArrayList<Field> fields, ArrayList<Method> setters, Object value) {
        HolmosReflectionUtils.setFieldsValue(object, fields, value);
        HolmosReflectionUtils.setFieldValueThroughSetters(object, setters, value);
    }

    public static Object invokeMethod(Object object, Method method, Object ... arguments) throws InvocationTargetException {
        try {
            method.setAccessible(true);
            return method.invoke(object, arguments);
        }
        catch (IllegalArgumentException e) {
            throw new HolmosReflectAssertError("\u65b9\u6cd5" + method.getName() + "\u6267\u884c\u5931\u8d25!");
        }
        catch (IllegalAccessException e) {
            throw new HolmosReflectAssertError("\u65b9\u6cd5" + method.getName() + "\u6267\u884c\u5931\u8d25!");
        }
    }

    private static boolean isSetterMethod(Method method) {
        String methodName = method.getName();
        return (methodName.length() > 3 || methodName.startsWith("set") && method.getParameterTypes().length == 1) && methodName.substring(3, 4).indexOf(0) >= 65 && methodName.substring(3, 4).indexOf(0) <= 90;
    }

    public static Class<?> getClassWithName(String valueAsString) {
        try {
            return Class.forName(valueAsString);
        }
        catch (ClassNotFoundException e) {
            throw new HolmosReflectAssertError("\u83b7\u5f97" + valueAsString + "\u7c7b\u5931\u8d25!");
        }
    }
}

