/*
 * Decompiled with CFR 0.152.
 */
package com.holmos.webtest;

import com.holmos.webtest.EngineType;
import com.thoughtworks.selenium.DefaultSelenium;
import org.openqa.selenium.android.AndroidDriver;
import org.openqa.selenium.chrome.ChromeDriver;
import org.openqa.selenium.firefox.FirefoxDriver;
import org.openqa.selenium.firefox.FirefoxProfile;
import org.openqa.selenium.htmlunit.HtmlUnitDriver;
import org.openqa.selenium.ie.InternetExplorerDriver;
import org.openqa.selenium.iphone.IPhoneDriver;
import org.openqa.selenium.safari.SafariDriver;

public class SeleniumDriver {
    private static final String defaultHost = "localhost";
    private static final int defaultPort = 4444;
    private static final String seleniumIE = "*iexplore";
    private static final String seleniumFirefox = "*firefox";
    private static final String seleniumChrome = "*googlechrome";
    private static final String seleniumSafari = "*safari";
    private static final String seleniumOpera = "*opera";
    private Object engine;
    private EngineType type;

    public EngineType getType() {
        return this.type;
    }

    public Object getEngine() {
        return this.engine;
    }

    private SeleniumDriver(Object engine) {
        this.engine = engine == null ? new InternetExplorerDriver() : engine;
    }

    public static SeleniumDriver createSeleniumIEEngine(String url) {
        SeleniumDriver driver = new SeleniumDriver(new DefaultSelenium(defaultHost, 4444, seleniumIE, url));
        driver.type = EngineType.SeleniumIE;
        return driver;
    }

    public static SeleniumDriver createSeleniumFireFoxEngine(String url) {
        SeleniumDriver driver = new SeleniumDriver(new DefaultSelenium(defaultHost, 4444, seleniumFirefox, url));
        driver.type = EngineType.SeleniumFirefox;
        return driver;
    }

    public static SeleniumDriver createSeleniumChromeEngine(String url) {
        SeleniumDriver driver = new SeleniumDriver(new DefaultSelenium(defaultHost, 4444, seleniumChrome, url));
        driver.type = EngineType.SeleniumChrome;
        return driver;
    }

    public static SeleniumDriver createSeleniumSafariEngine(String url) {
        SeleniumDriver driver = new SeleniumDriver(new DefaultSelenium(defaultHost, 4444, seleniumSafari, url));
        driver.type = EngineType.SeleniumSafari;
        return driver;
    }

    public static SeleniumDriver createSeleniumOperaEngine(String url) {
        SeleniumDriver driver = new SeleniumDriver(new DefaultSelenium(defaultHost, 4444, seleniumOpera, url));
        driver.type = EngineType.SeleniumOpera;
        return driver;
    }

    public static SeleniumDriver createWebDriverIEEngine() {
        SeleniumDriver driver = new SeleniumDriver(new InternetExplorerDriver());
        driver.type = EngineType.WebDriverIE;
        return driver;
    }

    public static SeleniumDriver createWebDriverSafariEngine() {
        SeleniumDriver driver = new SeleniumDriver(new SafariDriver());
        driver.type = EngineType.WebDriverSafari;
        return driver;
    }

    public static SeleniumDriver createWebDriverFireFoxEngine() {
        SeleniumDriver driver = new SeleniumDriver(new FirefoxDriver());
        driver.type = EngineType.WebDriverFirefox;
        return driver;
    }

    public static SeleniumDriver createWebDriverFireFoxEngineWithProfile(FirefoxProfile profile) {
        SeleniumDriver driver = new SeleniumDriver(new FirefoxDriver(profile));
        driver.type = EngineType.WebDriverFirefox;
        return driver;
    }

    public static SeleniumDriver createWebDriverChromeEngine() {
        SeleniumDriver driver = new SeleniumDriver(new ChromeDriver());
        driver.type = EngineType.WebDriverChrome;
        return driver;
    }

    public static SeleniumDriver createWebDriverAndroidEngine() {
        SeleniumDriver driver = new SeleniumDriver(new AndroidDriver());
        driver.type = EngineType.WebDriverAndroid;
        return driver;
    }

    public static SeleniumDriver createWebDriverIphoneEngine() {
        SeleniumDriver driver = null;
        try {
            driver = new SeleniumDriver(new IPhoneDriver());
            driver.type = EngineType.WebDriverIphone;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return driver;
    }

    public static SeleniumDriver createWebDriverHtmlUnitEngine() {
        SeleniumDriver driver = new SeleniumDriver(new HtmlUnitDriver(true));
        driver.type = EngineType.HtmlUnit;
        return driver;
    }

    public static SeleniumDriver createSeleniumEngine(EngineType enginetype, String url) {
        switch (enginetype) {
            case SeleniumIE: {
                return SeleniumDriver.createSeleniumChromeEngine(url);
            }
            case SeleniumFirefox: {
                return SeleniumDriver.createSeleniumFireFoxEngine(url);
            }
            case SeleniumChrome: {
                return SeleniumDriver.createSeleniumChromeEngine(url);
            }
            case SeleniumOpera: {
                return SeleniumDriver.createSeleniumOperaEngine(url);
            }
            case SeleniumSafari: {
                return SeleniumDriver.createSeleniumSafariEngine(url);
            }
        }
        return null;
    }

    public static SeleniumDriver createWebDriverEngine(EngineType enginetype) {
        switch (enginetype) {
            case WebDriverIE: {
                return SeleniumDriver.createWebDriverIEEngine();
            }
            case WebDriverFirefox: {
                return SeleniumDriver.createWebDriverFireFoxEngine();
            }
            case WebDriverChrome: {
                return SeleniumDriver.createWebDriverChromeEngine();
            }
            case WebDriverSafari: {
                return SeleniumDriver.createWebDriverSafariEngine();
            }
            case WebDriverIphone: {
                return SeleniumDriver.createWebDriverIphoneEngine();
            }
            case WebDriverAndroid: {
                return SeleniumDriver.createWebDriverAndroidEngine();
            }
            case HtmlUnit: {
                return SeleniumDriver.createWebDriverHtmlUnitEngine();
            }
        }
        return null;
    }

    public static SeleniumDriver createEngine(EngineType enginetype, String url) {
        switch (enginetype) {
            case SeleniumIE: 
            case SeleniumFirefox: 
            case SeleniumChrome: 
            case SeleniumSafari: 
            case SeleniumOpera: {
                return SeleniumDriver.createSeleniumEngine(enginetype, url);
            }
            case WebDriverIE: 
            case WebDriverFirefox: 
            case WebDriverChrome: 
            case WebDriverSafari: 
            case WebDriverAndroid: 
            case WebDriverIphone: 
            case HtmlUnit: {
                return SeleniumDriver.createWebDriverEngine(enginetype);
            }
        }
        return null;
    }
}

