/*
 * Decompiled with CFR 0.152.
 */
package com.holmos.webtest.css;

import com.holmos.webtest.asserttool.HolmosSimpleCheckTool;
import com.holmos.webtest.constvalue.ConfigConstValue;
import com.holmos.webtest.element.Element;
import com.holmos.webtest.element.Image;
import com.holmos.webtest.exceptions.HolmosFailedError;
import com.holmos.webtest.log.MyLogger;
import com.holmos.webtest.utils.HolmosBaseUtils;
import com.holmos.webtest.utils.HolmosPropertiesUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Properties;
import org.openqa.selenium.Dimension;
import org.openqa.selenium.Point;

public class HolmosCSSTool {
    private static MyLogger logger = MyLogger.getLogger(HolmosBaseUtils.class);
    private static Properties cssCommanPropertiesConfig = HolmosPropertiesUtils.getPropertiesFromClassPath(ConfigConstValue.CSSPROPERTIESCONFIG);
    private static Properties imgCssPropertiesConfig = HolmosPropertiesUtils.getPropertiesFromClassPath(ConfigConstValue.IMGCSSPROPERTIESCONFIG);

    static {
        HolmosBaseUtils.configLogProperties();
    }

    private static Properties getCSSValueFromLocal(Element element) {
        String cssFilePath = "D:\\holmos\\css\\" + element.getFullName() + ".properties";
        return HolmosPropertiesUtils.getPropertyInfo(cssFilePath);
    }

    private static Properties getImgCssValues(Element element) {
        Properties imgCssProperties = new Properties();
        Iterator<Object> imgCssKeyIterator = imgCssPropertiesConfig.keySet().iterator();
        if (element.isExist()) {
            while (imgCssKeyIterator.hasNext()) {
                String cssKey = (String)imgCssKeyIterator.next();
                if (!HolmosPropertiesUtils.getBoolean(imgCssPropertiesConfig, cssKey)) continue;
                imgCssProperties.put(cssKey, element.getElement().getCssValue(cssKey));
            }
        }
        return imgCssProperties;
    }

    private static Properties getCommCssValues(Element element) {
        Properties comCssProperties = new Properties();
        Iterator<Object> imgCssKeyIterator = cssCommanPropertiesConfig.keySet().iterator();
        if (element.isExist()) {
            while (imgCssKeyIterator.hasNext()) {
                String cssKey = (String)imgCssKeyIterator.next();
                if (!HolmosPropertiesUtils.getBoolean(cssCommanPropertiesConfig, cssKey)) continue;
                comCssProperties.put(cssKey, element.getElement().getCssValue(cssKey));
            }
        }
        return comCssProperties;
    }

    private static Properties getCssValuesFromEngine(Element element) {
        if (element instanceof Image) {
            return HolmosCSSTool.getImgCssValues(element);
        }
        return HolmosCSSTool.getCommCssValues(element);
    }

    public static Properties getCSSValues(Element element) {
        Properties cssProperties = HolmosCSSTool.getCSSValueFromLocal(element);
        if (cssProperties != null) {
            return cssProperties;
        }
        cssProperties = HolmosCSSTool.getCssValuesFromEngine(element);
        HolmosPropertiesUtils.savePropertiesFile(cssProperties, "D:\\holmos\\css\\" + element.getFullName(), String.valueOf(element.getFullName()) + "css\u5c5e\u6027\u4fe1\u606f");
        return cssProperties;
    }

    public static String getCssValue(Element element, String cssValueKey) {
        if (element.isExist()) {
            return element.getCSSValue(cssValueKey);
        }
        return null;
    }

    private ArrayList<Point> getLocations(ArrayList<Element> elements) {
        ArrayList<Point> locations = new ArrayList<Point>();
        for (Element element : elements) {
            locations.add(element.getLocation());
        }
        return locations;
    }

    private ArrayList<Dimension> getSizes(ArrayList<Element> elements) {
        ArrayList<Dimension> sizes = new ArrayList<Dimension>();
        for (Element element : elements) {
            sizes.add(element.getSize());
        }
        return sizes;
    }

    public void assertTopAlign(ArrayList<Element> elements) {
        ArrayList<Point> locations = this.getLocations(elements);
        int i = 1;
        while (i < locations.size()) {
            if (locations.get((int)i).x != locations.get((int)0).x) {
                StringBuilder message = new StringBuilder("\u4e0a\u8fb9\u754c\u5bf9\u9f50\u6821\u9a8c\u5931\u8d25:\n");
                int j = 0;
                while (j < locations.size()) {
                    message.append(String.valueOf(elements.get(j).getComment()) + "\u7684\u4e0a\u8fb9\u754c\u4f4d\u7f6e:" + locations.get((int)j).x + "\n");
                    ++j;
                }
                throw new HolmosFailedError(message.toString());
            }
            ++i;
        }
        logger.info("\u4e0a\u8fb9\u754c\u6821\u9a8c\u6210\u529f!");
    }

    public void assertLeftAlign(ArrayList<Element> elements) {
        ArrayList<Point> locations = this.getLocations(elements);
        int i = 1;
        while (i < locations.size()) {
            if (locations.get((int)i).y != locations.get((int)0).y) {
                StringBuilder message = new StringBuilder("\u5de6\u8fb9\u754c\u5bf9\u9f50\u6821\u9a8c\u5931\u8d25:\n");
                int j = 0;
                while (j < locations.size()) {
                    message.append(String.valueOf(elements.get(j).getComment()) + "\u7684\u505a\u8fb9\u754c\u4f4d\u7f6e:" + locations.get((int)j).y + "\n");
                    ++j;
                }
                throw new HolmosFailedError(message.toString());
            }
            ++i;
        }
        logger.info("\u5de6\u8fb9\u754c\u6821\u9a8c\u6210\u529f!");
    }

    public void assertRightAlign(ArrayList<Element> elements) {
        ArrayList<Point> locations = this.getLocations(elements);
        ArrayList<Dimension> sizes = this.getSizes(elements);
        int i = 1;
        while (i < locations.size()) {
            if (locations.get((int)i).x + sizes.get((int)i).width != locations.get((int)0).x + sizes.get((int)0).width) {
                StringBuilder message = new StringBuilder("\u53f3\u8fb9\u754c\u5bf9\u9f50\u6821\u9a8c\u5931\u8d25:\n");
                int j = 0;
                while (j < locations.size()) {
                    message.append(String.valueOf(elements.get(j).getComment()) + "\u7684\u53f3\u8fb9\u754c\u4f4d\u7f6e:" + locations.get((int)j).x + sizes.get((int)j).width + "\n");
                    ++j;
                }
                throw new HolmosFailedError(message.toString());
            }
            ++i;
        }
        logger.info("\u53f3\u8fb9\u754c\u6821\u9a8c\u6210\u529f!");
    }

    public void assertBottomAlign(ArrayList<Element> elements) {
        ArrayList<Point> locations = this.getLocations(elements);
        ArrayList<Dimension> sizes = this.getSizes(elements);
        int i = 1;
        while (i < locations.size()) {
            if (locations.get((int)i).y + sizes.get((int)i).height != locations.get((int)0).y + sizes.get((int)0).height) {
                StringBuilder message = new StringBuilder("\u4e0b\u8fb9\u754c\u5bf9\u9f50\u6821\u9a8c\u5931\u8d25:\n");
                int j = 0;
                while (j < locations.size()) {
                    message.append(String.valueOf(elements.get(j).getComment()) + "\u7684\u4e0b\u8fb9\u754c\u4f4d\u7f6e:" + locations.get((int)j).y + sizes.get((int)j).height + "\n");
                    ++j;
                }
                throw new HolmosFailedError(message.toString());
            }
            ++i;
        }
        logger.info("\u4e0b\u8fb9\u754c\u6821\u9a8c\u6210\u529f!");
    }

    public void assertColorEquals(ArrayList<Element> elements) {
        ArrayList<String> colors = new ArrayList<String>();
        for (Element element : elements) {
            colors.add(element.getCSSValue("color"));
        }
        StringBuilder message = new StringBuilder();
        if (colors.get(0) == null) {
            throw new HolmosFailedError(String.valueOf(elements.get(0).getComment()) + "color\u5c5e\u6027\u83b7\u53d6\u4e0d\u5230~");
        }
        int i = 0;
        while (i < colors.size()) {
            if (!((String)colors.get(i)).equalsIgnoreCase((String)colors.get(0))) {
                int j = 0;
                while (j < colors.size()) {
                    message.append(String.valueOf(elements.get(j).getComment()) + "\u7684\u989c\u8272:" + (String)colors.get(j) + "\n");
                    ++j;
                }
                throw new HolmosFailedError(message.toString());
            }
            ++i;
        }
        logger.info("\u989c\u8272\u6821\u9a8c\u6210\u529f~!");
    }

    public void assertHorizonBigger(ArrayList<Element> elements) {
        ArrayList<Point> locations = this.getLocations(elements);
        StringBuilder message = new StringBuilder();
        int i = 1;
        while (i < locations.size()) {
            if (locations.get((int)i).x < locations.get((int)(i - 1)).x) {
                message.append("\u5143\u7d20\u6a2a\u5750\u6807\u4f9d\u6b21\u9012\u589e\u6821\u9a8c\u5931\u8d25!\n");
                int j = 0;
                while (j < locations.size()) {
                    message.append(String.valueOf(elements.get(j).getComment()) + "\u7684\u6a2a\u5750\u6807\u4e3a:" + locations.get((int)j).x + "\n");
                    ++j;
                }
                throw new HolmosFailedError(message.toString());
            }
            ++i;
        }
        logger.info("\u5143\u7d20\u6a2a\u5750\u6807\u4f9d\u6b21\u9012\u589e\u6821\u9a8c\u6210\u529f~!");
    }

    public void assertHorizonSmaller(ArrayList<Element> elements) {
        ArrayList<Point> locations = this.getLocations(elements);
        StringBuilder message = new StringBuilder();
        int i = 1;
        while (i < locations.size()) {
            if (locations.get((int)i).x > locations.get((int)(i - 1)).x) {
                message.append("\u5143\u7d20\u6a2a\u5750\u6807\u4f9d\u6b21\u9012\u51cf\u6821\u9a8c\u5931\u8d25!\n");
                int j = 0;
                while (j < locations.size()) {
                    message.append(String.valueOf(elements.get(j).getComment()) + "\u7684\u6a2a\u5750\u6807\u4e3a:" + locations.get((int)j).x + "\n");
                    ++j;
                }
                throw new HolmosFailedError(message.toString());
            }
            ++i;
        }
        logger.info("\u5143\u7d20\u6a2a\u5750\u6807\u4f9d\u6b21\u9012\u51cf\u6821\u9a8c\u6210\u529f~!");
    }

    public void assertVerticalBigger(ArrayList<Element> elements) {
        ArrayList<Point> locations = this.getLocations(elements);
        StringBuilder message = new StringBuilder();
        int i = 1;
        while (i < locations.size()) {
            if (locations.get((int)i).y < locations.get((int)(i - 1)).y) {
                message.append("\u5143\u7d20\u6a2a\u5750\u6807\u4f9d\u6b21\u9012\u589e\u6821\u9a8c\u5931\u8d25!\n");
                int j = 0;
                while (j < locations.size()) {
                    message.append(String.valueOf(elements.get(j).getComment()) + "\u7684\u7eb5\u5750\u6807\u4e3a:" + locations.get((int)j).y + "\n");
                    ++j;
                }
                throw new HolmosFailedError(message.toString());
            }
            ++i;
        }
        logger.info("\u5143\u7d20\u6a2a\u5750\u6807\u4f9d\u6b21\u9012\u589e\u6821\u9a8c\u6210\u529f~!");
    }

    public void assertVerticalSmaller(ArrayList<Element> elements) {
        ArrayList<Point> locations = this.getLocations(elements);
        StringBuilder message = new StringBuilder();
        int i = 1;
        while (i < locations.size()) {
            if (locations.get((int)i).y > locations.get((int)(i - 1)).y) {
                message.append("\u5143\u7d20\u6a2a\u5750\u6807\u4f9d\u6b21\u9012\u51cf\u6821\u9a8c\u5931\u8d25!\n");
                int j = 0;
                while (j < locations.size()) {
                    message.append(String.valueOf(elements.get(j).getComment()) + "\u7684\u7eb5\u5750\u6807\u4e3a:" + locations.get((int)j).y + "\n");
                    ++j;
                }
                throw new HolmosFailedError(message.toString());
            }
            ++i;
        }
        logger.info("\u5143\u7d20\u6a2a\u5750\u6807\u4f9d\u6b21\u9012\u51cf\u6821\u9a8c\u6210\u529f~!");
    }

    public void assertCssValue(Element element, String cssKey) {
        Properties localProperties = HolmosCSSTool.getCSSValueFromLocal(element);
        if (element instanceof Image) {
            if (!HolmosPropertiesUtils.getBoolean(imgCssPropertiesConfig, cssKey)) {
                logger.warn(String.valueOf(cssKey) + "\u5728\u8bbe\u7f6e\u4e2d\u4e0d\u505a\u6821\u9a8c,\u5728\u672c\u5730\u7684css\u5c5e\u6027\u6587\u4ef6\u4e2d\u6ca1\u6709\u8be5\u5c5e\u6027\u4fe1\u606f");
                return;
            }
            String engineCssValue = HolmosCSSTool.getCssValue(element, cssKey);
            String localCssValue = HolmosPropertiesUtils.getValue(localProperties, cssKey);
            HolmosSimpleCheckTool.assertEqual(engineCssValue, localCssValue);
        } else {
            if (!HolmosPropertiesUtils.getBoolean(cssCommanPropertiesConfig, cssKey)) {
                logger.warn(String.valueOf(cssKey) + "\u5728\u8bbe\u7f6e\u4e2d\u4e0d\u505a\u6821\u9a8c,\u5728\u672c\u5730\u7684css\u5c5e\u6027\u6587\u4ef6\u4e2d\u6ca1\u6709\u8be5\u5c5e\u6027\u4fe1\u606f");
                return;
            }
            String engineCssValue = HolmosCSSTool.getCssValue(element, cssKey);
            String localCssValue = HolmosPropertiesUtils.getValue(localProperties, cssKey);
            HolmosSimpleCheckTool.assertEqual(engineCssValue, localCssValue);
        }
    }

    public void assertAllCssValues(Element element) {
    }

    public void assertSizesEquals(ArrayList<Element> elements) {
        ArrayList<Dimension> sizes = this.getSizes(elements);
        StringBuilder message = new StringBuilder();
        int i = 1;
        while (i < sizes.size()) {
            if (!sizes.get(i).equals((Object)sizes.get(0))) {
                message.append("\u5143\u7d20\u5927\u5c0f\u6821\u9a8c\u5931\u8d25:\n");
                int j = 0;
                while (j < sizes.size()) {
                    message.append(String.valueOf(elements.get(j).getComment()) + "\u7684\u5c0f\u5c0f\u4e3a:" + sizes.get(j).toString());
                    ++j;
                }
                logger.error(message);
                throw new HolmosFailedError(message.toString());
            }
            ++i;
        }
        message.append("\u5143\u7d20\u5927\u5c0f\u6821\u9a8c\u6210\u529f!");
    }
}

