/*
 * Decompiled with CFR 0.152.
 */
package com.holmos.webtest.element;

import com.holmos.webtest.Allocator;
import com.holmos.webtest.BrowserWindow;
import com.holmos.webtest.SeleniumBrowserWindow;
import com.holmos.webtest.WebDriverBrowserWindow;
import com.holmos.webtest.element.Element;
import com.thoughtworks.selenium.Selenium;

public class TextField
extends Element {
    public TextField(String comment) {
        super(comment);
    }

    public void setText(String value) {
        StringBuilder message = new StringBuilder();
        BrowserWindow currentWindow = Allocator.getInstance().currentWindow;
        if (this.isExist()) {
            message.append(String.valueOf(this.wholeComment) + ":");
            if (currentWindow instanceof SeleniumBrowserWindow) {
                ((Selenium)currentWindow.getDriver().getEngine()).type(this.locator.getSeleniumCurrentLocator(), value);
            } else if (currentWindow instanceof WebDriverBrowserWindow) {
                this.element.clear();
                this.element.sendKeys(new CharSequence[]{value});
            }
            message.append("\u8bbe\u7f6e\u503c\u6210\u529f!");
            this.logger.info(message);
        } else {
            message.append(String.valueOf(this.wholeComment) + ":");
            message.append("\u8bbe\u7f6e\u503c\u5931\u8d25!\u627e\u4e0d\u5230\u5143\u7d20!");
            this.logger.error(message);
        }
    }

    @Override
    public String getText() {
        StringBuilder message = new StringBuilder();
        BrowserWindow currentWindow = Allocator.getInstance().currentWindow;
        String content = null;
        if (this.isExist()) {
            message.append(String.valueOf(this.wholeComment) + ":");
            if (currentWindow instanceof SeleniumBrowserWindow) {
                content = ((Selenium)currentWindow.getDriver().getEngine()).getValue(this.locator.getSeleniumCurrentLocator());
            } else if (currentWindow instanceof WebDriverBrowserWindow) {
                content = this.element.getAttribute("value");
            }
            message.append("\u83b7\u5f97\u8f93\u5165\u6846\u6587\u672c\u5185\u5bb9\u6210\u529f!");
            this.logger.info(message);
        } else {
            message.append(String.valueOf(this.wholeComment) + ":");
            message.append("\u83b7\u5f97\u8f93\u5165\u6846\u6587\u672c\u5185\u5bb9\u5931\u8d25!\u627e\u4e0d\u5230\u5143\u7d20");
            this.logger.error(message);
        }
        return content;
    }

    public void clear() {
        StringBuilder message = new StringBuilder();
        BrowserWindow currentWindow = Allocator.getInstance().currentWindow;
        if (this.isExist()) {
            message.append(String.valueOf(this.wholeComment) + ":");
            if (currentWindow instanceof SeleniumBrowserWindow) {
                ((Selenium)currentWindow.getDriver().getEngine()).type(this.locator.getSeleniumCurrentLocator(), "");
            } else if (currentWindow instanceof WebDriverBrowserWindow) {
                this.element.clear();
            }
            message.append("\u8f93\u5165\u6846\u7684\u503c\u6e05\u7a7a\u6210\u529f!");
            this.logger.info(message);
        } else {
            message.append(String.valueOf(this.wholeComment) + ":");
            message.append("\u8f93\u5165\u6846\u7684\u503c\u6e05\u7a7a\u5931\u8d25!\u627e\u4e0d\u5230\u5143\u7d20");
            this.logger.error(message);
        }
    }
}

