/*
 * Decompiled with CFR 0.152.
 */
package com.holmos.webtest.element.locator;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class Locator {
    private String seleniumCurrentLocator;
    private Map<String, String> locators = new HashMap<String, String>();
    private Map<String, String> attributes = new HashMap<String, String>();

    public String getSeleniumCurrentLocator() {
        return this.seleniumCurrentLocator;
    }

    public void setSeleniumCurrentLocator(String seleniumCurrentLocator) {
        this.seleniumCurrentLocator = seleniumCurrentLocator;
    }

    public void addIdLocator(String id) {
        this.locators.put("id", id);
    }

    public void addNameLocator(String name) {
        this.locators.put("name", name);
    }

    public void addXpathLocator(String xpath) {
        this.locators.put("xpath", xpath);
    }

    public void addCSSLocator(String css) {
        this.locators.put("css", css);
    }

    public void addLinkTextLocator(String linkText) {
        this.locators.put("linktext", linkText);
    }

    public void addPartialLinkTextLocator(String partialLinkText) {
        this.locators.put("partiallinktext", partialLinkText);
    }

    public void addTagNameLocator(String tagName) {
        this.locators.put("tagname", tagName);
    }

    public void addRegularLocator(String regular) {
        this.locators.put("regular", regular);
    }

    public void addClassLocator(String className) {
        this.locators.put("class", className);
    }

    public void addAttributeLocator(String attributeName, String attributeValue) {
        this.attributes.put(attributeName, attributeValue);
    }

    public String getLocator(String locatorType) {
        return this.locators.get(locatorType);
    }

    public String getLocatorById() {
        return this.locators.get("id");
    }

    public String getLocatorByName() {
        return this.locators.get("name");
    }

    public String getLocatorByXpath() {
        return this.locators.get("xpath");
    }

    public String getLocatorByCSS() {
        return this.locators.get("css");
    }

    public String getLocatorByLinkText() {
        return this.locators.get("linktext");
    }

    public String getLocatorByPartialLinkText() {
        return this.locators.get("partiallinktext");
    }

    public String getLocatorByRegular() {
        return this.locators.get("regular");
    }

    public String getLocatorByTagName() {
        return this.locators.get("tagname");
    }

    public String getLocatorByClass() {
        return this.locators.get("class");
    }

    public String getXpathFromTagName() {
        if (this.locators.get("tagname") != null) {
            return ".//" + this.locators.get("tagname");
        }
        return null;
    }

    public String getXpathFromId() {
        if (this.locators.get("id") != null) {
            return ".//*[@id='" + this.locators.get("id") + "']";
        }
        return null;
    }

    public String getXpathFromName() {
        if (this.locators.get("name") != null) {
            return ".//*[@name='" + this.locators.get("name") + "']";
        }
        return null;
    }

    public String getXpathFromClass() {
        if (this.locators.get("class") != null) {
            return ".//*[@class='" + this.locators.get("class") + "']";
        }
        return null;
    }

    public String getXpathFromLinkText() {
        if (this.locators.get("linktext") != null) {
            return ".//*[text()='" + this.locators.get("linktext") + "']";
        }
        return null;
    }

    public String getXpathFromPartialLinkText() {
        if (this.locators.get("partiallinktext") != null) {
            return ".//*[contains(text(),'" + this.locators.get("partiallinktext") + "')]";
        }
        return null;
    }

    public String getXpathFromAttribute() {
        StringBuilder xpath = new StringBuilder();
        if (this.attributes.size() != 0) {
            Set<String> keys = this.attributes.keySet();
            Iterator<String> it = keys.iterator();
            String key = it.next();
            xpath.append(".//*[@" + key + "='" + this.attributes.get(key) + "' ");
            while (it.hasNext()) {
                key = it.next();
                xpath.append("and @" + key + "='" + this.attributes.get(key) + "' ");
            }
            xpath.append("]");
            return xpath.toString();
        }
        return null;
    }
}

