/*
 * Decompiled with CFR 0.152.
 */
package com.holmos.webtest.element.tool;

import com.holmos.webtest.Allocator;
import com.holmos.webtest.element.locator.Locator;
import com.holmos.webtest.element.locator.LocatorValue;
import com.holmos.webtest.element.tool.WebElementExist;
import com.holmos.webtest.struct.Collection;
import com.holmos.webtest.struct.Frame;
import com.holmos.webtest.struct.Page;
import com.thoughtworks.selenium.Selenium;
import java.util.ArrayList;

public class SeleniumElementExist
extends WebElementExist {
    private String currentLocator;
    private ArrayList<String> locators = new ArrayList();
    private Selenium selenium;

    public SeleniumElementExist(LocatorValue webElement) {
        super(webElement);
        this.selenium = (Selenium)Allocator.getInstance().currentWindow.getDriver().getEngine();
    }

    @Override
    public boolean isElementExistForCheckOnce() {
        LocatorValue lastNode = this.infoChain.getInfoNodes().get(this.infoChain.getInfoNodes().size() - 1);
        if (lastNode instanceof Page || lastNode instanceof Frame) {
            return this.findOneLevelElement(1);
        }
        return this.findMuiltiLevelElement(1);
    }

    @Override
    public boolean isElementExist(int waitCount) {
        this.initComment();
        LocatorValue lastNode = this.infoChain.getInfoNodes().get(this.infoChain.getInfoNodes().size() - 1);
        if (lastNode instanceof Page || lastNode instanceof Frame) {
            return this.findOneLevelElement(waitCount);
        }
        return this.findMuiltiLevelElement(waitCount);
    }

    private boolean findMuiltiLevelElement(int waitCount) {
        int i = 0;
        while (i < waitCount) {
            if (this.findMuiltiLevelElment()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean findMuiltiLevelElment() {
        int startLevel = this.infoChain.getInfoNodes().size() - 1;
        while (startLevel > 1) {
            if (this.infoChain.getInfoNodes().get(startLevel) instanceof Frame) {
                ++startLevel;
                break;
            }
            --startLevel;
        }
        this.infoChain.addNode(this.webElement);
        this.getAllLocaors(startLevel, "");
        int i = 0;
        while (i < this.locators.size()) {
            if (this.selenium.isElementPresent("xpath=" + this.locators.get(i))) {
                this.webElement.setLocatorCurrent("xpath=" + this.locators.get(i));
                return true;
            }
            ++i;
        }
        return false;
    }

    private void getAllLocaors(int level, String locatorTemp) {
        if (level >= this.infoChain.getInfoNodes().size()) {
            return;
        }
        if (level == this.infoChain.getInfoNodes().size() - 1) {
            if (this.locator.getLocatorById() != null && this.locator.getLocatorById() != "") {
                locatorTemp = String.valueOf(locatorTemp) + this.locator.getXpathFromId();
                this.locators.add(locatorTemp);
            }
            if (this.locator.getLocatorByName() != null && this.locator.getLocatorByName() != "") {
                locatorTemp = String.valueOf(locatorTemp) + this.locator.getXpathFromName();
                this.locators.add(locatorTemp);
            }
            if (this.locator.getLocatorByXpath() != null && this.locator.getLocatorByXpath() != "") {
                locatorTemp = String.valueOf(locatorTemp) + this.locator.getLocatorByXpath();
                this.locators.add(locatorTemp);
            }
            if (this.locator.getLocatorByLinkText() != null && this.locator.getLocatorByLinkText() != "") {
                locatorTemp = String.valueOf(locatorTemp) + this.locator.getXpathFromLinkText();
                this.locators.add(locatorTemp);
            }
            if (this.locator.getLocatorByPartialLinkText() != null && this.locator.getLocatorByPartialLinkText() != "") {
                locatorTemp = String.valueOf(locatorTemp) + this.locator.getXpathFromPartialLinkText();
                this.locators.add(locatorTemp);
            }
        } else {
            Locator locatorCurrent = this.infoChain.getInfoNodes().get(level).getLocator();
            if (locatorCurrent.getLocatorById() != null && locatorCurrent.getLocatorById() != "") {
                locatorTemp = String.valueOf(locatorTemp) + this.locator.getXpathFromId();
                if (this.infoChain.getInfoNodes().get(level) instanceof Collection) {
                    locatorTemp = String.valueOf(locatorTemp) + "[" + ((Collection)this.infoChain.getInfoNodes().get(level)).getIndex() + "]";
                }
                this.getAllLocaors(level + 1, locatorTemp);
            }
            if (locatorCurrent.getLocatorByName() != null && locatorCurrent.getLocatorByName() != "") {
                locatorTemp = String.valueOf(locatorTemp) + this.locator.getXpathFromName();
                if (this.infoChain.getInfoNodes().get(level) instanceof Collection) {
                    locatorTemp = String.valueOf(locatorTemp) + "[" + ((Collection)this.infoChain.getInfoNodes().get(level)).getIndex() + "]";
                }
                this.getAllLocaors(level + 1, locatorTemp);
            }
            if (locatorCurrent.getLocatorByXpath() != null && locatorCurrent.getLocatorByXpath() != "") {
                locatorTemp = String.valueOf(locatorTemp) + this.locator.getLocatorByXpath();
                if (this.infoChain.getInfoNodes().get(level) instanceof Collection) {
                    locatorTemp = String.valueOf(locatorTemp) + "[" + ((Collection)this.infoChain.getInfoNodes().get(level)).getIndex() + "]";
                }
                this.getAllLocaors(level + 1, locatorTemp);
            }
            if (locatorCurrent.getLocatorByLinkText() != null && locatorCurrent.getLocatorByLinkText() != "") {
                locatorTemp = String.valueOf(locatorTemp) + this.locator.getXpathFromLinkText();
                if (this.infoChain.getInfoNodes().get(level) instanceof Collection) {
                    locatorTemp = String.valueOf(locatorTemp) + "[" + ((Collection)this.infoChain.getInfoNodes().get(level)).getIndex() + "]";
                }
                this.getAllLocaors(level + 1, locatorTemp);
            }
            if (locatorCurrent.getLocatorByPartialLinkText() != null && locatorCurrent.getLocatorByPartialLinkText() != "") {
                locatorTemp = String.valueOf(locatorTemp) + this.locator.getXpathFromPartialLinkText();
                if (this.infoChain.getInfoNodes().get(level) instanceof Collection) {
                    locatorTemp = String.valueOf(locatorTemp) + "[" + ((Collection)this.infoChain.getInfoNodes().get(level)).getIndex() + "]";
                }
                this.getAllLocaors(level + 1, locatorTemp);
            }
        }
    }

    private boolean findOneLevelElement(int waitCount) {
        int i = 0;
        while (i < waitCount) {
            if (this.findOneLevelElement(this.locator)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean findOneLevelElement(Locator locator) {
        boolean isExist = false;
        if (!isExist) {
            isExist = this.findElementById(locator.getLocatorById());
        }
        if (!isExist) {
            isExist = this.findElementByName(locator.getLocatorByName());
        }
        if (!isExist) {
            isExist = this.findElementByXpath(locator.getLocatorByXpath());
        }
        if (!isExist) {
            isExist = this.findElementByCss(locator.getLocatorByCSS());
        }
        if (!isExist) {
            isExist = this.findElementByLinkText(locator.getLocatorByLinkText());
        }
        if (!isExist) {
            isExist = this.findElementByRegularLinkText(locator.getLocatorByRegular());
        }
        return isExist;
    }

    private boolean findElementByRegularLinkText(String locatorByRegular) {
        if (this.locator.getLocatorByRegular() != null && !"".equalsIgnoreCase(this.locator.getLocatorByRegular()) && this.selenium.isElementPresent("link=glob:" + this.locator.getLocatorByRegular())) {
            this.currentLocator = "link=glob:" + this.locator.getLocatorByRegular();
            this.webElement.setLocatorCurrent(this.currentLocator);
            return true;
        }
        return false;
    }

    private boolean findElementByLinkText(String locatorByLinkText) {
        if (this.locator.getLocatorByLinkText() != null && !"".equalsIgnoreCase(this.locator.getLocatorByLinkText()) && this.selenium.isElementPresent("link=" + this.locator.getLocatorByLinkText())) {
            this.currentLocator = "link=" + this.locator.getLocatorByLinkText();
            this.webElement.setLocatorCurrent(this.currentLocator);
            return true;
        }
        return false;
    }

    private boolean findElementByCss(String locatorByCSS) {
        if (this.locator.getLocatorByCSS() != null && !"".equalsIgnoreCase(this.locator.getLocatorByCSS()) && this.selenium.isElementPresent("css=" + this.locator.getLocatorByCSS())) {
            this.currentLocator = "css=" + this.locator.getLocatorByCSS();
            this.webElement.setLocatorCurrent(this.currentLocator);
            return true;
        }
        return false;
    }

    private boolean findElementByXpath(String locatorByXpath) {
        if (this.locator.getLocatorByLinkText() != null && !"".equalsIgnoreCase(this.locator.getLocatorByLinkText()) && this.selenium.isElementPresent("link=" + this.locator.getLocatorByLinkText())) {
            this.currentLocator = "link=" + this.locator.getLocatorByLinkText();
            this.webElement.setLocatorCurrent(this.currentLocator);
            return true;
        }
        return false;
    }

    private boolean findElementByName(String locatorByName) {
        if (this.locator.getLocatorByName() != null && !"".equalsIgnoreCase(this.locator.getLocatorByName()) && this.selenium.isElementPresent("name=" + this.locator.getLocatorByName())) {
            this.currentLocator = "name=" + this.locator.getLocatorByName();
            this.webElement.setLocatorCurrent(this.currentLocator);
            return true;
        }
        return false;
    }

    private boolean findElementById(String locatorById) {
        if (this.locator.getLocatorById() != null && !"".equalsIgnoreCase(this.locator.getLocatorById()) && this.selenium.isElementPresent("id=" + this.locator.getLocatorById())) {
            this.currentLocator = "id=" + this.locator.getLocatorById();
            this.webElement.setLocatorCurrent(this.currentLocator);
            return true;
        }
        return false;
    }
}

