/*
 * Decompiled with CFR 0.152.
 */
package com.holmos.webtest.junitextentions.parameters.database;

import com.holmos.webtest.exceptions.HolmosFailedError;
import com.holmos.webtest.junitextentions.annotations.DataBase;
import com.holmos.webtest.junitextentions.parameters.database.ConnectionInfo;
import com.holmos.webtest.log.MyLogger;
import com.holmos.webtest.utils.HolmosAnnotationUtils;
import java.util.HashMap;

public class ConnectionInfoGetter {
    MyLogger logger = MyLogger.getLogger(ConnectionInfoGetter.class);
    private Class testClass;
    private HashMap<String, ConnectionInfo> connections;

    public ConnectionInfoGetter(Class testClass) {
        this.testClass = testClass;
        this.connections = new HashMap();
    }

    public ConnectionInfo getConnection(String connectionName) {
        if (this.connections.get(connectionName) != null) {
            return this.connections.get(connectionName);
        }
        this.getClassLevelDataBaseInfo();
        this.getAllMethodLevelDataBaseInfo();
        if (this.connections.get(connectionName) == null) {
            throw new HolmosFailedError("\u5728" + this.testClass + "\u6d4b\u8bd5\u7c7b\u4e2d\u6ca1\u6709" + connectionName + "\u6570\u636e\u5e93\u8fde\u63a5\u7684\u914d\u7f6e!");
        }
        return this.connections.get(connectionName);
    }

    private void getAllMethodLevelDataBaseInfo() {
        for (DataBase dataBase : HolmosAnnotationUtils.getMethodLevelAnnotations(this.testClass, DataBase.class)) {
            this.createConnectionInfo(dataBase);
        }
    }

    private void getClassLevelDataBaseInfo() {
        DataBase dataBase = HolmosAnnotationUtils.getClassLevelAnnotation(this.testClass, DataBase.class);
        this.createConnectionInfo(dataBase);
    }

    private void createConnectionInfo(DataBase dataBase) {
        String key;
        if (dataBase.url() == null || "".equalsIgnoreCase(dataBase.url())) {
            throw new HolmosFailedError(String.valueOf(this.testClass.toString()) + "Database\u6ce8\u89e3\u4e2d\u7684url\u5b57\u6bb5\u4e3anull\u6216\u8005\u7a7a\u7a9c!");
        }
        String string = key = dataBase.connectionName() == null ? dataBase.url() : dataBase.connectionName();
        if (this.connections.get(key) != null) {
            this.logger.warn("\u5728\u540c\u4e00\u4e2a\u7c7b\u91cc\u9762\u7684\u6570\u636e\u5e93\u8fde\u63a5\u914d\u7f6e\u91cd\u590d!");
        }
        this.connections.put(key, new ConnectionInfo(dataBase));
    }
}

