/*
 * Decompiled with CFR 0.152.
 */
package com.holmos.webtest.junitextentions.parameters.filepathanalysis.analysisimp;

import com.holmos.webtest.constvalue.ConfigConstValue;
import com.holmos.webtest.exceptions.HolmosFailedError;
import com.holmos.webtest.junitextentions.parameters.filepathanalysis.analysisimp.FilePathAnalysisRotot;
import java.io.File;

public class LocalFilePathAnalysisRobot
implements FilePathAnalysisRotot {
    private boolean usePackagePath;
    private String prefixPath;

    public LocalFilePathAnalysisRobot() {
        this(true, null);
    }

    public LocalFilePathAnalysisRobot(boolean usePackagePath, String prefixPath) {
        this.usePackagePath = usePackagePath;
        this.prefixPath = prefixPath;
    }

    @Override
    public String getFilePath(String fileName, Class<?> testClass) {
        if (fileName.contains(":")) {
            return fileName;
        }
        String fullFileName = this.makeFullFileName(fileName, testClass);
        File dataSourceFile = new File(fullFileName);
        if (!dataSourceFile.exists()) {
            throw new HolmosFailedError("\u65e0\u6cd5\u627e\u5230\u53c2\u6570\u6570\u636e\u6e90\u6587\u4ef6" + fullFileName);
        }
        return fullFileName;
    }

    private String makeFullFileName(String fileName, Class<?> testClass) {
        String pathWithPackage = fileName;
        if (this.usePackagePath && !fileName.startsWith("/")) {
            pathWithPackage = this.getPackagePath(fileName, testClass);
        }
        if (fileName.startsWith("/")) {
            pathWithPackage = fileName.substring(1);
        }
        if (this.prefixPath != null && this.prefixPath.trim() != null) {
            pathWithPackage = String.valueOf(this.prefixPath) + "/" + pathWithPackage;
        }
        return String.valueOf(System.getProperty("user.dir").replace('\\', '/')) + ConfigConstValue.CURRENTWORKTOPACKAGEPATH + pathWithPackage.replace('.', '/') + '/' + fileName;
    }

    private String getPackagePath(String fileName, Class<?> testClass) {
        if (testClass.getName().lastIndexOf(46) < 0) {
            return fileName;
        }
        String packagePath = testClass.getPackage().getName();
        return packagePath;
    }
}

