/*
 * Decompiled with CFR 0.152.
 */
package com.holmos.webtest.junitextentions.parameters.getter;

import com.holmos.webtest.exceptions.HolmosFailedError;
import com.holmos.webtest.junitextentions.parameters.excel.HolmosWorkBook;
import com.holmos.webtest.junitextentions.parameters.getter.AbstractDataGetter;
import java.util.ArrayList;

public final class ExcelDataGetter
extends AbstractDataGetter {
    private HolmosWorkBook workBook;
    private int sheetIndex = 0;
    private String sheetName = null;

    public void setSheetIndex(int sheetIndex) {
        this.sheetIndex = sheetIndex;
    }

    public void setSheetName(String sheetName) {
        this.sheetName = sheetName;
    }

    public ExcelDataGetter(String excelFilePath) {
        this.workBook = new HolmosWorkBook(excelFilePath);
    }

    @Override
    public ArrayList<Object[]> getParameterByIDs(int[] ids) {
        ArrayList<Object[]> parameters = new ArrayList<Object[]>();
        int[] nArray = ids;
        int n = ids.length;
        int n2 = 0;
        while (n2 < n) {
            int id = nArray[n2];
            parameters.addAll(this.getParameterByID(id));
            ++n2;
        }
        return parameters;
    }

    @Override
    public ArrayList<Object[]> getAllParameter() {
        ArrayList<Object[]> parameters = new ArrayList<Object[]>();
        if (-1 != this.sheetIndex) {
            for (ArrayList<Object> parameter : this.workBook.getValidValuesBySheetIndex(this.sheetIndex)) {
                parameters.add(parameter.toArray());
            }
        } else if (this.sheetName != null) {
            if (-1 != this.sheetIndex) {
                for (ArrayList<Object> parameter : this.workBook.getValidValuesBySheetName(this.sheetName)) {
                    parameters.add(parameter.toArray());
                }
            }
        } else {
            throw new HolmosFailedError("\u8bf7\u6307\u5b9aexcel\u6587\u4ef6\u7684\u7d22\u5f15\u53f7\u6216\u8005sheet\u7684\u540d\u5b57!");
        }
        return parameters;
    }

    @Override
    public ArrayList<Object[]> getParameterByID(int id) {
        ArrayList<Object[]> result = new ArrayList<Object[]>();
        ArrayList<Object[]> parameters = this.getAllParameter();
        for (Object[] parameter : parameters) {
            if (Integer.parseInt((String)parameter[0]) != id) continue;
            result.add(this.getActualParameter(parameter));
        }
        return result;
    }
}

