/*
 * Decompiled with CFR 0.152.
 */
package com.holmos.webtest.junitextentions.parameters.getter;

import com.holmos.webtest.constvalue.ConstValue;
import com.holmos.webtest.junitextentions.parameters.getter.AbstractDataGetter;
import com.holmos.webtest.junitextentions.parameters.xml.HolmosXMLUtils;
import java.util.ArrayList;
import java.util.Iterator;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.Element;

public final class XMLDataGetter
extends AbstractDataGetter {
    private Document document;
    private static final String parameter = "parameter";
    private static final String id = "id";
    private static final String element = "element";

    public XMLDataGetter(String XMLFilePath) {
        this.document = HolmosXMLUtils.getDocument(XMLFilePath);
    }

    @Override
    public ArrayList<Object[]> getParameterByIDs(int[] ids) {
        ArrayList<Object[]> result = new ArrayList<Object[]>();
        int[] nArray = ids;
        int n = ids.length;
        int n2 = 0;
        while (n2 < n) {
            int id = nArray[n2];
            result.addAll(this.getParameterByID(id));
            ++n2;
        }
        return result;
    }

    @Override
    public ArrayList<Object[]> getAllParameter() {
        ArrayList<Object[]> result = new ArrayList<Object[]>();
        for (Element parameter : this.getAllParameterNodes()) {
            result.add(this.getParameterInfo(parameter));
        }
        return result;
    }

    @Override
    public ArrayList<Object[]> getParameterByID(int id) {
        ArrayList<Object[]> result = new ArrayList<Object[]>();
        for (Object[] parameter : this.getAllParameter()) {
            if ((Integer)parameter[0] != id) continue;
            result.add(this.getActualParameter(parameter));
        }
        return result;
    }

    private ArrayList<Element> getAllParameterNodes() {
        ArrayList<Element> parameters = new ArrayList<Element>();
        Element root = this.document.getRootElement();
        Iterator it = root.elementIterator();
        while (it.hasNext()) {
            Element node = (Element)it.next();
            if (!node.getName().equalsIgnoreCase(parameter)) continue;
            parameters.add(node);
        }
        return parameters;
    }

    private Object[] getParameterInfo(Element parameterNode) {
        int id = this.hasIDAttribute(parameterNode);
        if (ConstValue.ERROR == id) {
            return null;
        }
        ArrayList<Object> result = new ArrayList<Object>();
        result.add(id);
        Iterator it = parameterNode.elementIterator();
        while (it.hasNext()) {
            Element node = (Element)it.next();
            if (!node.getName().equalsIgnoreCase(element)) continue;
            result.add(node.getStringValue());
        }
        return result.toArray();
    }

    private int hasIDAttribute(Element testcaseParameterNode) {
        Iterator it = testcaseParameterNode.attributeIterator();
        while (it.hasNext()) {
            Attribute attribute = (Attribute)it.next();
            if (attribute.getName() != id) continue;
            return Integer.parseInt(attribute.getText().trim());
        }
        return ConstValue.ERROR;
    }
}

