/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cloud.objectstorage.auth;

import com.ibm.cloud.objectstorage.SdkClientException;
import com.ibm.cloud.objectstorage.auth.AWSCredentials;
import com.ibm.cloud.objectstorage.auth.AWSCredentialsProvider;
import com.ibm.cloud.objectstorage.auth.ContainerCredentialsFetcher;
import com.ibm.cloud.objectstorage.auth.ContainerCredentialsRetryPolicy;
import com.ibm.cloud.objectstorage.internal.CredentialsEndpointProvider;
import com.ibm.cloud.objectstorage.retry.internal.CredentialsEndpointRetryPolicy;
import java.net.URI;
import java.util.Arrays;
import java.util.Date;
import java.util.List;

public class ContainerCredentialsProvider
implements AWSCredentialsProvider {
    static final String ECS_CONTAINER_CREDENTIALS_PATH = "AWS_CONTAINER_CREDENTIALS_RELATIVE_URI";
    static final String AWS_EC2_METADATA_SERVICE_ENDPOINT_MODE = "AWS_EC2_METADATA_SERVICE_ENDPOINT_MODE";
    static final String CONTAINER_AUTHORIZATION_TOKEN_FILE = "AWS_CONTAINER_AUTHORIZATION_TOKEN_FILE";
    private static final String HTTPS = "https";
    private static final String ECS_CREDENTIALS_ENDPOINT = "http://169.254.170.2";
    private static final String ECS_CONTAINER_HOST = "169.254.170.2";
    private static final String EKS_CONTAINER_HOST = "169.254.170.23";
    private static final String EKS_CONTAINER_HOST_IPV6 = "[fd00:ec2::23]";
    private static final List<String> VALID_LOOP_BACK_IPV4 = Arrays.asList("169.254.170.2", "169.254.170.23");
    private static final List<String> VALID_LOOP_BACK_IPV6 = Arrays.asList("[fd00:ec2::23]");
    private final ContainerCredentialsFetcher credentialsFetcher;

    @Deprecated
    public ContainerCredentialsProvider() {
        this(new ECSCredentialsEndpointProvider());
    }

    public ContainerCredentialsProvider(CredentialsEndpointProvider credentialsEndpointProvider) {
        this.credentialsFetcher = new ContainerCredentialsFetcher(credentialsEndpointProvider);
    }

    @Override
    public AWSCredentials getCredentials() {
        return this.credentialsFetcher.getCredentials();
    }

    @Override
    public void refresh() {
        this.credentialsFetcher.refresh();
    }

    public Date getCredentialsExpiration() {
        return this.credentialsFetcher.getCredentialsExpiration();
    }

    static class ECSCredentialsEndpointProvider
    extends CredentialsEndpointProvider {
        ECSCredentialsEndpointProvider() {
        }

        @Override
        public URI getCredentialsEndpoint() {
            String path = System.getenv(ContainerCredentialsProvider.ECS_CONTAINER_CREDENTIALS_PATH);
            if (path == null) {
                throw new SdkClientException("The environment variable AWS_CONTAINER_CREDENTIALS_RELATIVE_URI is empty");
            }
            return URI.create(ContainerCredentialsProvider.ECS_CREDENTIALS_ENDPOINT + path);
        }

        @Override
        public CredentialsEndpointRetryPolicy getRetryPolicy() {
            return ContainerCredentialsRetryPolicy.getInstance();
        }
    }
}

