/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.cmx.impl;

import com.ibm.db2.cmx.ClientDescriptor;
import com.ibm.db2.cmx.impl.DriverDescriptor;
import java.io.Serializable;
import java.util.HashMap;
import java.util.UUID;

class DataSourceDescriptor
implements ClientDescriptor.DataSource,
Serializable {
    private static final long serialVersionUID = 4172939046148236817L;
    private transient String datasourceId_;
    private DriverDescriptor driverDescriptor_;
    private String profileName_;
    private String jdbcDataSourceName_;
    private String wasJndiDataSourceName_;
    private int wasMaxPoolSize_;
    private String serverName_;
    private int port_;
    private String databaseName_;
    private HashMap<String, Object> clientDataSourcePropertySettings_;
    private static long currentDataSourceIdCount_ = 0L;

    public DataSourceDescriptor(DriverDescriptor driverDescriptor, String string, String string2, int n2, String string3, String string4, int n3, String string5, HashMap<String, Object> hashMap) {
        this.driverDescriptor_ = driverDescriptor;
        this.profileName_ = string;
        this.jdbcDataSourceName_ = string2;
        this.wasMaxPoolSize_ = n2;
        this.wasJndiDataSourceName_ = string3;
        this.serverName_ = string4;
        this.port_ = n3;
        this.databaseName_ = string5;
        this.clientDataSourcePropertySettings_ = hashMap;
        this.datasourceId_ = DataSourceDescriptor.getDataSourceUUID() + "_dataSourceId" + DataSourceDescriptor.getNextDataSourceIdCount();
    }

    private static synchronized long getNextDataSourceIdCount() {
        return ++currentDataSourceIdCount_;
    }

    private static synchronized String getDataSourceUUID() {
        return UUID.randomUUID().toString();
    }

    @Override
    public String getDataSourceId() {
        return this.datasourceId_;
    }

    @Override
    public DriverDescriptor getDriverDescriptor() {
        return this.driverDescriptor_;
    }

    @Override
    public String getProfileName() {
        return this.profileName_;
    }

    @Override
    public String getJdbcDataSourceName() {
        return this.jdbcDataSourceName_;
    }

    @Override
    public String getServerName() {
        return this.serverName_;
    }

    @Override
    public int getPort() {
        return this.port_;
    }

    @Override
    public String getDatabaseName() {
        return this.databaseName_;
    }

    @Override
    public HashMap<String, Object> getDataSourcePropertySettings() {
        return this.clientDataSourcePropertySettings_;
    }

    @Override
    public String getWASJndiDataSourceName() {
        return this.wasJndiDataSourceName_;
    }

    @Override
    public int getWASMaxPoolSize() {
        return this.wasMaxPoolSize_;
    }

    public int hashCode() {
        int n2 = 1;
        n2 = 31 * n2 + (this.databaseName_ == null ? 0 : this.databaseName_.hashCode());
        n2 = 31 * n2 + (this.driverDescriptor_ == null ? 0 : this.driverDescriptor_.hashCode());
        n2 = 31 * n2 + (this.jdbcDataSourceName_ == null ? 0 : this.jdbcDataSourceName_.hashCode());
        n2 = 31 * n2 + this.port_;
        n2 = 31 * n2 + (this.profileName_ == null ? 0 : this.profileName_.hashCode());
        n2 = 31 * n2 + (this.serverName_ == null ? 0 : this.serverName_.hashCode());
        n2 = 31 * n2 + (this.wasJndiDataSourceName_ == null ? 0 : this.wasJndiDataSourceName_.hashCode());
        n2 = 31 * n2 + this.wasMaxPoolSize_;
        return n2;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        DataSourceDescriptor dataSourceDescriptor = (DataSourceDescriptor)object;
        if (this.databaseName_ == null ? dataSourceDescriptor.databaseName_ != null : !this.databaseName_.equals(dataSourceDescriptor.databaseName_)) {
            return false;
        }
        if (this.driverDescriptor_ == null ? dataSourceDescriptor.driverDescriptor_ != null : !this.driverDescriptor_.equals(dataSourceDescriptor.driverDescriptor_)) {
            return false;
        }
        if (this.jdbcDataSourceName_ == null ? dataSourceDescriptor.jdbcDataSourceName_ != null : !this.jdbcDataSourceName_.equals(dataSourceDescriptor.jdbcDataSourceName_)) {
            return false;
        }
        if (this.port_ != dataSourceDescriptor.port_) {
            return false;
        }
        if (this.profileName_ == null ? dataSourceDescriptor.profileName_ != null : !this.profileName_.equals(dataSourceDescriptor.profileName_)) {
            return false;
        }
        if (this.serverName_ == null ? dataSourceDescriptor.serverName_ != null : !this.serverName_.equals(dataSourceDescriptor.serverName_)) {
            return false;
        }
        if (this.wasJndiDataSourceName_ == null ? dataSourceDescriptor.wasJndiDataSourceName_ != null : !this.wasJndiDataSourceName_.equals(dataSourceDescriptor.wasJndiDataSourceName_)) {
            return false;
        }
        return this.wasMaxPoolSize_ == dataSourceDescriptor.wasMaxPoolSize_;
    }
}

