/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.cmx.tools.internal.repository;

import com.ibm.db2.cmx.runtime.internal.repository.MetadataException;
import com.ibm.db2.cmx.runtime.internal.repository.api.IncrementalDataManager;
import com.ibm.db2.cmx.runtime.internal.repository.api.IncrementalSavedDataInfo;
import com.ibm.db2.cmx.runtime.internal.repository.api.ManagerFactory;
import com.ibm.db2.cmx.runtime.internal.repository.api.RepositoryVersion;
import com.ibm.db2.cmx.runtime.internal.repository.api.RuntimeGroupManager;
import com.ibm.db2.cmx.runtime.internal.repository.api.SavedData;
import com.ibm.db2.cmx.runtime.internal.resources.Messages;
import com.ibm.db2.cmx.tools.internal.PureQueryUtility;
import com.ibm.db2.cmx.tools.internal.optionsProcessing.ArtifactOptionsSet;
import com.ibm.db2.cmx.tools.internal.optionsProcessing.PossibleArgs;
import com.ibm.db2.cmx.tools.internal.repository.DefaultActionProcessor;
import com.ibm.db2.cmx.tools.internal.repository.ManageRepositoryUtility;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class ExtractActionProcessor
extends DefaultActionProcessor {
    protected ArrayList<String> extractedFiles = new ArrayList();

    @Override
    public PureQueryUtility.UtilityResult processAction(PossibleArgs possibleArgs, ArtifactOptionsSet artifactOptionsSet, Connection connection, Connection connection2, String string, RepositoryVersion repositoryVersion, PrintWriter printWriter) throws Exception {
        PureQueryUtility.UtilityResult utilityResult = null;
        String string2 = artifactOptionsSet.getOptionOrArtifactSingleValue(PossibleArgs.RUNTIME_GROUP_ID);
        String string3 = artifactOptionsSet.getOptionOrArtifactSingleValue(PossibleArgs.RUNTIME_GROUP_VERSION);
        String string4 = artifactOptionsSet.getOptionOrArtifactSingleValue(PossibleArgs.PUREQUERY_PROPERTIES);
        String string5 = artifactOptionsSet.getOptionOrArtifactSingleValue(PossibleArgs.PUREQUERY_XML_FILE);
        String string6 = artifactOptionsSet.getOptionOrArtifactSingleValue(PossibleArgs.OPTIONS_FILE_FORBIND);
        String string7 = artifactOptionsSet.getOptionOrArtifactSingleValue(PossibleArgs.OPTIONS_FILE_FORCONFIGURE);
        String string8 = artifactOptionsSet.getOptionOrArtifactSingleValue(PossibleArgs.INCREMENTAL_CAPTURE);
        String string9 = artifactOptionsSet.getOptionOrArtifactSingleValue(PossibleArgs.OUTPUT_DIRECTORY);
        if (string4 == null && string5 == null && string6 == null && string7 == null && string8 == null) {
            printWriter.println(Messages.getText("MSG_MANAGEREPOSITORY_FAILURE_EXTRACT_NO_FILE_EXTRACTED", new Object[0]));
            printWriter.println(Messages.getText("MSG_MANAGEREPOSITORY_FAILURE_EXTRACT_NO_OPTIONS_FILE_SPECIFIED", new Object[0]) + "\n" + (Object)((Object)PossibleArgs.PUREQUERY_PROPERTIES) + "\n" + (Object)((Object)PossibleArgs.PUREQUERY_XML_FILE) + "\n" + (Object)((Object)PossibleArgs.OPTIONS_FILE_FORBIND) + "\n" + (Object)((Object)PossibleArgs.OPTIONS_FILE_FORCONFIGURE) + "\n" + (Object)((Object)PossibleArgs.INCREMENTAL_CAPTURE) + "\n");
            return new PureQueryUtility.UtilityResult(PureQueryUtility.UtilityResultType.SKIP);
        }
        RuntimeGroupManager runtimeGroupManager = ManagerFactory.getRuntimeGroupManager(connection, string);
        if (string9 != null && !string9.endsWith(File.separator)) {
            string9 = string9 + File.separator;
        }
        if (ManageRepositoryUtility.runtimeGroupVersionExists(string2, string3, runtimeGroupManager)) {
            this.extractPureQueryDataFiles(string2, string3, string4, string5, string6, string7, string9, runtimeGroupManager, printWriter);
            if (connection2 != null) {
                this.extractPureQueryIncrementalCaptureFiles(connection2, string, string2, string8, string9, printWriter);
            } else {
                this.extractPureQueryIncrementalCaptureFiles(connection, string, string2, string8, string9, printWriter);
            }
            if (this.extractedFiles.size() > 0) {
                printWriter.println(Messages.getText("MSG_EXTRACTED_FILE_LIST", new Object[0]) + "\n");
                for (String string10 : this.extractedFiles) {
                    printWriter.println(string10);
                }
                return new PureQueryUtility.UtilityResult(PureQueryUtility.UtilityResultType.SUCCESS);
            }
            printWriter.println(Messages.getText("MSG_MANAGEREPOSITORY_FAILURE_EXTRACT_NO_FILE_EXTRACTED", new Object[0]));
            return new PureQueryUtility.UtilityResult(PureQueryUtility.UtilityResultType.FAILURE);
        }
        utilityResult = new PureQueryUtility.UtilityResult(PureQueryUtility.UtilityResultType.FAILURE);
        utilityResult.reason = Messages.getText("MSG_ERROR_RUNTIMEGROUP_VERSION_NOT_FOUND", string2, string3);
        return utilityResult;
    }

    private void extractPureQueryIncrementalCaptureFiles(Connection connection, String string, String string2, String string3, String string4, PrintWriter printWriter) throws MetadataException, IOException {
        if (string3 != null) {
            IncrementalDataManager incrementalDataManager = ManagerFactory.getIncrementalDataManager(connection, string);
            String string5 = "";
            int n2 = 0;
            List<IncrementalSavedDataInfo> list = incrementalDataManager.list(string2);
            for (IncrementalSavedDataInfo incrementalSavedDataInfo : list) {
                string5 = string3 + "_" + ++n2 + ".pdqxml";
                this.createOutputFile(incrementalDataManager.getContent(incrementalSavedDataInfo.getKey()), string4, string5);
                this.extractedFiles.add(this.getOutputFile(string4, string5));
            }
        }
    }

    private void extractPureQueryDataFiles(String string, String string2, String string3, String string4, String string5, String string6, String string7, RuntimeGroupManager runtimeGroupManager, PrintWriter printWriter) throws MetadataException, IOException {
        HashSet<RuntimeGroupManager.MemberType> hashSet = new HashSet<RuntimeGroupManager.MemberType>();
        if (string3 != null) {
            hashSet.add(RuntimeGroupManager.MemberType.PdqProps);
        }
        if (string4 != null) {
            hashSet.add(RuntimeGroupManager.MemberType.PDQXML);
        }
        if (string5 != null) {
            hashSet.add(RuntimeGroupManager.MemberType.BindProps);
        }
        if (string6 != null) {
            hashSet.add(RuntimeGroupManager.MemberType.GenProps);
        }
        Map<RuntimeGroupManager.MemberType, SavedData> map = runtimeGroupManager.getData(string, string2, hashSet);
        if (string3 != null) {
            this.createOutputFile(map.get((Object)RuntimeGroupManager.MemberType.PdqProps).getContentStream(), string7, string3);
            this.extractedFiles.add(this.getOutputFile(string7, string3));
        }
        if (string4 != null) {
            this.createOutputFile(map.get((Object)RuntimeGroupManager.MemberType.PDQXML).getContentStream(), string7, string4);
            this.extractedFiles.add(this.getOutputFile(string7, string4));
        }
        if (string5 != null) {
            this.createOutputFile(map.get((Object)RuntimeGroupManager.MemberType.BindProps).getContentStream(), string7, string5);
            this.extractedFiles.add(this.getOutputFile(string7, string5));
        }
        if (string6 != null) {
            this.createOutputFile(map.get((Object)RuntimeGroupManager.MemberType.GenProps).getContentStream(), string7, string6);
            this.extractedFiles.add(this.getOutputFile(string7, string6));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createOutputFile(InputStream inputStream, String string, String string2) throws IOException {
        FileOutputStream fileOutputStream = null;
        try {
            int n2;
            fileOutputStream = new FileOutputStream(this.getOutputFile(string, string2));
            byte[] byArray = new byte[1024];
            while ((n2 = inputStream.read(byArray)) > 0) {
                fileOutputStream.write(byArray, 0, n2);
            }
        }
        finally {
            if (fileOutputStream != null) {
                fileOutputStream.close();
            }
            if (inputStream != null) {
                inputStream.close();
            }
        }
    }

    private String getOutputFile(String string, String string2) {
        if (string == null) {
            return string2;
        }
        if (string.endsWith(File.separator)) {
            return string + string2;
        }
        return string + File.separator + string2;
    }
}

