/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.cmx.runtime.internal.wrappers.db2;

import com.ibm.db2.cmx.runtime.exception.ExceptionFactory;
import com.ibm.db2.cmx.runtime.internal.db.SqlStatementKey;
import com.ibm.db2.cmx.runtime.internal.db.StaticProfileCaptureHelper;
import com.ibm.db2.cmx.runtime.internal.db.db2.StaticProfileSection;
import com.ibm.db2.cmx.runtime.internal.resources.Messages;
import com.ibm.db2.cmx.runtime.internal.trace.DataLogger;
import com.ibm.db2.cmx.runtime.internal.trace.Log;
import com.ibm.db2.cmx.runtime.internal.wrappers.ConnectionExecutionHandler;
import com.ibm.db2.cmx.runtime.internal.wrappers.ResultSetExecutionHandler;
import com.ibm.db2.cmx.runtime.internal.wrappers.StatementExecutionHandler;
import com.ibm.db2.cmx.runtime.internal.wrappers.db2.DB2PreparedStatementExecutionHandler;
import com.ibm.db2.cmx.runtime.statement.SqlStatementType;
import com.ibm.db2.jcc.DB2ResultSet;
import com.ibm.db2.jcc.DBMetaData;
import com.ibm.db2.jcc.DBPreparedStatementInfoInterface;
import com.ibm.db2.jcc.DBProfilerResultSet;
import com.ibm.db2.jcc.SQLJPreparedStatement;
import com.ibm.db2.jcc.SQLJResultSet;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DB2ResultSetExecutionHandler
extends ResultSetExecutionHandler {
    private DB2PreparedStatementExecutionHandler prepStmtExecutionHandler_;
    int resultSetType_ = 1003;
    int resultSetConcurrency_ = 1007;
    int resultSetHoldability_ = 1;
    protected String cursorName_;
    private boolean isCurrentForPosUpdate_;
    private long queryInstanceId_;

    protected DB2ResultSetExecutionHandler(DB2PreparedStatementExecutionHandler dB2PreparedStatementExecutionHandler, ResultSet resultSet, int n2, int n3, int n4, String string) throws SQLException {
        super(dB2PreparedStatementExecutionHandler, resultSet);
        this.prepStmtExecutionHandler_ = dB2PreparedStatementExecutionHandler;
        this.resultSetType_ = n2;
        this.resultSetConcurrency_ = n3;
        this.resultSetHoldability_ = n4;
        this.cursorName_ = string;
        this.queryInstanceId_ = ((SQLJResultSet)this.physicalResultSet_).getQueryInstanceIdentifier();
        if (this.resultSetConcurrency_ == 1008) {
            this.isCurrentForPosUpdate_ = true;
        }
        if (this.currentStates_.getProfilerHelperInstance() == null && logger__.isLoggable(Level.CONFIG)) {
            DataLogger.logConfigHighVis(logger__, this, "", DataLogger.getShortName(this) + " profilerHelperInstance is null", false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object invoke(String string, Method method, Object[] objectArray) throws Throwable {
        Connection connection = this.prepStmtExecutionHandler_.db2ConnectionExecutionHandler_.physicalConnection_;
        synchronized (connection) {
            Object object = null;
            try {
                if (this.prepStmtExecutionHandler_.db2ConnectionExecutionHandler_.driverTraceOn_) {
                    this.prepStmtExecutionHandler_.db2ConnectionExecutionHandler_.driverLogWriter_.println(this.prepStmtExecutionHandler_.db2ConnectionExecutionHandler_.buildDriverTraceHeader(this, "invoke") + "[" + string + "] enter...");
                }
                if (logger__.isLoggable(Level.FINER)) {
                    if (string.equals("equals") || string.equals("hashCode") || string.equals("toString")) {
                        return method.invoke((Object)this.physicalResultSet_, objectArray);
                    }
                    DataLogger.logAtLevelFiner(logger__, this, "invoke: " + string, "ENTRY " + Arrays.deepToString(objectArray));
                }
                if (string.startsWith("g")) {
                    object = string.equals("getCursorName") ? this.getCursorName() : method.invoke((Object)this.physicalResultSet_, objectArray);
                } else if (string.startsWith("u")) {
                    if (string.equals("updateRow")) {
                        this.updateRow();
                    } else {
                        object = method.invoke((Object)this.physicalResultSet_, objectArray);
                    }
                } else if (string.equals("next")) {
                    object = this.next();
                } else if (string.equals("insertRow")) {
                    this.insertRow();
                } else if (string.equals("deleteRow")) {
                    this.deleteRow();
                } else if (string.equals("close")) {
                    this.close();
                } else {
                    object = method.invoke((Object)this.physicalResultSet_, objectArray);
                }
            }
            catch (InvocationTargetException invocationTargetException) {
                Throwable throwable = invocationTargetException.getTargetException();
                DataLogger.logThrowable(logger__, throwable);
                this.dumpLogs(throwable);
                throw throwable;
            }
            catch (IllegalAccessException illegalAccessException) {
                throw ExceptionFactory.createDataRuntimeExceptionForRuntimeOnly(null, Messages.getText("ERR_PROFILER_ILLEGAL_ACCESS_EXCEPTION", method.getName(), illegalAccessException.getMessage()), illegalAccessException, 10756);
            }
            catch (SQLException sQLException) {
                DataLogger.logThrowable(logger__, sQLException);
                this.dumpLogs(sQLException);
                throw sQLException;
            }
            if (this.prepStmtExecutionHandler_.db2ConnectionExecutionHandler_.driverTraceOn_) {
                this.prepStmtExecutionHandler_.db2ConnectionExecutionHandler_.driverLogWriter_.println(this.prepStmtExecutionHandler_.db2ConnectionExecutionHandler_.buildDriverTraceHeader(this, "invoke") + "[" + string + "] exit...");
            }
            if (logger__.isLoggable(Level.FINER)) {
                DataLogger.exit(logger__, this, "invoke: " + string, object);
            }
            return object;
        }
    }

    protected boolean shouldDumpLogs(Throwable throwable) {
        return Log.isLoggable(throwable);
    }

    protected void dumpLogs(Throwable throwable) {
        if (this.shouldDumpLogs(throwable)) {
            Log.dumpRingBuffer(throwable);
        }
    }

    private void checkForNullResultSet() throws SQLException {
        if (this.physicalResultSet_ == null) {
            throw ExceptionFactory.createDataSQLExceptionForOptimizer(this, Messages.getText("ERR_PROFILER_UNDERLYING_RESULTSET_IS_NULL", new Object[0]), null, null, 10753);
        }
    }

    @Override
    protected ResultSet getUnderlyingResultSet() {
        return this.physicalResultSet_;
    }

    protected boolean isCurrentForPositionUpdate() {
        return this.isCurrentForPosUpdate_;
    }

    public long getQueryInstanceId() {
        return this.queryInstanceId_;
    }

    private StatementExecutionHandler getPosUpdatePrepStmtProxy(String string) throws SQLException {
        DB2PreparedStatementExecutionHandler dB2PreparedStatementExecutionHandler = null;
        int n2 = 1003;
        int n3 = 1007;
        int n4 = 1;
        StaticProfileSection staticProfileSection = null;
        if ((this.currentStates_.getExecutionMode() == 7 || this.currentStates_.getExecutionMode() == 20) && this.currentStates_.getOutputCaptureKey() != null) {
            Object[] objectArray = this.removeRowsetFromSQL(string);
            if (((Boolean)objectArray[0]).booleanValue()) {
                string = (String)objectArray[1];
            }
            SqlStatementKey sqlStatementKey = SqlStatementKey.generateStmtKey(string, n2, n3, n4, null, null, 0, false);
            staticProfileSection = (StaticProfileSection)this.prepStmtExecutionHandler_.db2ConnectionExecutionHandler_.getProfileSectionFromMap(sqlStatementKey, this.currentStates_);
            PreparedStatement preparedStatement = null;
            if (staticProfileSection != null && null != (preparedStatement = this.prepStmtExecutionHandler_.db2ConnectionExecutionHandler_.getStaticPreparedStmtForSectionDB2ResultSet(string, staticProfileSection))) {
                dB2PreparedStatementExecutionHandler = new DB2PreparedStatementExecutionHandler(this.prepStmtExecutionHandler_.db2ConnectionExecutionHandler_, preparedStatement, string, n2, n3, n4, null, null, 0, staticProfileSection, this.prepStmtExecutionHandler_.getMethodName(), this.prepStmtExecutionHandler_.getMethod(), this.prepStmtExecutionHandler_.getArgs());
            }
            this.currentStates_.getProfilerHelperInstance().checkForStaticPreparedStatementNotFound(null, sqlStatementKey, dB2PreparedStatementExecutionHandler);
            if (dB2PreparedStatementExecutionHandler == null && this.currentStates_.getExecutionMode() == 20) {
                preparedStatement = this.prepStmtExecutionHandler_.db2ConnectionExecutionHandler_.getDynamicPosUpdateStmtForStaticCursorDB2ResultSet(string, this.prepStmtExecutionHandler_.getStaticSectionForThisStmt());
                dB2PreparedStatementExecutionHandler = new DB2PreparedStatementExecutionHandler(this.prepStmtExecutionHandler_.db2ConnectionExecutionHandler_, preparedStatement, string, n2, n3, n4, null, null, 0, null, this.prepStmtExecutionHandler_.getMethodName(), this.prepStmtExecutionHandler_.getMethod(), this.prepStmtExecutionHandler_.getArgs());
            }
        }
        return dB2PreparedStatementExecutionHandler;
    }

    public void close() throws SQLException {
        if (this.prepStmtExecutionHandler_.isStaticUpdatableCursor(this)) {
            this.prepStmtExecutionHandler_.db2ConnectionExecutionHandler_.staticCursorPositionUpdateMap_.removeRSProxyForCursor(this.cursorName_, this);
        }
        this.physicalResultSet_.close();
    }

    private String getCursorName() throws SQLException {
        if (this.prepStmtExecutionHandler_.isStaticStmt()) {
            Iterator<WeakReference<ResultSetExecutionHandler>> iterator;
            boolean bl2 = false;
            List<WeakReference<ResultSetExecutionHandler>> list = this.prepStmtExecutionHandler_.db2ConnectionExecutionHandler_.staticCursorPositionUpdateMap_.getAllRSProxiesForCursor(this.cursorName_);
            if (list != null && (iterator = list.iterator()) != null) {
                while (iterator.hasNext()) {
                    WeakReference<ResultSetExecutionHandler> weakReference = iterator.next();
                    DB2ResultSetExecutionHandler dB2ResultSetExecutionHandler = (DB2ResultSetExecutionHandler)weakReference.get();
                    if (null == dB2ResultSetExecutionHandler) continue;
                    dB2ResultSetExecutionHandler.isCurrentForPosUpdate_ = dB2ResultSetExecutionHandler.equals(this);
                    if (!dB2ResultSetExecutionHandler.isCurrentForPosUpdate_) continue;
                    bl2 = true;
                }
            }
            if (!bl2 && logger__.isLoggable(Level.FINER)) {
                DataLogger.logAtLevelFiner(logger__, this, "getCursorName", " No ResultSet marked as current for cursor '" + this.prepStmtExecutionHandler_.getStaticSectionForThisStmt().getCursorName() + "'");
            }
            return this.physicalResultSet_.getCursorName();
        }
        if (this.resultSetConcurrency_ == 1008) {
            this.prepStmtExecutionHandler_.db2ConnectionExecutionHandler_.setCurrentPosUpdateCursorNameForCapture(this.cursorName_);
        }
        return this.physicalResultSet_.getCursorName();
    }

    private Boolean next() throws SQLException {
        Boolean bl2 = this.physicalResultSet_.next();
        if (bl2.equals(false) && this.prepStmtExecutionHandler_.isStaticUpdatableCursor(this) && this.resultSetType_ == 1003) {
            this.prepStmtExecutionHandler_.db2ConnectionExecutionHandler_.staticCursorPositionUpdateMap_.removeRSProxyForCursor(this.cursorName_, this);
        }
        return bl2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void insertRow() throws SQLException {
        DB2PreparedStatementExecutionHandler dB2PreparedStatementExecutionHandler = null;
        String string = null;
        boolean bl2 = true;
        try {
            this.prepStmtExecutionHandler_.db2ConnectionExecutionHandler_.systemMonitorStart();
            StaticProfileCaptureHelper.checkAndGenerateSpecialRegisterSets(this.currentStates_, this.prepStmtExecutionHandler_.db2ConnectionExecutionHandler_, false, null);
            if ((this.currentStates_.getExecutionMode() == 7 || this.currentStates_.getExecutionMode() == 20) && this.prepStmtExecutionHandler_.isStaticStmt()) {
                string = ((DBProfilerResultSet)((Object)this.physicalResultSet_)).getPositionedCursorSQLString(1);
                dB2PreparedStatementExecutionHandler = (DB2PreparedStatementExecutionHandler)this.getPosUpdatePrepStmtProxy(string);
                ((DBProfilerResultSet)((Object)this.physicalResultSet_)).insertRow((SQLJPreparedStatement)dB2PreparedStatementExecutionHandler.getUnderlyingPreparedStatement());
            } else {
                this.physicalResultSet_.insertRow();
            }
            bl2 = false;
        }
        finally {
            this.prepStmtExecutionHandler_.db2ConnectionExecutionHandler_.systemMonitorStop();
            if (this.currentStates_.getCaptureMode() == 5) {
                if (this.currentStates_.getExecutionMode() == 8 || !this.prepStmtExecutionHandler_.isStaticStmt()) {
                    DBPreparedStatementInfoInterface dBPreparedStatementInfoInterface = null;
                    dBPreparedStatementInfoInterface = ((DB2ResultSet)this.physicalResultSet_).getPositionedInsertPrepStmt();
                    if (null != dBPreparedStatementInfoInterface) {
                        string = dBPreparedStatementInfoInterface.getSQLString()[0];
                    }
                }
                if (string != null) {
                    this.checkAndCapturePosUpdateStmt(bl2, string, SqlStatementType.INSERT, this.prepStmtExecutionHandler_.db2ConnectionExecutionHandler_.getElapsedTime());
                }
            }
            if (dB2PreparedStatementExecutionHandler != null) {
                dB2PreparedStatementExecutionHandler.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateRow() throws SQLException {
        SqlStatementType sqlStatementType = SqlStatementType.UPDATE;
        DB2PreparedStatementExecutionHandler dB2PreparedStatementExecutionHandler = null;
        String string = null;
        boolean bl2 = true;
        try {
            this.prepStmtExecutionHandler_.db2ConnectionExecutionHandler_.systemMonitorStart();
            StaticProfileCaptureHelper.checkAndGenerateSpecialRegisterSets(this.currentStates_, this.prepStmtExecutionHandler_.db2ConnectionExecutionHandler_, false, null);
            if ((this.currentStates_.getExecutionMode() == 7 || this.currentStates_.getExecutionMode() == 20) && this.prepStmtExecutionHandler_.isStaticStmt()) {
                string = ((DBProfilerResultSet)((Object)this.physicalResultSet_)).getPositionedCursorSQLString(2);
                dB2PreparedStatementExecutionHandler = (DB2PreparedStatementExecutionHandler)this.getPosUpdatePrepStmtProxy(string);
                ((DBProfilerResultSet)((Object)this.physicalResultSet_)).updateRow((SQLJPreparedStatement)dB2PreparedStatementExecutionHandler.getUnderlyingPreparedStatement());
            } else {
                this.physicalResultSet_.updateRow();
            }
            bl2 = false;
        }
        finally {
            this.prepStmtExecutionHandler_.db2ConnectionExecutionHandler_.systemMonitorStop();
            if (this.currentStates_.getCaptureMode() == 5) {
                if (this.currentStates_.getExecutionMode() == 8 || !this.prepStmtExecutionHandler_.isStaticStmt()) {
                    DBPreparedStatementInfoInterface dBPreparedStatementInfoInterface = null;
                    dBPreparedStatementInfoInterface = ((DB2ResultSet)this.physicalResultSet_).getPositionedUpdatePrepStmt();
                    if (null != dBPreparedStatementInfoInterface) {
                        string = dBPreparedStatementInfoInterface.getSQLString()[0];
                    }
                }
                if (string != null) {
                    this.checkAndCapturePosUpdateStmt(bl2, string, SqlStatementType.UPDATE, this.prepStmtExecutionHandler_.db2ConnectionExecutionHandler_.getElapsedTime());
                }
            }
            if (dB2PreparedStatementExecutionHandler != null) {
                dB2PreparedStatementExecutionHandler.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteRow() throws SQLException {
        DB2PreparedStatementExecutionHandler dB2PreparedStatementExecutionHandler = null;
        String string = null;
        boolean bl2 = true;
        try {
            this.prepStmtExecutionHandler_.db2ConnectionExecutionHandler_.systemMonitorStart();
            StaticProfileCaptureHelper.checkAndGenerateSpecialRegisterSets(this.currentStates_, this.prepStmtExecutionHandler_.db2ConnectionExecutionHandler_, false, null);
            if ((this.currentStates_.getExecutionMode() == 7 || this.currentStates_.getExecutionMode() == 20) && this.prepStmtExecutionHandler_.isStaticStmt()) {
                string = ((DBProfilerResultSet)((Object)this.physicalResultSet_)).getPositionedCursorSQLString(3);
                dB2PreparedStatementExecutionHandler = (DB2PreparedStatementExecutionHandler)this.getPosUpdatePrepStmtProxy(string);
                ((DBProfilerResultSet)((Object)this.physicalResultSet_)).deleteRow((SQLJPreparedStatement)dB2PreparedStatementExecutionHandler.getUnderlyingPreparedStatement());
            } else {
                this.physicalResultSet_.deleteRow();
            }
            bl2 = false;
        }
        finally {
            this.prepStmtExecutionHandler_.db2ConnectionExecutionHandler_.systemMonitorStop();
            if (this.currentStates_.getCaptureMode() == 5) {
                if (this.currentStates_.getExecutionMode() == 8 || !this.prepStmtExecutionHandler_.isStaticStmt()) {
                    DBPreparedStatementInfoInterface dBPreparedStatementInfoInterface = null;
                    dBPreparedStatementInfoInterface = ((DB2ResultSet)this.physicalResultSet_).getPositionedDeletePrepStmt();
                    if (null != dBPreparedStatementInfoInterface) {
                        string = dBPreparedStatementInfoInterface.getSQLString()[0];
                    }
                }
                if (string != null) {
                    this.checkAndCapturePosUpdateStmt(bl2, string, SqlStatementType.DELETE, this.prepStmtExecutionHandler_.db2ConnectionExecutionHandler_.getElapsedTime());
                }
            }
            if (dB2PreparedStatementExecutionHandler != null) {
                dB2PreparedStatementExecutionHandler.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkAndCapturePosUpdateStmt(boolean bl2, String string, SqlStatementType sqlStatementType, long l10) throws SQLException {
        Object[] objectArray;
        String string2 = null;
        Object object = string;
        SqlStatementKey sqlStatementKey = null;
        boolean bl3 = false;
        String[][] stringArray = null;
        String[][] stringArray2 = null;
        StaticProfileCaptureHelper.SqlStatementInfo sqlStatementInfo = null;
        boolean bl4 = false;
        DBPreparedStatementInfoInterface dBPreparedStatementInfoInterface = null;
        DBMetaData dBMetaData = null;
        Object object2 = this.currentStates_.getProfilerHelperInstance().getSqlStatementInfoMap();
        synchronized (object2) {
            if (SqlStatementType.INSERT != sqlStatementType && (bl4 = ((Boolean)(objectArray = this.removeRowsetFromSQL(string))[0]).booleanValue())) {
                object = (String)objectArray[1];
                string = object;
            }
            String string3 = this.prepStmtExecutionHandler_.db2ConnectionExecutionHandler_.getCursorNameToSelectStmtMap().get(this.cursorName_);
            if (SqlStatementType.INSERT != sqlStatementType && string3 != null && (objectArray = ConnectionExecutionHandler.replacePosUpdateCursorName((String)object, string3)) != null) {
                object = objectArray[0];
            }
            sqlStatementKey = SqlStatementKey.generateStmtKey((String)object, 1003, 1007, 1, null, null, 0, false);
            bl3 = this.currentStates_.getProfilerHelperInstance().determineIfStmtAlreadyCaptured(sqlStatementKey);
            if (bl3) {
                sqlStatementInfo = this.currentStates_.getProfilerHelperInstance().getSqlStatementInfoMap().get(sqlStatementKey);
                this.currentStates_.getProfilerHelperInstance().getStatementOrdinalPositionMap().put(sqlStatementInfo.getStmtId(), sqlStatementKey);
            } else if (!bl2) {
                if (SqlStatementType.DELETE == sqlStatementType) {
                    dBPreparedStatementInfoInterface = ((DB2ResultSet)this.physicalResultSet_).getPositionedDeletePrepStmt();
                } else if (SqlStatementType.INSERT == sqlStatementType) {
                    dBPreparedStatementInfoInterface = ((DB2ResultSet)this.physicalResultSet_).getPositionedInsertPrepStmt();
                } else if (SqlStatementType.UPDATE == sqlStatementType) {
                    dBPreparedStatementInfoInterface = ((DB2ResultSet)this.physicalResultSet_).getPositionedUpdatePrepStmt();
                }
                if (null != dBPreparedStatementInfoInterface) {
                    dBMetaData = dBPreparedStatementInfoInterface.getDBParameterMetaData();
                }
                if (SqlStatementType.INSERT != sqlStatementType) {
                    string2 = this.physicalResultSet_.getCursorName();
                    if (bl4) {
                        this.prepStmtExecutionHandler_.checkForExistenceOfRowsetAndLog(" ROWSET ", "updateRow", string);
                        --dBMetaData.columns;
                    }
                }
                if (this.currentStates_.getMaxStackTracesCaptured() != 0 && this.currentStates_.getStackTraceDepth() != 0) {
                    stringArray = this.currentStates_.getProfilerHelperInstance().createMultiLevelTraceInfo(this.currentStates_.getStackTraceDepth(), this.currentStates_.getPackagePrefixArray());
                    if (stringArray2 == null && stringArray != null) {
                        stringArray2 = stringArray;
                    }
                }
                sqlStatementInfo = this.currentStates_.getProfilerHelperInstance().recordNonQueryStmt(this.prepStmtExecutionHandler_.db2ConnectionExecutionHandler_, string, dBMetaData, null, sqlStatementKey, string2, null, sqlStatementType, false, stringArray2, stringArray, null, string3, l10, 0L, 0);
            }
        }
        if (bl3) {
            object2 = sqlStatementInfo;
            synchronized (object2) {
                if (this.currentStates_.getMaxStackTracesCaptured() != 0 && this.currentStates_.getStackTraceDepth() != 0 && (this.currentStates_.getMaxStackTracesCaptured() == -1 || sqlStatementInfo.countDefinitionTraces() < this.currentStates_.getMaxStackTracesCaptured() || sqlStatementInfo.countExecutionTraces() < this.currentStates_.getMaxStackTracesCaptured())) {
                    objectArray = this.currentStates_.getProfilerHelperInstance().createMultiLevelTraceInfo(this.currentStates_.getStackTraceDepth(), this.currentStates_.getPackagePrefixArray());
                    this.currentStates_.getProfilerHelperInstance().captureTrace((String[][])objectArray, (String[][])objectArray, this.currentStates_.getMaxStackTracesCaptured(), sqlStatementInfo);
                }
                this.currentStates_.getProfilerHelperInstance().incrementExecutionCountMRIAndSRSet(this.prepStmtExecutionHandler_.db2ConnectionExecutionHandler_, sqlStatementInfo, false, sqlStatementType, this.prepStmtExecutionHandler_.db2ConnectionExecutionHandler_.getElapsedTime(), 0L, 0, 0);
            }
        }
        if (bl3 || !bl3 && !bl2) {
            this.currentStates_.getProfilerHelperInstance().sqlStatementCaptureOrUpdate(!bl3);
        }
    }

    private Object[] removeRowsetFromSQL(String string) {
        Object[] objectArray = new Object[]{false, string};
        Pattern pattern = Pattern.compile("\\s*FOR\\s+ROW\\s+[?]\\s+OF\\s+ROWSET");
        Matcher matcher = pattern.matcher(string);
        StringBuffer stringBuffer = new StringBuffer();
        if (matcher.find()) {
            matcher.appendReplacement(stringBuffer, " ");
            matcher.appendTail(stringBuffer);
            objectArray[1] = stringBuffer.toString();
            objectArray[0] = true;
        }
        return objectArray;
    }

    @Override
    public String toString() {
        return new String("DB2ResultSetExecutionHandler@" + Integer.toHexString(this.hashCode()) + "[physical: " + (this.physicalResultSet_ == null ? "null" : this.physicalResultSet_.toString()) + "]");
    }

    @Override
    public Object getUnderlyingObject() {
        return this.physicalResultSet_;
    }

    protected DB2PreparedStatementExecutionHandler getUnderlyingPstmtExecHandler() {
        return this.prepStmtExecutionHandler_;
    }
}

