/*
 * Decompiled with CFR 0.152.
 */
package com.icegreen.greenmail.imap.commands;

import com.icegreen.greenmail.imap.commands.IdRange;
import com.icegreen.greenmail.imap.commands.SearchKey;
import com.icegreen.greenmail.store.StoredMessage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.mail.Address;
import javax.mail.Flags;
import javax.mail.Message;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.search.AndTerm;
import javax.mail.search.FlagTerm;
import javax.mail.search.FromTerm;
import javax.mail.search.HeaderTerm;
import javax.mail.search.RecipientTerm;
import javax.mail.search.SearchTerm;
import javax.mail.search.SubjectTerm;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SearchTermBuilder {
    private SearchKey key;
    private List<String> parameters = Collections.emptyList();

    public static SearchTermBuilder create(String pTerm) {
        return SearchTermBuilder.create(SearchKey.valueOf(pTerm));
    }

    public static SearchTermBuilder create(SearchKey key) {
        SearchTermBuilder builder;
        switch (key) {
            case HEADER: {
                builder = SearchTermBuilder.createHeaderTermBuilder();
                break;
            }
            case ALL: {
                builder = SearchTermBuilder.createSearchTermBuilder(new AllSearchTerm());
                break;
            }
            case ANSWERED: {
                builder = SearchTermBuilder.createFlagSearchTermBuilder("ANSWERED", true);
                break;
            }
            case BCC: {
                builder = SearchTermBuilder.createRecipientSearchTermBuilder(Message.RecipientType.BCC);
                break;
            }
            case CC: {
                builder = SearchTermBuilder.createRecipientSearchTermBuilder(Message.RecipientType.CC);
                break;
            }
            case DELETED: {
                builder = SearchTermBuilder.createFlagSearchTermBuilder("DELETED", true);
                break;
            }
            case DRAFT: {
                builder = SearchTermBuilder.createFlagSearchTermBuilder("DRAFT", true);
                break;
            }
            case FLAGGED: {
                builder = SearchTermBuilder.createFlagSearchTermBuilder("FLAGGED", true);
                break;
            }
            case FROM: {
                builder = SearchTermBuilder.createFromSearchTermBuilder();
                break;
            }
            case NEW: {
                builder = SearchTermBuilder.createSearchTermBuilder((SearchTerm)new AndTerm(SearchTermBuilder.createFlagSearchTerm("RECENT", true), SearchTermBuilder.createFlagSearchTerm("SEEN", false)));
                break;
            }
            case OLD: {
                builder = SearchTermBuilder.createSearchTermBuilder(SearchTermBuilder.createFlagSearchTerm("RECENT", false));
                break;
            }
            case RECENT: {
                builder = SearchTermBuilder.createSearchTermBuilder(SearchTermBuilder.createFlagSearchTerm("RECENT", true));
                break;
            }
            case SEEN: {
                builder = SearchTermBuilder.createSearchTermBuilder(SearchTermBuilder.createFlagSearchTerm("SEEN", true));
                break;
            }
            case SUBJECT: {
                builder = SearchTermBuilder.createSubjectTermBuilder();
                break;
            }
            case TO: {
                builder = SearchTermBuilder.createRecipientSearchTermBuilder(Message.RecipientType.TO);
                break;
            }
            case UID: {
                builder = SearchTermBuilder.createUidTermBuilder();
                break;
            }
            case UNANSWERED: {
                builder = SearchTermBuilder.createSearchTermBuilder(SearchTermBuilder.createFlagSearchTerm("ANSWERED", false));
                break;
            }
            case UNDELETED: {
                builder = SearchTermBuilder.createSearchTermBuilder(SearchTermBuilder.createFlagSearchTerm("DELETED", false));
                break;
            }
            case UNDRAFT: {
                builder = SearchTermBuilder.createSearchTermBuilder(SearchTermBuilder.createFlagSearchTerm("DRAFT", false));
                break;
            }
            case UNFLAGGED: {
                builder = SearchTermBuilder.createSearchTermBuilder(SearchTermBuilder.createFlagSearchTerm("FLAGGED", false));
                break;
            }
            case UNSEEN: {
                builder = SearchTermBuilder.createSearchTermBuilder(SearchTermBuilder.createFlagSearchTerm("SEEN", false));
                break;
            }
            case KEYWORD: 
            case UNKEYWORD: {
                builder = SearchTermBuilder.createKeywordSearchTermBuilder(key);
                break;
            }
            case SEQUENCE_SET: {
                builder = SearchTermBuilder.createSequenceSetTermBuilder();
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported search term '" + (Object)((Object)key) + '\'');
            }
        }
        builder.setSearchKey(key);
        return builder;
    }

    private void setSearchKey(SearchKey pKey) {
        this.key = pKey;
    }

    private static SearchTermBuilder createHeaderTermBuilder() {
        return new SearchTermBuilder(){

            @Override
            public SearchTerm build() {
                return new HeaderTerm(this.getParameters().get(0), this.getParameters().get(1));
            }
        };
    }

    SearchTermBuilder addParameter(String pParameter) {
        if (Collections.emptyList() == this.parameters) {
            this.parameters = new ArrayList<String>();
        }
        this.parameters.add(pParameter);
        return this;
    }

    public List<String> getParameters() {
        return this.parameters;
    }

    public String getParameter(int pIdx) {
        return this.getParameters().get(pIdx);
    }

    public boolean expectsParameter() {
        return this.parameters.size() < this.key.getNumberOfParameters();
    }

    public abstract SearchTerm build();

    private static SearchTermBuilder createSearchTermBuilder(final SearchTerm pSearchTerm) {
        return new SearchTermBuilder(){

            @Override
            public SearchTerm build() {
                return pSearchTerm;
            }
        };
    }

    private static SearchTermBuilder createRecipientSearchTermBuilder(final Message.RecipientType type) {
        return new SearchTermBuilder(){

            @Override
            public SearchTerm build() {
                try {
                    return new RecipientTerm(type, (Address)new InternetAddress(this.getParameters().get(0)));
                }
                catch (AddressException e) {
                    throw new IllegalArgumentException("Address is not correct", e);
                }
            }
        };
    }

    private static SearchTermBuilder createFromSearchTermBuilder() {
        return new SearchTermBuilder(){

            @Override
            public SearchTerm build() {
                try {
                    return new FromTerm((Address)new InternetAddress(this.getParameters().get(0)));
                }
                catch (AddressException e) {
                    throw new IllegalArgumentException("Address is not correct", e);
                }
            }
        };
    }

    private static SearchTermBuilder createSubjectTermBuilder() {
        return new SearchTermBuilder(){

            @Override
            public SearchTerm build() {
                return new SubjectTerm(this.getParameters().get(0));
            }
        };
    }

    private static SearchTermBuilder createFlagSearchTermBuilder(final String pFlagName, final boolean pValue) {
        return new SearchTermBuilder(){

            @Override
            public SearchTerm build() {
                return SearchTermBuilder.createFlagSearchTerm(pFlagName, pValue);
            }
        };
    }

    private static SearchTermBuilder createKeywordSearchTermBuilder(final SearchKey pKey) {
        return new SearchTermBuilder(){

            @Override
            public SearchTerm build() {
                return SearchTermBuilder.createFlagSearchTerm(this.getParameter(0), pKey == SearchKey.KEYWORD);
            }
        };
    }

    private static SearchTerm createFlagSearchTerm(String pFlagName, boolean pValue) {
        Flags.Flag flag = SearchTermBuilder.toFlag(pFlagName);
        Flags flags = new Flags();
        if (null == flag) {
            flags.add(pFlagName);
        } else {
            flags.add(flag);
        }
        return new FlagTerm(flags, pValue);
    }

    private static SearchTermBuilder createUidTermBuilder() {
        return new SearchTermBuilder(){

            @Override
            public SearchTerm build() {
                List<IdRange> uidSetList = IdRange.parseRangeSequence(this.getParameter(0));
                return new UidSearchTerm(uidSetList);
            }
        };
    }

    private static SearchTermBuilder createSequenceSetTermBuilder() {
        return new SearchTermBuilder(){

            @Override
            public SearchTerm build() {
                List<IdRange> idRanges = IdRange.parseRangeSequence(this.getParameter(0));
                return new MessageNumberSearchTerm(idRanges);
            }
        };
    }

    private static Flags.Flag toFlag(String pFlag) {
        if (pFlag == null || pFlag.trim().length() < 1) {
            throw new IllegalArgumentException("Can not convert empty string to mail flag");
        }
        String flag = pFlag.trim().toUpperCase();
        if ("ANSWERED".equals(flag)) {
            return Flags.Flag.ANSWERED;
        }
        if ("DELETED".equals(flag)) {
            return Flags.Flag.DELETED;
        }
        if ("DRAFT".equals(flag)) {
            return Flags.Flag.DRAFT;
        }
        if ("FLAGGED".equals(flag)) {
            return Flags.Flag.FLAGGED;
        }
        if ("RECENT".equals(flag)) {
            return Flags.Flag.RECENT;
        }
        if ("SEEN".equals(flag)) {
            return Flags.Flag.SEEN;
        }
        return null;
    }

    public String toString() {
        return "SearchTermBuilder{key=" + (Object)((Object)this.key) + ", parameters=" + this.parameters + '}';
    }

    public static class UidSearchTerm
    extends AbstractIdSearchTerm {
        private static final long serialVersionUID = 1135219503729412087L;

        public UidSearchTerm(List<IdRange> idRanges) {
            super(idRanges);
        }

        @Override
        public boolean match(Message msg) {
            if (msg instanceof StoredMessage.UidAwareMimeMessage) {
                long uid = ((StoredMessage.UidAwareMimeMessage)msg).getUid();
                return this.match(uid);
            }
            Logger log = LoggerFactory.getLogger(UidSearchTerm.class);
            log.warn("No uid support for message " + msg + ", failing to match.");
            return false;
        }
    }

    public static class MessageNumberSearchTerm
    extends AbstractIdSearchTerm {
        private static final long serialVersionUID = -2792493451441320161L;

        public MessageNumberSearchTerm(List<IdRange> idRanges) {
            super(idRanges);
        }

        @Override
        public boolean match(Message msg) {
            return this.match(msg.getMessageNumber());
        }
    }

    public static abstract class AbstractIdSearchTerm
    extends SearchTerm {
        private static final long serialVersionUID = -5935470270189992292L;
        private final List<IdRange> idRanges;

        public AbstractIdSearchTerm(List<IdRange> idRanges) {
            this.idRanges = idRanges;
        }

        public abstract boolean match(Message var1);

        public boolean match(long id) {
            for (IdRange idRange : this.idRanges) {
                if (!idRange.includes(id)) continue;
                return true;
            }
            return false;
        }
    }

    private static class AllSearchTerm
    extends SearchTerm {
        private static final long serialVersionUID = 135627179677024837L;

        private AllSearchTerm() {
        }

        public boolean match(Message msg) {
            return true;
        }
    }
}

