/*
 * Decompiled with CFR 0.152.
 */
package com.icegreen.greenmail.pop3;

import com.icegreen.greenmail.foedus.util.StreamUtils;
import com.icegreen.greenmail.pop3.Pop3Handler;
import com.icegreen.greenmail.util.InternetPrintWriter;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.net.InetAddress;
import java.net.Socket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Pop3Connection {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    Pop3Handler handler;
    Socket socket;
    InetAddress clientAddress;
    BufferedReader in;
    InternetPrintWriter out;

    public Pop3Connection(Pop3Handler handler, Socket socket) throws IOException {
        this.configureSocket(socket);
        this.configureStreams();
        this.handler = handler;
    }

    private void configureStreams() throws IOException {
        OutputStream o = this.socket.getOutputStream();
        InputStream i = this.socket.getInputStream();
        this.out = new InternetPrintWriter(o, true);
        this.in = new BufferedReader(new InputStreamReader(i));
    }

    private void configureSocket(Socket socket) {
        this.socket = socket;
        this.clientAddress = this.socket.getInetAddress();
    }

    public void close() throws IOException {
        this.socket.close();
    }

    public void quit() {
        this.handler.close();
    }

    public void println(String line) {
        this.log.debug("S: {}", (Object)line);
        this.out.print(line);
        this.println();
    }

    public void println() {
        this.out.print("\r\n");
        this.out.flush();
    }

    public void print(Reader in) throws IOException {
        StreamUtils.copy(in, this.out);
        this.out.flush();
    }

    public String readLine() throws IOException {
        String line = this.in.readLine();
        this.log.debug("C: {}", (Object)line);
        return line;
    }

    public String getClientAddress() {
        return this.clientAddress.toString();
    }
}

