/*
 * Decompiled with CFR 0.152.
 */
package com.icegreen.greenmail.smtp;

import com.icegreen.greenmail.server.BuildInfo;
import com.icegreen.greenmail.server.ProtocolHandler;
import com.icegreen.greenmail.smtp.SmtpConnection;
import com.icegreen.greenmail.smtp.SmtpManager;
import com.icegreen.greenmail.smtp.SmtpState;
import com.icegreen.greenmail.smtp.commands.SmtpCommand;
import com.icegreen.greenmail.smtp.commands.SmtpCommandRegistry;
import java.io.IOException;
import java.net.Socket;
import java.net.SocketTimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SmtpHandler
implements ProtocolHandler {
    protected static final Logger log = LoggerFactory.getLogger(SmtpHandler.class);
    protected SmtpCommandRegistry registry;
    protected SmtpManager manager;
    protected SmtpConnection conn;
    protected SmtpState state;
    protected boolean quitting;
    protected String currentLine;
    protected Socket socket;

    public SmtpHandler(SmtpCommandRegistry registry, SmtpManager manager, Socket socket) {
        this.registry = registry;
        this.manager = manager;
        this.socket = socket;
    }

    @Override
    public void run() {
        try {
            this.conn = new SmtpConnection(this, this.socket);
            this.state = new SmtpState();
            this.quitting = false;
            this.sendGreetings();
            while (!this.quitting) {
                this.handleCommand();
            }
        }
        catch (SocketTimeoutException ste) {
            this.conn.send("421 Service shutting down and closing transmission channel");
        }
        catch (Exception e) {
            if (!this.quitting) {
                log.error("Unexpected error handling connection, quitting=", (Throwable)e);
                throw new IllegalStateException(e);
            }
        }
        finally {
            if (null != this.state) {
                this.state.clearMessage();
            }
        }
    }

    protected void sendGreetings() {
        this.conn.send("220 " + this.conn.getServerGreetingsName() + " GreenMail SMTP Service v" + BuildInfo.INSTANCE.getProjectVersion() + " ready");
    }

    protected void handleCommand() throws IOException {
        this.currentLine = this.conn.receiveLine();
        if (this.currentLine == null) {
            this.close();
            return;
        }
        if (!this.commandLegalSize()) {
            return;
        }
        String commandName = this.currentLine.substring(0, 4).toUpperCase();
        SmtpCommand command = this.registry.getCommand(commandName);
        if (command == null) {
            this.conn.send("500 Command not recognized");
            return;
        }
        command.execute(this.conn, this.state, this.manager, this.currentLine);
    }

    protected boolean commandLegalSize() {
        if (this.currentLine.length() < 4) {
            this.conn.send("500 Invalid command. Must be 4 characters");
            return false;
        }
        if (this.currentLine.length() > 4 && this.currentLine.charAt(4) != ' ') {
            this.conn.send("500 Invalid command. Must be 4 characters");
            return false;
        }
        if (this.currentLine.length() > 1000) {
            this.conn.send("500 Command too long.  1000 character maximum.");
            return false;
        }
        return true;
    }

    @Override
    public void close() {
        if (log.isTraceEnabled()) {
            StringBuilder msg = new StringBuilder("Closing SMTP(s) handler connection");
            if (null != this.socket) {
                msg.append(' ').append(this.socket.getInetAddress()).append(':').append(this.socket.getPort());
            }
            log.trace(msg.toString());
        }
        this.quitting = true;
        try {
            if (this.socket != null && !this.socket.isClosed()) {
                this.socket.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

