/*
 * Decompiled with CFR 0.152.
 */
package com.icegreen.greenmail.util;

import com.icegreen.greenmail.user.GreenMailUser;
import com.icegreen.greenmail.util.EncodingUtil;
import com.icegreen.greenmail.util.ServerSetup;
import com.icegreen.greenmail.util.ServerSetupTest;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.Properties;
import java.util.Random;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Part;
import javax.mail.Quota;
import javax.mail.QuotaAwareStore;
import javax.mail.Session;
import javax.mail.Store;
import javax.mail.Transport;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GreenMailUtil {
    private static final Logger log = LoggerFactory.getLogger(GreenMailUtil.class);
    private static int generateCount = 0;
    private static final String GENERATE_SET = "abcdefghijkmnopqrstuvwxyzABCDEFGHJKLMNPRSTUVWXYZ23456789";
    private static final int GENERATE_SET_SIZE = "abcdefghijkmnopqrstuvwxyzABCDEFGHJKLMNPRSTUVWXYZ23456789".length();
    private static final Random RANDOM = new Random();

    private GreenMailUtil() {
    }

    public static void copyStream(InputStream src, OutputStream dest) throws IOException {
        int read;
        byte[] buffer = new byte[1024];
        while ((read = src.read(buffer)) > -1) {
            dest.write(buffer, 0, read);
        }
        dest.flush();
    }

    public static MimeMessage newMimeMessage(InputStream inputStream) {
        try {
            Properties props = new Properties();
            props.put("mail.mime.allowutf8", System.getProperty("mail.mime.allowutf8", "true"));
            return new MimeMessage(Session.getDefaultInstance((Properties)props), inputStream);
        }
        catch (MessagingException e) {
            throw new IllegalArgumentException("Can not generate mime message for input stream " + inputStream, e);
        }
    }

    public static MimeMessage newMimeMessage(String mailString) {
        return GreenMailUtil.newMimeMessage(EncodingUtil.toStream(mailString, EncodingUtil.CHARSET_EIGHT_BIT_ENCODING));
    }

    public static boolean hasNonTextAttachments(Part m) {
        try {
            Object content = m.getContent();
            if (content instanceof MimeMultipart) {
                MimeMultipart mm = (MimeMultipart)content;
                for (int i = 0; i < mm.getCount(); ++i) {
                    BodyPart p = mm.getBodyPart(i);
                    if (!GreenMailUtil.hasNonTextAttachments((Part)p)) continue;
                    return true;
                }
                return false;
            }
            return !m.getContentType().trim().toLowerCase().startsWith("text");
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static int getLineCount(String str) {
        if (null == str || str.isEmpty()) {
            return 0;
        }
        int count = 1;
        for (char c : str.toCharArray()) {
            if ('\n' != c) continue;
            ++count;
        }
        return count;
    }

    public static String getBody(Part msg) {
        String all = GreenMailUtil.getWholeMessage(msg);
        int i = all.indexOf("\r\n\r\n");
        return i < 0 ? "" : all.substring(i + 4);
    }

    public static String getHeaders(Part msg) {
        String all = GreenMailUtil.getWholeMessage(msg);
        int i = all.indexOf("\r\n\r\n");
        return i < 0 ? all : all.substring(0, i);
    }

    public static String getWholeMessage(Part msg) {
        try {
            ByteArrayOutputStream bodyOut = new ByteArrayOutputStream();
            msg.writeTo((OutputStream)bodyOut);
            return bodyOut.toString("ISO-8859-1").trim();
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public static byte[] getBodyAsBytes(Part msg) {
        return GreenMailUtil.getBody(msg).getBytes(EncodingUtil.CHARSET_EIGHT_BIT_ENCODING);
    }

    public static byte[] getHeaderAsBytes(Part part) {
        return GreenMailUtil.getHeaders(part).getBytes(EncodingUtil.CHARSET_EIGHT_BIT_ENCODING);
    }

    public static String toString(Part msg) {
        return GreenMailUtil.getWholeMessage(msg);
    }

    public static String random() {
        int nbrOfLetters = RANDOM.nextInt(3) + 5;
        return GreenMailUtil.random(nbrOfLetters);
    }

    public static String random(int nbrOfLetters) {
        StringBuilder ret = new StringBuilder();
        while (nbrOfLetters > 0) {
            int pos = (RANDOM.nextInt(GENERATE_SET_SIZE) + ++generateCount) % GENERATE_SET_SIZE;
            ret.append(GENERATE_SET.charAt(pos));
            --nbrOfLetters;
        }
        return ret.toString();
    }

    public static void sendTextEmailTest(String to, String from, String subject, String msg) {
        GreenMailUtil.sendTextEmail(to, from, subject, msg, ServerSetupTest.SMTP);
    }

    public static void sendTextEmailSecureTest(String to, String from, String subject, String msg) {
        GreenMailUtil.sendTextEmail(to, from, subject, msg, ServerSetupTest.SMTPS);
    }

    public static String getAddressList(Address[] addresses) {
        if (null == addresses) {
            return null;
        }
        StringBuilder ret = new StringBuilder();
        for (int i = 0; i < addresses.length; ++i) {
            if (i > 0) {
                ret.append(", ");
            }
            ret.append(addresses[i].toString());
        }
        return ret.toString();
    }

    public static MimeMessage createTextEmail(String to, String from, String subject, String msg, ServerSetup setup) {
        try {
            Session session = GreenMailUtil.getSession(setup);
            MimeMessage mimeMessage = new MimeMessage(session);
            mimeMessage.setSubject(subject);
            mimeMessage.setSentDate(new Date());
            mimeMessage.setFrom(from);
            mimeMessage.setRecipients(Message.RecipientType.TO, to);
            mimeMessage.setText(msg);
            return mimeMessage;
        }
        catch (MessagingException e) {
            throw new IllegalArgumentException("Can not generate message", e);
        }
    }

    public static void sendTextEmail(String to, String from, String subject, String msg, ServerSetup setup) {
        GreenMailUtil.sendMimeMessage(GreenMailUtil.createTextEmail(to, from, subject, msg, setup));
    }

    public static void sendMimeMessage(MimeMessage mimeMessage) {
        try {
            Transport.send((Message)mimeMessage);
        }
        catch (MessagingException e) {
            throw new IllegalStateException("Can not send message " + mimeMessage, e);
        }
    }

    public static void sendMimeMessage(MimeMessage mimeMessage, String username, String password) {
        try {
            Transport.send((Message)mimeMessage, (String)username, (String)password);
        }
        catch (MessagingException e) {
            throw new IllegalStateException("Can not send message " + mimeMessage, e);
        }
    }

    public static void sendMessageBody(String to, String from, String subject, Object body, String contentType, ServerSetup serverSetup) {
        try {
            Session smtpSession = GreenMailUtil.getSession(serverSetup);
            MimeMessage mimeMessage = new MimeMessage(smtpSession);
            mimeMessage.setRecipients(Message.RecipientType.TO, to);
            mimeMessage.setFrom(from);
            mimeMessage.setSubject(subject);
            mimeMessage.setContent(body, contentType);
            GreenMailUtil.sendMimeMessage(mimeMessage);
        }
        catch (MessagingException e) {
            throw new IllegalStateException("Can not send message", e);
        }
    }

    public static void sendAttachmentEmail(String to, String from, String subject, String msg, byte[] attachment, String contentType, String filename, String description, ServerSetup setup) {
        MimeMultipart multiPart = GreenMailUtil.createMultipartWithAttachment(msg, attachment, contentType, filename, description);
        GreenMailUtil.sendMessageBody(to, from, subject, multiPart, null, setup);
    }

    public static MimeMultipart createMultipartWithAttachment(String msg, final byte[] attachment, final String contentType, final String filename, String description) {
        try {
            MimeMultipart multiPart = new MimeMultipart();
            MimeBodyPart textPart = new MimeBodyPart();
            multiPart.addBodyPart((BodyPart)textPart);
            textPart.setText(msg);
            MimeBodyPart binaryPart = new MimeBodyPart();
            multiPart.addBodyPart((BodyPart)binaryPart);
            DataSource ds = new DataSource(){

                public InputStream getInputStream() {
                    return new ByteArrayInputStream(attachment);
                }

                public OutputStream getOutputStream() throws IOException {
                    ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
                    byteStream.write(attachment);
                    return byteStream;
                }

                public String getContentType() {
                    return contentType;
                }

                public String getName() {
                    return filename;
                }
            };
            binaryPart.setDataHandler(new DataHandler(ds));
            binaryPart.setFileName(filename);
            binaryPart.setDescription(description);
            return multiPart;
        }
        catch (MessagingException e) {
            throw new IllegalArgumentException("Can not create multipart message with attachment", e);
        }
    }

    public static Session getSession(ServerSetup setup) {
        return GreenMailUtil.getSession(setup, null);
    }

    public static Session getSession(ServerSetup setup, Properties mailProps) {
        return GreenMailUtil.getSession(setup, mailProps, false);
    }

    public static Session getSession(ServerSetup setup, Properties mailProps, boolean debug) {
        Properties props = setup.configureJavaMailSessionProperties(mailProps, debug);
        log.debug("Mail session properties are {}", (Object)props);
        return Session.getInstance((Properties)props, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setQuota(GreenMailUser user, Quota quota) {
        Session session = GreenMailUtil.getSession(ServerSetupTest.IMAP);
        try {
            store.connect(user.getEmail(), user.getPassword());
            try (Store store = session.getStore("imap");){
                ((QuotaAwareStore)store).setQuota(quota);
            }
        }
        catch (Exception ex) {
            throw new IllegalStateException("Can not set quota " + quota + " for user " + user, ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Quota[] getQuota(GreenMailUser user, String quotaRoot) {
        Quota[] quotaArray;
        Session session = GreenMailUtil.getSession(ServerSetupTest.IMAP);
        Store store = session.getStore("imap");
        store.connect(user.getEmail(), user.getPassword());
        try {
            quotaArray = ((QuotaAwareStore)store).getQuota(quotaRoot);
        }
        catch (Throwable throwable) {
            try {
                store.close();
                throw throwable;
            }
            catch (Exception ex) {
                throw new IllegalStateException("Can not get quota for quota root " + quotaRoot + " for user " + user, ex);
            }
        }
        store.close();
        return quotaArray;
    }
}

