/*
 * Decompiled with CFR 0.152.
 */
package com.icegreen.greenmail.imap;

import com.icegreen.greenmail.imap.ImapHandler;
import com.icegreen.greenmail.imap.ImapHostManager;
import com.icegreen.greenmail.imap.ImapResponse;
import com.icegreen.greenmail.imap.ImapSession;
import com.icegreen.greenmail.imap.ImapSessionFolder;
import com.icegreen.greenmail.imap.ImapSessionState;
import com.icegreen.greenmail.store.FolderException;
import com.icegreen.greenmail.store.MailFolder;
import com.icegreen.greenmail.store.MessageFlags;
import com.icegreen.greenmail.user.GreenMailUser;
import com.icegreen.greenmail.user.UserManager;
import jakarta.mail.Flags;
import java.util.List;

public final class ImapSessionImpl
implements ImapSession {
    private ImapSessionState state = ImapSessionState.NON_AUTHENTICATED;
    private GreenMailUser user = null;
    private ImapSessionFolder selectedMailbox = null;
    private String clientAddress;
    private ImapHandler handler;
    private ImapHostManager imapHost;
    private UserManager users;

    public ImapSessionImpl(ImapHostManager imapHost, UserManager users, ImapHandler handler, String clientAddress) {
        this.imapHost = imapHost;
        this.users = users;
        this.handler = handler;
        this.clientAddress = clientAddress;
    }

    @Override
    public ImapHostManager getHost() {
        return this.imapHost;
    }

    @Override
    public void unsolicitedResponses(ImapResponse request) throws FolderException {
        this.unsolicitedResponses(request, false);
    }

    @Override
    public void unsolicitedResponses(ImapResponse response, boolean omitExpunged) throws FolderException {
        ImapSessionFolder selected = this.getSelected();
        if (selected != null) {
            if (selected.isSizeChanged()) {
                response.existsResponse(selected.getMessageCount());
                response.recentResponse(selected.getRecentCount(true));
                selected.setSizeChanged(false);
            }
            List<ImapSessionFolder.FlagUpdate> flagUpdates = selected.getFlagUpdates();
            for (ImapSessionFolder.FlagUpdate update : flagUpdates) {
                int msn = update.getMsn();
                Flags updatedFlags = update.getFlags();
                StringBuilder out = new StringBuilder("FLAGS ");
                out.append(MessageFlags.format(updatedFlags));
                if (update.getUid() != null) {
                    out.append(" UID ");
                    out.append(update.getUid());
                }
                response.fetchResponse(msn, out.toString());
            }
            if (!omitExpunged) {
                int[] expunged;
                for (int msn : expunged = selected.getExpunged()) {
                    response.expungeResponse(msn);
                }
            }
        }
    }

    @Override
    public void closeConnection(String byeMessage) {
        this.handler.forceConnectionClose(byeMessage);
    }

    @Override
    public void closeConnection() {
        this.handler.close();
    }

    @Override
    public UserManager getUserManager() {
        return this.users;
    }

    @Override
    public String getClientIP() {
        return this.clientAddress;
    }

    @Override
    public void setAuthenticated(GreenMailUser user) {
        this.state = ImapSessionState.AUTHENTICATED;
        this.user = user;
    }

    @Override
    public GreenMailUser getUser() {
        return this.user;
    }

    @Override
    public void deselect() {
        this.state = ImapSessionState.AUTHENTICATED;
        if (this.selectedMailbox != null) {
            this.selectedMailbox.removeListener(this.selectedMailbox);
            this.selectedMailbox = null;
        }
    }

    @Override
    public void setSelected(MailFolder folder, boolean readOnly) {
        ImapSessionFolder sessionMailbox = new ImapSessionFolder(folder, this, readOnly);
        this.state = ImapSessionState.SELECTED;
        this.selectedMailbox = sessionMailbox;
    }

    @Override
    public ImapSessionFolder getSelected() {
        return this.selectedMailbox;
    }

    @Override
    public ImapSessionState getState() {
        return this.state;
    }
}

