/*
 * Decompiled with CFR 0.152.
 */
package com.icegreen.greenmail.imap.commands;

import com.icegreen.greenmail.imap.AuthorizationException;
import com.icegreen.greenmail.imap.ImapRequestLineReader;
import com.icegreen.greenmail.imap.ImapResponse;
import com.icegreen.greenmail.imap.ImapSession;
import com.icegreen.greenmail.imap.ImapSessionFolder;
import com.icegreen.greenmail.imap.ProtocolException;
import com.icegreen.greenmail.imap.commands.SelectedStateCommand;
import com.icegreen.greenmail.imap.commands.SortCommandParser;
import com.icegreen.greenmail.imap.commands.SortTerm;
import com.icegreen.greenmail.imap.commands.StoredMessageSorter;
import com.icegreen.greenmail.imap.commands.UidEnabledCommand;
import com.icegreen.greenmail.store.FolderException;
import com.icegreen.greenmail.store.StoredMessage;
import java.util.ArrayList;

class SortCommand
extends SelectedStateCommand
implements UidEnabledCommand {
    public static final String NAME = "SORT";
    public static final String ARGS = "(<sort criteria>) <charset specification> <search term>";
    public static final String CAPABILITY = "SORT";
    private final SortCommandParser sortCommandParser = new SortCommandParser();

    SortCommand() {
        super("SORT", ARGS);
    }

    @Override
    protected void doProcess(ImapRequestLineReader request, ImapResponse response, ImapSession session) throws ProtocolException, FolderException, AuthorizationException {
        this.doProcess(request, response, session, false);
    }

    @Override
    public void doProcess(ImapRequestLineReader request, ImapResponse response, ImapSession session, boolean useUids) throws ProtocolException, FolderException {
        SortTerm sortTerm;
        try {
            sortTerm = this.sortCommandParser.sortTerm(request);
        }
        catch (ProtocolException e) {
            response.commandError("Sort/search command failed to parse: " + e.getMessage());
            return;
        }
        ImapSessionFolder folder = session.getSelected();
        long[] uids = folder.search(sortTerm.getSearchTerm());
        ArrayList<StoredMessage> messages = new ArrayList<StoredMessage>();
        for (long uid : uids) {
            messages.add(folder.getMessage(uid));
        }
        messages.sort(new StoredMessageSorter(sortTerm));
        StringBuilder idList = new StringBuilder();
        for (int i = 0; i < messages.size(); ++i) {
            if (i > 0) {
                idList.append(" ");
            }
            StoredMessage message = (StoredMessage)messages.get(i);
            if (useUids) {
                idList.append(message.getUid());
                continue;
            }
            int msn = folder.getMsn(message.getUid());
            idList.append(msn);
        }
        response.commandResponse(this, idList.toString());
        boolean omitExpunged = !useUids;
        session.unsolicitedResponses(response, omitExpunged);
        response.commandComplete(this);
    }
}

