/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.meta.common.utils;

import com.igormaznitsa.meta.annotation.Weight;
import com.igormaznitsa.meta.common.exceptions.AlreadyDisposedError;
import com.igormaznitsa.meta.common.exceptions.InvalidObjectError;
import com.igormaznitsa.meta.common.exceptions.MetaErrorListeners;
import com.igormaznitsa.meta.common.interfaces.Disposable;
import com.igormaznitsa.meta.common.utils.GetUtils;
import com.igormaznitsa.meta.common.utils.Validator;
import java.util.Collection;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
@Weight(value=Weight.Unit.LIGHT)
public final class Assertions {
    private Assertions() {
    }

    @Nonnull
    public static Error fail(@Nullable String message) {
        AssertionError error = new AssertionError((Object)GetUtils.ensureNonNull(message, "failed"));
        MetaErrorListeners.fireError("Asserion error", (Throwable)((Object)error));
        throw error;
    }

    @Nullable
    public static <T> T assertNull(@Nullable T object) {
        return Assertions.assertNull(null, object);
    }

    public static <T> T assertNull(@Nullable String failMessage, @Nullable T object) {
        if (object != null) {
            String txt = failMessage == null ? "Object must be NULL" : failMessage;
            AssertionError error = new AssertionError((Object)txt);
            MetaErrorListeners.fireError(txt, (Throwable)((Object)error));
            throw error;
        }
        return object;
    }

    @Nonnull
    public static <T> T assertNotNull(@Nullable T object) {
        return Assertions.assertNotNull(null, object);
    }

    @Nonnull
    public static <T> T assertNotNull(@Nullable String failMessage, @Nullable T object) {
        if (object == null) {
            String txt = failMessage == null ? "Object must not be NULL" : failMessage;
            AssertionError error = new AssertionError((Object)txt);
            MetaErrorListeners.fireError(txt, (Throwable)((Object)error));
            throw error;
        }
        return object;
    }

    @Nonnull
    public static <T> T[] assertDoesntContainNull(@Nonnull T[] array) {
        Assertions.assertNotNull(array);
        for (T obj : array) {
            if (obj != null) continue;
            AssertionError error = new AssertionError((Object)"Array must not contain NULL");
            MetaErrorListeners.fireError("Asserion error", (Throwable)((Object)error));
            throw error;
        }
        return array;
    }

    public static void assertTrue(@Nullable String message, boolean condition) {
        if (!condition) {
            AssertionError error = new AssertionError((Object)GetUtils.ensureNonNull(message, "Condition must be TRUE"));
            MetaErrorListeners.fireError(((Throwable)((Object)error)).getMessage(), (Throwable)((Object)error));
            throw error;
        }
    }

    public static <T> T assertEquals(@Nullable T etalon, @Nullable T value) {
        if (etalon == null) {
            Assertions.assertNull(value);
        } else if (etalon != value && !etalon.equals(value)) {
            AssertionError error = new AssertionError((Object)"Value is not equal to etalon");
            MetaErrorListeners.fireError(((Throwable)((Object)error)).getMessage(), (Throwable)((Object)error));
            throw error;
        }
        return value;
    }

    public static void assertFalse(@Nullable String message, boolean condition) {
        if (condition) {
            AssertionError error = new AssertionError((Object)GetUtils.ensureNonNull(message, "Condition must be FALSE"));
            MetaErrorListeners.fireError(((Throwable)((Object)error)).getMessage(), (Throwable)((Object)error));
            throw error;
        }
    }

    @Nonnull
    public static <T extends Collection<?>> T assertDoesntContainNull(@Nonnull T collection) {
        Assertions.assertNotNull(collection);
        for (Object obj : collection) {
            Assertions.assertNotNull(obj);
        }
        return collection;
    }

    @Nonnull
    public static <T extends Disposable> T assertNotDisposed(@Nonnull T disposable) {
        if (disposable.isDisposed()) {
            AlreadyDisposedError error = new AlreadyDisposedError("Object already disposed");
            MetaErrorListeners.fireError("Asserion error", (Throwable)((Object)error));
            throw error;
        }
        return disposable;
    }

    @Nullable
    public static <T> T assertAmong(@Nullable T obj, T ... list) {
        if (obj == null) {
            for (T i : Assertions.assertNotNull(list)) {
                if (i != null) continue;
                return i;
            }
        } else {
            int objHash = obj.hashCode();
            for (T i : Assertions.assertNotNull(list)) {
                if (obj != i && (i == null || objHash != i.hashCode() || !obj.equals(i))) continue;
                return i;
            }
        }
        AssertionError error = new AssertionError((Object)"Object is not found among elements");
        MetaErrorListeners.fireError("Asserion error", (Throwable)((Object)error));
        throw error;
    }

    @Nullable
    public static <T> T assertIsValid(@Nullable T obj, @Nonnull Validator<T> validator) {
        if (Assertions.assertNotNull(validator).isValid(obj)) {
            return obj;
        }
        InvalidObjectError error = new InvalidObjectError("Detected invalid object", obj);
        MetaErrorListeners.fireError("Invalid object", (Throwable)((Object)error));
        throw error;
    }
}

