/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.mvngolang;

import com.igormaznitsa.mvngolang.AbstractPackageGolangMojo;
import com.igormaznitsa.mvngolang.utils.ProxySettings;
import java.io.File;
import java.io.IOException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.codehaus.plexus.util.FileUtils;

@Mojo(name="clean", defaultPhase=LifecyclePhase.CLEAN, threadSafe=true, requiresDependencyResolution=ResolutionScope.NONE)
public class GolangCleanMojo
extends AbstractPackageGolangMojo {
    @Parameter(name="cleanGoPath", defaultValue="false")
    private boolean cleanGoPath;
    @Parameter(name="deleteStoreFolder", defaultValue="false")
    private boolean deleteStoreFolder;

    @Override
    public boolean isSourceFolderRequired() {
        return true;
    }

    @Override
    @Nonnull
    public String getGoCommand() {
        return "clean";
    }

    private void deleteStoreFolder() throws MojoFailureException {
        try {
            File goStoreFolder = new File(this.getStoreFolder());
            if (goStoreFolder.isDirectory()) {
                this.getLog().info((CharSequence)("Deleting the Store Folder : " + goStoreFolder));
                FileUtils.deleteDirectory((File)goStoreFolder);
            } else {
                this.getLog().info((CharSequence)("The Store Folder does not found : " + goStoreFolder));
            }
        }
        catch (IOException ex) {
            throw new MojoFailureException("Can't delete the Store Folder", (Throwable)ex);
        }
    }

    private void cleanGoPath() throws MojoFailureException {
        try {
            File goPathFolder = this.findGoPath(false);
            if (goPathFolder.isDirectory()) {
                this.getLog().info((CharSequence)("Cleaning the Go Path folder : " + goPathFolder));
                FileUtils.cleanDirectory((File)goPathFolder);
            } else {
                this.getLog().info((CharSequence)("The Go Path folder not found : " + goPathFolder));
            }
        }
        catch (IOException ex) {
            throw new MojoFailureException("Can't clean the Go Path folder", (Throwable)ex);
        }
    }

    @Override
    public void afterExecution(@Nullable ProxySettings proxySettings, boolean error) throws MojoFailureException, MojoExecutionException {
        if (!error) {
            File directory = this.getProject().getPackaging().equals("mvn-golang") ? new File(this.getProject().getBasedir(), "bin") : new File(this.getProject().getBuild().getDirectory());
            if (directory.isDirectory()) {
                try {
                    this.getLog().info((CharSequence)("Deleting folder : " + directory));
                    FileUtils.deleteDirectory((File)directory);
                }
                catch (IOException ex) {
                    throw new MojoFailureException("Can't delete folder", (Throwable)ex);
                }
            } else {
                this.getLog().info((CharSequence)String.format("Folder %s is not found", directory.getAbsolutePath()));
            }
            File reportFolderFile = new File(this.getReportsFolder());
            if (reportFolderFile.isDirectory()) {
                try {
                    this.getLog().info((CharSequence)("Deleting report folder : " + reportFolderFile));
                    FileUtils.deleteDirectory((File)reportFolderFile);
                }
                catch (IOException ex) {
                    throw new MojoExecutionException("Can't delete report folder : " + reportFolderFile);
                }
            } else {
                this.getLog().debug((CharSequence)("There is no report folder : " + reportFolderFile));
            }
            if (this.cleanGoPath) {
                this.cleanGoPath();
            }
            if (this.deleteStoreFolder) {
                this.deleteStoreFolder();
            }
        }
    }

    @Override
    protected boolean processConsoleOut(int exitCode, @Nonnull String out, @Nonnull String err) throws MojoFailureException, MojoExecutionException {
        return false;
    }
}

