/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.mvngolang;

import com.igormaznitsa.meta.annotation.MustNotContainNull;
import com.igormaznitsa.meta.common.utils.ArrayUtils;
import com.igormaznitsa.meta.common.utils.GetUtils;
import com.igormaznitsa.mvngolang.AbstractPackageGolangMojo;
import java.io.File;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;

@Mojo(name="test", defaultPhase=LifecyclePhase.TEST, threadSafe=true, requiresDependencyResolution=ResolutionScope.TEST)
public class GolangTestMojo
extends AbstractPackageGolangMojo {
    @Parameter(name="testFlags")
    private String[] testFlags;

    @Nonnull
    private String ensureGoExtension(@Nonnull String name) {
        return name.endsWith(".go") ? name : name + ".go";
    }

    @Override
    @Nullable
    @MustNotContainNull
    protected String[] getDefaultPackages() {
        String definedTest = System.getProperty("test");
        if (definedTest != null) {
            int index = definedTest.indexOf(35);
            String[] name = index >= 0 ? new String[]{definedTest.substring(0, index), definedTest.substring(index + 1)} : new String[]{definedTest};
            ArrayList<String> result = new ArrayList<String>();
            result.add(this.ensureGoExtension(name[0]));
            if (definedTest.length() > 1) {
                result.add("-run");
                result.add(name[1]);
            }
            return result.toArray(new String[result.size()]);
        }
        return new String[]{'.' + File.separator + "..."};
    }

    @Override
    public boolean isIgnoreErrorExitCode() {
        return Boolean.parseBoolean(System.getProperty("maven.test.failure.ignore")) || super.isIgnoreErrorExitCode();
    }

    @Nullable
    @MustNotContainNull
    public String[] getTestFlags() {
        return this.testFlags == null ? null : (String[])this.testFlags.clone();
    }

    @Override
    public boolean isSourceFolderRequired() {
        return true;
    }

    @Override
    @Nonnull
    @MustNotContainNull
    public String[] getOptionalExtraTailArguments() {
        return (String[])GetUtils.ensureNonNull((Object)this.testFlags, (Object)ArrayUtils.EMPTY_STRING_ARRAY);
    }

    @Override
    @Nonnull
    public String getGoCommand() {
        return "test";
    }

    @Override
    public boolean enforcePrintOutput() {
        return true;
    }
}

