/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.mvngolang.cvs;

import com.igormaznitsa.mvngolang.cvs.AbstractRepo;
import com.igormaznitsa.mvngolang.utils.ProxySettings;
import java.io.File;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.maven.plugin.logging.Log;

public class CvsBZR
extends AbstractRepo {
    public CvsBZR() {
        super("bzr");
    }

    @Override
    public boolean doesContainCVS(@Nonnull File folder) {
        return new File(folder, ".bzr").isDirectory();
    }

    @Override
    public boolean processCVSRequisites(@Nonnull Log logger, @Nullable ProxySettings proxy, @Nullable String customCommand, @Nonnull File cvsFolder, @Nullable String branchId, @Nullable String tagId, @Nullable String revisionId) {
        boolean noError = true;
        if (branchId != null) {
            noError &= this.upToBranch(logger, proxy, customCommand, cvsFolder, branchId);
        }
        if (noError && tagId != null) {
            noError &= this.upToTag(logger, proxy, customCommand, cvsFolder, tagId);
        }
        if (noError && revisionId != null) {
            noError &= this.upToRevision(logger, proxy, customCommand, cvsFolder, revisionId);
        }
        return noError;
    }

    private boolean upToBranch(@Nonnull Log logger, @Nullable ProxySettings proxy, @Nullable String customCommand, @Nonnull File cvsFolder, @Nonnull String branchId) {
        logger.debug((CharSequence)("upToBranch : " + branchId));
        return this.checkResult(logger, this.execute(customCommand, logger, cvsFolder, "switch", "--force", branchId));
    }

    private boolean upToTag(@Nonnull Log logger, @Nullable ProxySettings proxy, @Nullable String customCommand, @Nonnull File cvsFolder, @Nonnull String tagId) {
        logger.debug((CharSequence)("upToTag : " + tagId));
        return this.checkResult(logger, this.execute(customCommand, logger, cvsFolder, "switch", "--force", tagId));
    }

    private boolean upToRevision(@Nonnull Log logger, @Nullable ProxySettings proxy, @Nullable String customCommand, @Nonnull File cvsFolder, @Nonnull String revisionId) {
        logger.debug((CharSequence)("upToRevision : " + revisionId));
        return this.checkResult(logger, this.execute(customCommand, logger, cvsFolder, "switch", "--force", "--revision", revisionId));
    }
}

