/*
 * Decompiled with CFR 0.152.
 */
package com.ing.data.cassandra.jdbc.json;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.exc.InvalidFormatException;
import com.fasterxml.jackson.databind.util.ClassUtil;
import java.io.IOException;
import java.time.DateTimeException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;

public class CassandraDateTimeDeserializer
extends JsonDeserializer<OffsetDateTime> {
    public OffsetDateTime deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        String value = jsonParser.getValueAsString();
        if (value != null) {
            value = value.replace("Z", "+0000");
            try {
                DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd' 'HH:mm:ss.SSSZ");
                return OffsetDateTime.parse(value, dateTimeFormatter);
            }
            catch (DateTimeException e) {
                String msg = String.format("Cannot deserialize value of type %s from: '%s'", ClassUtil.nameOf(OffsetDateTime.class), value);
                throw InvalidFormatException.from((JsonParser)jsonParser, (String)msg, (Object)value, OffsetDateTime.class);
            }
        }
        return null;
    }
}

