/*
 * Decompiled with CFR 0.152.
 */
package com.instana.android.core;

import android.content.Context;
import android.webkit.URLUtil;
import androidx.annotation.RestrictTo;
import androidx.annotation.VisibleForTesting;
import androidx.work.Configuration;
import androidx.work.Constraints;
import androidx.work.ExistingWorkPolicy;
import androidx.work.NetworkType;
import androidx.work.WorkManager;
import com.instana.android.Instana;
import com.instana.android.core.InstanaConfig;
import com.instana.android.core.InstanaWorkManager;
import com.instana.android.core.InstanaWorkManager$WhenMappings;
import com.instana.android.core.event.models.Beacon;
import com.instana.android.core.event.worker.EventWorker;
import com.instana.android.core.util.FileExtensionsKt;
import com.instana.android.core.util.Logger;
import java.io.File;
import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.GlobalScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0007\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0003H\u0002J\u0010\u0010\u0017\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\u0003H\u0002J\u0018\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\b2\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\b\u0010\u001c\u001a\u00020\bH\u0002J\u000f\u0010\u001d\u001a\u0004\u0018\u00010\u001bH\u0001\u00a2\u0006\u0002\b\u001eJ\u000e\u0010\u001f\u001a\u00020\u00152\u0006\u0010 \u001a\u00020\u0011J\u0016\u0010!\u001a\u00020\u00152\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0002R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082D\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/instana/android/core/InstanaWorkManager;", "", "config", "Lcom/instana/android/core/InstanaConfig;", "context", "Landroid/content/Context;", "(Lcom/instana/android/core/InstanaConfig;Landroid/content/Context;)V", "beaconsDirectory", "Ljava/io/File;", "beaconsDirectoryName", "", "constraints", "Landroidx/work/Constraints;", "flushDelayMs", "", "initialDelayQueue", "Ljava/util/Queue;", "Lcom/instana/android/core/event/models/Beacon;", "isInitialDelayComplete", "", "checkConfigurationParameters", "", "instanaConfig", "configureWorkManager", "flush", "directory", "manager", "Landroidx/work/WorkManager;", "getBeaconsDirectory", "getWorkManager", "getWorkManager$runtime_release", "queue", "beacon", "updateQueueItems", "runtime_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY})
public final class InstanaWorkManager {
    private final String beaconsDirectoryName = "instanaBeacons";
    private final long flushDelayMs = 1000L;
    private final Constraints constraints;
    private File beaconsDirectory;
    private Queue<Beacon> initialDelayQueue;
    private boolean isInitialDelayComplete;
    private final Context context;

    private final void updateQueueItems(Queue<Beacon> queue2) {
        Logger.d("Updating " + queue2.size() + " queue items");
        for (Beacon item : queue2) {
            Object $this$run;
            Object object;
            boolean bl;
            boolean bl2;
            Logger.d("Updating queue item with: `beaconId` " + item.getBeaconId());
            if (Instana.INSTANCE.getUserProfile$runtime_release().getUserName() != null) {
                bl2 = false;
                bl = false;
                $this$run = object;
                boolean bl3 = false;
                item.setUserName((String)$this$run);
            }
            if (Instana.INSTANCE.getUserProfile$runtime_release().getUserId() != null) {
                bl2 = false;
                bl = false;
                $this$run = object;
                boolean bl4 = false;
                item.setUserId((String)$this$run);
            }
            if (Instana.INSTANCE.getUserProfile$runtime_release().getUserEmail() != null) {
                bl2 = false;
                bl = false;
                $this$run = object;
                boolean bl5 = false;
                item.setUserEmail((String)$this$run);
            }
            if (item.getView() == null && Instana.INSTANCE.getFirstView$runtime_release() != null) {
                bl2 = false;
                bl = false;
                $this$run = object;
                boolean bl6 = false;
                item.setView((String)$this$run);
            }
            if (item.getRooted() == null && Instana.INSTANCE.getDeviceProfile$runtime_release().getRooted() != null) {
                bl2 = false;
                bl = false;
                boolean $this$run2 = (Boolean)object;
                boolean bl7 = false;
                item.setRooted($this$run2);
            }
            if (item.getGooglePlayServicesMissing() == null && Instana.getGooglePlayServicesMissing() != null) {
                bl2 = false;
                bl = false;
                boolean $this$run3 = (Boolean)object;
                boolean bl8 = false;
                item.setGooglePlayServicesMissing($this$run3);
            }
            Map<String, String> $this$forEach$iv = Instana.getMeta().getAll();
            boolean $i$f$forEach = false;
            Map<String, String> map = $this$forEach$iv;
            boolean bl9 = false;
            Iterator<Map.Entry<String, String>> iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, String> element$iv;
                Map.Entry<String, String> it = element$iv = iterator.next();
                boolean bl10 = false;
                if (item.getMeta(it.getKey()) != null) continue;
                item.setMeta(it.getKey(), it.getValue());
            }
        }
    }

    private final File getBeaconsDirectory() {
        File directory = this.beaconsDirectory;
        if (directory == null) {
            File file = new File(this.context.getFilesDir(), this.beaconsDirectoryName);
            boolean bl = false;
            boolean bl2 = false;
            File $this$apply = file;
            boolean bl3 = false;
            $this$apply.mkdirs();
            this.beaconsDirectory = directory = file;
        }
        return directory;
    }

    @VisibleForTesting
    @Nullable
    public final WorkManager getWorkManager$runtime_release() {
        try {
            return WorkManager.getInstance();
        }
        catch (IllegalStateException e) {
            WorkManager workManager;
            Logger.e("WorkManager has not been properly initialized. Please check your code and your dependencies for similar issues", e);
            Logger.e("Instana Agent will now try to initialize WorkManager with the default configuration");
            Configuration configuration = new Configuration.Builder().build();
            Intrinsics.checkExpressionValueIsNotNull((Object)configuration, (String)"Configuration.Builder()\n            .build()");
            Configuration config = configuration;
            try {
                WorkManager.initialize((Context)this.context, (Configuration)config);
                workManager = WorkManager.getInstance();
            }
            catch (Throwable e2) {
                Logger.e("Instana Agent failed to initialize WorkManager. Beacons will not be sent until the issue is solved", e2);
                workManager = null;
            }
            return workManager;
        }
    }

    private final Constraints configureWorkManager(InstanaConfig instanaConfig) {
        NetworkType networkType = null;
        boolean lowBattery = false;
        switch (InstanaWorkManager$WhenMappings.$EnumSwitchMapping$0[instanaConfig.getSuspendReporting().ordinal()]) {
            case 1: {
                networkType = NetworkType.CONNECTED;
                lowBattery = false;
                break;
            }
            case 2: {
                networkType = NetworkType.CONNECTED;
                lowBattery = true;
                break;
            }
            case 3: {
                networkType = NetworkType.UNMETERED;
                lowBattery = false;
                break;
            }
            case 4: {
                networkType = NetworkType.UNMETERED;
                lowBattery = true;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        Constraints constraints = new Constraints.Builder().setRequiredNetworkType(networkType).setRequiresBatteryNotLow(lowBattery).setRequiresCharging(false).build();
        Intrinsics.checkExpressionValueIsNotNull((Object)constraints, (String)"Constraints.Builder()\n  \u2026lse)\n            .build()");
        return constraints;
    }

    private final void checkConfigurationParameters(InstanaConfig instanaConfig) {
        CharSequence charSequence = instanaConfig.getReportingURL();
        boolean bl = false;
        if (charSequence.length() == 0) {
            throw (Throwable)new IllegalArgumentException("Reporting Server url cannot be blank!");
        }
        if (!URLUtil.isValidUrl((String)instanaConfig.getReportingURL())) {
            throw (Throwable)new IllegalArgumentException("Please provide a valid server url!");
        }
        charSequence = instanaConfig.getKey();
        bl = false;
        if (charSequence.length() == 0) {
            throw (Throwable)new IllegalArgumentException("Api key cannot be blank!");
        }
    }

    private final void flush(File directory, WorkManager manager) {
        String tag;
        Logger.i("Flushing beacons");
        if (FileExtensionsKt.isDirectoryEmpty(directory)) {
            return;
        }
        String string = tag = directory.getAbsolutePath();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"tag");
        manager.enqueueUniqueWork(tag, ExistingWorkPolicy.REPLACE, EventWorker.Companion.createWorkRequest(this.constraints, directory, this.flushDelayMs, string));
    }

    public final synchronized void queue(@NotNull Beacon beacon) {
        Intrinsics.checkParameterIsNotNull((Object)beacon, (String)"beacon");
        String beaconId = beacon.getBeaconId();
        Logger.d("Queueing beacon with: `beaconId` " + beaconId);
        if (!this.isInitialDelayComplete) {
            this.initialDelayQueue.add(beacon);
        } else {
            CharSequence charSequence = beaconId;
            boolean bl = false;
            boolean bl2 = false;
            if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
                Logger.e("Tried to queue beacon with no beaconId: " + beacon);
            } else {
                BuildersKt.launch$default((CoroutineScope)((CoroutineScope)GlobalScope.INSTANCE), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, beaconId, beacon, null){
                    private CoroutineScope p$;
                    Object L$0;
                    int label;
                    final /* synthetic */ InstanaWorkManager this$0;
                    final /* synthetic */ String $beaconId;
                    final /* synthetic */ Beacon $beacon;

                    /*
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    @Nullable
                    public final Object invokeSuspend(@NotNull Object $result) {
                        Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)$result);
                                CoroutineScope $this$launch = this.p$;
                                this.L$0 = $this$launch;
                                this.label = 1;
                                Object object2 = BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
                                    private CoroutineScope p$;
                                    int label;
                                    final /* synthetic */ queue.1 this$0;

                                    @Nullable
                                    public final Object invokeSuspend(@NotNull Object $result) {
                                        Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                        switch (this.label) {
                                            case 0: {
                                                Unit unit;
                                                ResultKt.throwOnFailure((Object)$result);
                                                CoroutineScope $this$withContext = this.p$;
                                                File file = new File(InstanaWorkManager.access$getBeaconsDirectory(this.this$0.this$0), this.this$0.$beaconId);
                                                FilesKt.writeText((File)file, (String)this.this$0.$beacon.toString(), (Charset)Charsets.UTF_8);
                                                WorkManager workManager = this.this$0.this$0.getWorkManager$runtime_release();
                                                if (workManager != null) {
                                                    WorkManager workManager2 = workManager;
                                                    boolean bl = false;
                                                    boolean bl2 = false;
                                                    WorkManager $this$run = workManager2;
                                                    boolean bl3 = false;
                                                    InstanaWorkManager.access$flush(this.this$0.this$0, InstanaWorkManager.access$getBeaconsDirectory(this.this$0.this$0), $this$run);
                                                    unit = Unit.INSTANCE;
                                                } else {
                                                    unit = null;
                                                }
                                                return unit;
                                            }
                                        }
                                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                    }
                                    {
                                        this.this$0 = var1_1;
                                        super(2, continuation);
                                    }

                                    @NotNull
                                    public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> completion) {
                                        Intrinsics.checkParameterIsNotNull(completion, (String)"completion");
                                        Function2<CoroutineScope, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                                        CoroutineScope coroutineScope = function2.p$ = (CoroutineScope)value;
                                        return function2;
                                    }

                                    public final Object invoke(Object object, Object object2) {
                                        return (this.create(object, (Continuation)object2)).invokeSuspend(Unit.INSTANCE);
                                    }
                                }), (Continuation)this);
                                if (object2 != object) return Unit.INSTANCE;
                                return object;
                            }
                            case 1: {
                                CoroutineScope $this$launch = (CoroutineScope)this.L$0;
                                ResultKt.throwOnFailure((Object)$result);
                                Object object2 = $result;
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }
                    {
                        this.this$0 = instanaWorkManager;
                        this.$beaconId = string;
                        this.$beacon = beacon;
                        super(2, continuation);
                    }

                    @NotNull
                    public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> completion) {
                        Intrinsics.checkParameterIsNotNull(completion, (String)"completion");
                        Function2<CoroutineScope, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                        CoroutineScope coroutineScope = function2.p$ = (CoroutineScope)value;
                        return function2;
                    }

                    public final Object invoke(Object object, Object object2) {
                        return (this.create(object, (Continuation)object2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (int)3, null);
            }
        }
    }

    public InstanaWorkManager(@NotNull InstanaConfig config, @NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)config, (String)"config");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        this.context = context;
        this.beaconsDirectoryName = "instanaBeacons";
        this.flushDelayMs = 1000L;
        this.initialDelayQueue = new LinkedBlockingDeque();
        this.checkConfigurationParameters(config);
        this.constraints = this.configureWorkManager(config);
        Executors.newScheduledThreadPool(1).schedule(new Runnable(){

            @Override
            public final void run() {
                block1: {
                    isInitialDelayComplete = true;
                    this.updateQueueItems(initialDelayQueue);
                    Iterable $this$forEach$iv = initialDelayQueue;
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        Beacon it = (Beacon)element$iv;
                        boolean bl = false;
                        Beacon beacon = it;
                        Intrinsics.checkExpressionValueIsNotNull((Object)beacon, (String)"it");
                        this.queue(beacon);
                    }
                    WorkManager workManager = this.getWorkManager$runtime_release();
                    if (workManager == null) break block1;
                    WorkManager workManager2 = workManager;
                    boolean bl = false;
                    boolean bl2 = false;
                    WorkManager $this$run = workManager2;
                    boolean bl3 = false;
                    this.flush(this.getBeaconsDirectory(), $this$run);
                }
            }
        }, config.getInitialBeaconDelayMs(), TimeUnit.MILLISECONDS);
    }

    public static final /* synthetic */ boolean access$isInitialDelayComplete$p(InstanaWorkManager $this) {
        return $this.isInitialDelayComplete;
    }

    public static final /* synthetic */ void access$setInitialDelayQueue$p(InstanaWorkManager $this, Queue queue2) {
        $this.initialDelayQueue = queue2;
    }
}

