/*
 * Decompiled with CFR 0.152.
 */
package com.instana.android.core.event.worker;

import android.content.Context;
import androidx.work.Constraints;
import androidx.work.CoroutineWorker;
import androidx.work.Data;
import androidx.work.ListenableWorker;
import androidx.work.OneTimeWorkRequest;
import androidx.work.WorkRequest;
import androidx.work.WorkerParameters;
import com.instana.android.Instana;
import com.instana.android.core.InstanaConfig;
import com.instana.android.core.util.ConstantsAndUtil;
import com.instana.android.core.util.Logger;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.coroutines.Continuation;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0016\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0011\u0010\u0007\u001a\u00020\bH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\tJ*\u0010\n\u001a\u0014\u0012\u0004\u0012\u00020\f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\r0\u000b2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\fH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u0016"}, d2={"Lcom/instana/android/core/event/worker/EventWorker;", "Landroidx/work/CoroutineWorker;", "context", "Landroid/content/Context;", "params", "Landroidx/work/WorkerParameters;", "(Landroid/content/Context;Landroidx/work/WorkerParameters;)V", "doWork", "Landroidx/work/ListenableWorker$Result;", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "readAllFiles", "Lkotlin/Pair;", "", "", "Ljava/io/File;", "directory", "limit", "", "send", "", "data", "Companion", "runtime_release"})
public class EventWorker
extends CoroutineWorker {
    private final WorkerParameters params;
    private static final int batchLimit = 100;
    private static final MediaType TEXT_PLAIN;
    private static final String DIRECTORY_ABS_PATH = "dir_abs_path";
    public static final Companion Companion;

    @Nullable
    public Object doWork(@NotNull Continuation<? super ListenableWorker.Result> $completion) {
        return EventWorker.doWork$suspendImpl(this, $completion);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ Object doWork$suspendImpl(EventWorker this_, Continuation $completion) {
        ListenableWorker.Result result;
        void data;
        String directoryAbsPath = this_.params.getInputData().getString(DIRECTORY_ABS_PATH);
        CharSequence charSequence = directoryAbsPath;
        boolean bl = false;
        boolean bl2 = false;
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
            Logger.e("Tried to flush beacons with invalid directory path: " + directoryAbsPath);
            ListenableWorker.Result result2 = ListenableWorker.Result.failure();
            Intrinsics.checkExpressionValueIsNotNull((Object)result2, (String)"Result.failure()");
            return result2;
        }
        File directory = new File(directoryAbsPath);
        Pair<String, File[]> pair = this_.readAllFiles(directory, 100);
        String string = (String)pair.component1();
        File[] files = (File[])pair.component2();
        if (StringsKt.isBlank((CharSequence)((CharSequence)data))) {
            ListenableWorker.Result result3 = ListenableWorker.Result.success();
            result = result3;
            Intrinsics.checkExpressionValueIsNotNull((Object)result3, (String)"Result.success()");
        } else if (this_.send((String)data)) {
            ListenableWorker.Result result4;
            File[] $this$forEach$iv = files;
            boolean $i$f$forEach = false;
            File[] fileArray = $this$forEach$iv;
            int n = fileArray.length;
            for (int i = 0; i < n; ++i) {
                File element$iv;
                File it = element$iv = fileArray[i];
                boolean bl3 = false;
                it.delete();
            }
            if (files.length == 100) {
                Logger.i("Beacon-batch reached limit. Will create a new batch");
                result4 = ListenableWorker.Result.retry();
            } else {
                Logger.i("Beacon-batch sent with: `size` " + files.length);
                result4 = ListenableWorker.Result.success();
            }
            result = result4;
            Intrinsics.checkExpressionValueIsNotNull((Object)result4, (String)"if (files.size == batchL\u2026ccess()\n                }");
        } else {
            ListenableWorker.Result result5 = ListenableWorker.Result.retry();
            result = result5;
            Intrinsics.checkExpressionValueIsNotNull((Object)result5, (String)"Result.retry()");
        }
        return result;
    }

    private final Pair<String, File[]> readAllFiles(File directory, int limit) {
        Object[] objectArray = directory.listFiles();
        if (objectArray == null) {
            objectArray = new File[]{};
        }
        Object[] files = objectArray;
        StringBuffer sb = new StringBuffer();
        Iterable $this$forEach$iv = ArraysKt.take((Object[])files, (int)limit);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            File it = (File)element$iv;
            boolean bl = false;
            StringBuilder stringBuilder = new StringBuilder();
            File file = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"it");
            sb.append(stringBuilder.append(FilesKt.readText((File)file, (Charset)Charsets.UTF_8)).append('\n').toString());
        }
        return TuplesKt.to((Object)sb.toString(), (Object)files);
    }

    private final boolean send(String data) {
        boolean bl;
        String reportingURL;
        InstanaConfig instanaConfig = Instana.getConfig();
        String string = reportingURL = instanaConfig != null ? instanaConfig.getReportingURL() : null;
        if (reportingURL == null) {
            Logger.w("Instana hasn't been initialized. Dropping beacon.");
            return true;
        }
        try {
            Request request = new Request.Builder().url(reportingURL).addHeader("Content-Type", "application/json").addHeader("Accept-Encoding", "gzip").post(RequestBody.Companion.create(data, TEXT_PLAIN)).build();
            Response response = ConstantsAndUtil.INSTANCE.getClient().newCall(request).execute();
            bl = response.isSuccessful();
        }
        catch (IOException e) {
            Logger.e("Failed to flush beacons to Instana", e);
            bl = false;
        }
        return bl;
    }

    public EventWorker(@NotNull Context context, @NotNull WorkerParameters params) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)params, (String)"params");
        super(context, params);
        this.params = params;
    }

    static {
        Companion = new Companion(null);
        TEXT_PLAIN = MediaType.Companion.parse("text/plain; charset=utf-8");
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J&\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/instana/android/core/event/worker/EventWorker$Companion;", "", "()V", "DIRECTORY_ABS_PATH", "", "TEXT_PLAIN", "Lokhttp3/MediaType;", "batchLimit", "", "createWorkRequest", "Landroidx/work/OneTimeWorkRequest;", "constraints", "Landroidx/work/Constraints;", "directory", "Ljava/io/File;", "initialDelayMs", "", "tag", "runtime_release"})
    public static final class Companion {
        @NotNull
        public final OneTimeWorkRequest createWorkRequest(@NotNull Constraints constraints, @NotNull File directory, long initialDelayMs, @NotNull String tag) {
            Intrinsics.checkParameterIsNotNull((Object)constraints, (String)"constraints");
            Intrinsics.checkParameterIsNotNull((Object)directory, (String)"directory");
            Intrinsics.checkParameterIsNotNull((Object)tag, (String)"tag");
            Data data = new Data.Builder().putString(EventWorker.DIRECTORY_ABS_PATH, directory.getAbsolutePath()).build();
            Intrinsics.checkExpressionValueIsNotNull((Object)data, (String)"Data.Builder()\n         \u2026\n                .build()");
            Data data2 = data;
            WorkRequest workRequest = ((OneTimeWorkRequest.Builder)((OneTimeWorkRequest.Builder)((OneTimeWorkRequest.Builder)new OneTimeWorkRequest.Builder(EventWorker.class).setInputData(data2)).setConstraints(constraints)).setInitialDelay(initialDelayMs, TimeUnit.MILLISECONDS).addTag(tag)).build();
            Intrinsics.checkExpressionValueIsNotNull((Object)workRequest, (String)"OneTimeWorkRequest.Build\u2026\n                .build()");
            return (OneTimeWorkRequest)workRequest;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

