/*
 * Decompiled with CFR 0.152.
 */
package com.instana.android.core.util;

import android.app.Application;
import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.net.ConnectivityManager;
import android.net.Network;
import android.net.NetworkCapabilities;
import android.net.NetworkInfo;
import android.os.Build;
import android.telephony.TelephonyManager;
import android.util.DisplayMetrics;
import android.view.Display;
import android.view.WindowManager;
import androidx.annotation.RestrictTo;
import androidx.core.app.ActivityCompat;
import com.instana.android.Instana;
import com.instana.android.core.InstanaConfig;
import com.instana.android.core.event.models.ConnectionType;
import com.instana.android.core.event.models.EffectiveConnectionType;
import com.instana.android.core.event.models.Platform;
import com.instana.android.core.util.ConstantsAndUtil;
import com.instana.android.core.util.ConstantsAndUtil$WhenMappings;
import com.instana.android.core.util.Logger;
import com.instana.android.core.util.StringExtensionsKt;
import com.instana.android.instrumentation.HTTPCaptureConfig;
import com.instana.android.instrumentation.InstrumentationService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import okhttp3.OkHttpClient;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0016\u001a\u00020\u000e2\b\u0010\u0017\u001a\u0004\u0018\u00010\u0004H\u0007J\u001a\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u00192\u0006\u0010\u001a\u001a\u00020\u001bJ\u0018\u0010\u001c\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 J \u0010!\u001a\u0004\u0018\u00010\"2\u0006\u0010#\u001a\u00020$2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 J\u0010\u0010%\u001a\u0004\u0018\u00010&2\u0006\u0010\u001d\u001a\u00020\u001eJ\u0006\u0010'\u001a\u00020\u0004J\u001e\u0010(\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010)\u0012\u0006\u0012\u0004\u0018\u00010)0\u00192\u0006\u0010\u001a\u001a\u00020\u001bJ\u0012\u0010*\u001a\u00020\u000e2\b\u0010\u0017\u001a\u0004\u0018\u00010\u0004H\u0007J\u0010\u0010+\u001a\u00020\u000e2\u0006\u0010,\u001a\u00020\u0004H\u0007J\u0012\u0010-\u001a\u00020\u000e2\b\u0010,\u001a\u0004\u0018\u00010\u0004H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0007\u001a\u00020\b8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000b\u0010\f\u001a\u0004\b\t\u0010\nR\u001a\u0010\r\u001a\u00020\u000e8FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\u000f\u0010\u0002\u001a\u0004\b\r\u0010\u0010R\u001b\u0010\u0011\u001a\u00020\u00128FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0015\u0010\f\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006."}, d2={"Lcom/instana/android/core/util/ConstantsAndUtil;", "", "()V", "EMPTY_STR", "", "OS_TYPE", "TRACKING_HEADER_KEY", "client", "Lokhttp3/OkHttpClient;", "getClient", "()Lokhttp3/OkHttpClient;", "client$delegate", "Lkotlin/Lazy;", "isAutoEnabled", "", "isAutoEnabled$annotations", "()Z", "runtime", "Ljava/lang/Runtime;", "getRuntime", "()Ljava/lang/Runtime;", "runtime$delegate", "checkTag", "header", "getAppVersionNameAndVersionCode", "Lkotlin/Pair;", "app", "Landroid/app/Application;", "getCarrierName", "cm", "Landroid/net/ConnectivityManager;", "tm", "Landroid/telephony/TelephonyManager;", "getCellularConnectionType", "Lcom/instana/android/core/event/models/EffectiveConnectionType;", "context", "Landroid/content/Context;", "getConnectionType", "Lcom/instana/android/core/event/models/ConnectionType;", "getOsName", "getViewportWidthAndHeight", "", "hasTrackingHeader", "isBlacklistedURL", "url", "isNotLibraryCallBoolean", "runtime_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY})
public final class ConstantsAndUtil {
    static final /* synthetic */ KProperty[] $$delegatedProperties;
    @NotNull
    public static final String EMPTY_STR = "";
    @NotNull
    public static final String OS_TYPE = "android";
    @NotNull
    public static final String TRACKING_HEADER_KEY = "X-INSTANA-ANDROID";
    @NotNull
    private static final Lazy runtime$delegate;
    @NotNull
    private static final Lazy client$delegate;
    public static final ConstantsAndUtil INSTANCE;

    static {
        ConstantsAndUtil constantsAndUtil;
        $$delegatedProperties = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(ConstantsAndUtil.class), "runtime", "getRuntime()Ljava/lang/Runtime;")), (KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(ConstantsAndUtil.class), "client", "getClient()Lokhttp3/OkHttpClient;"))};
        INSTANCE = constantsAndUtil = new ConstantsAndUtil();
        runtime$delegate = LazyKt.lazy((Function0)runtime.2.INSTANCE);
        client$delegate = LazyKt.lazy((Function0)client.2.INSTANCE);
    }

    @NotNull
    public final Runtime getRuntime() {
        Lazy lazy = runtime$delegate;
        ConstantsAndUtil constantsAndUtil = this;
        KProperty kProperty = $$delegatedProperties[0];
        boolean bl = false;
        return (Runtime)lazy.getValue();
    }

    @NotNull
    public final OkHttpClient getClient() {
        Lazy lazy = client$delegate;
        ConstantsAndUtil constantsAndUtil = this;
        KProperty kProperty = $$delegatedProperties[1];
        boolean bl = false;
        return (OkHttpClient)lazy.getValue();
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public final String getOsName() {
        String string;
        if (Build.VERSION.SDK_INT >= 23) {
            String string2 = Build.VERSION.BASE_OS;
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"Build.VERSION.BASE_OS");
            CharSequence charSequence = string2;
            boolean bl = false;
            if (!StringsKt.isBlank((CharSequence)charSequence)) {
                String string3 = Build.VERSION.BASE_OS;
                string = string3;
                Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"Build.VERSION.BASE_OS");
                return string;
            }
        }
        string = Platform.ANDROID.getInternalType();
        return string;
    }

    @Nullable
    public final ConnectionType getConnectionType(@NotNull ConnectivityManager cm) {
        Intrinsics.checkParameterIsNotNull((Object)cm, (String)"cm");
        if (Build.VERSION.SDK_INT >= 23) {
            Network network = cm.getActiveNetwork();
            NetworkCapabilities capabilities = cm.getNetworkCapabilities(network);
            if (capabilities != null) {
                return capabilities.hasTransport(3) ? ConnectionType.WIRED : (capabilities.hasTransport(1) ? ConnectionType.WIFI : (capabilities.hasTransport(0) ? ConnectionType.CELLULAR : null));
            }
        } else {
            NetworkInfo activeNetwork = cm.getActiveNetworkInfo();
            if (activeNetwork != null) {
                ConnectionType connectionType;
                switch (activeNetwork.getType()) {
                    case 9: {
                        connectionType = ConnectionType.WIRED;
                        break;
                    }
                    case 1: {
                        connectionType = ConnectionType.WIFI;
                        break;
                    }
                    case 0: {
                        connectionType = ConnectionType.CELLULAR;
                        break;
                    }
                    default: {
                        connectionType = null;
                    }
                }
                return connectionType;
            }
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public final String getCarrierName(@NotNull ConnectivityManager cm, @NotNull TelephonyManager tm) {
        Intrinsics.checkParameterIsNotNull((Object)cm, (String)"cm");
        Intrinsics.checkParameterIsNotNull((Object)tm, (String)"tm");
        ConnectionType connectionType = this.getConnectionType(cm);
        if (connectionType == null) return null;
        switch (ConstantsAndUtil$WhenMappings.$EnumSwitchMapping$0[connectionType.ordinal()]) {
            case 1: {
                String string = tm.getNetworkOperatorName();
                return string;
            }
            default: {
                return null;
            }
        }
    }

    @Nullable
    public final EffectiveConnectionType getCellularConnectionType(@NotNull Context context, @NotNull ConnectivityManager cm, @NotNull TelephonyManager tm) {
        EffectiveConnectionType effectiveConnectionType;
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)cm, (String)"cm");
        Intrinsics.checkParameterIsNotNull((Object)tm, (String)"tm");
        if (this.getConnectionType(cm) != ConnectionType.CELLULAR) {
            return null;
        }
        if (ActivityCompat.checkSelfPermission((Context)context, (String)"android.permission.READ_PHONE_STATE") != 0) {
            Logger.w("Missing permission 'READ_PHONE_STATE'. Instana Agent won't be able to detect cellular network type");
            return null;
        }
        int networkType = Build.VERSION.SDK_INT >= 24 ? tm.getDataNetworkType() : tm.getNetworkType();
        switch (networkType) {
            case 1: 
            case 2: 
            case 4: 
            case 7: 
            case 11: {
                effectiveConnectionType = EffectiveConnectionType.TYPE_2G;
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 14: 
            case 15: {
                effectiveConnectionType = EffectiveConnectionType.TYPE_3G;
                break;
            }
            case 13: {
                effectiveConnectionType = EffectiveConnectionType.TYPE_4G;
                break;
            }
            default: {
                effectiveConnectionType = null;
            }
        }
        return effectiveConnectionType;
    }

    @NotNull
    public final Pair<String, String> getAppVersionNameAndVersionCode(@NotNull Application app) {
        Intrinsics.checkParameterIsNotNull((Object)app, (String)"app");
        String versionCode = null;
        String version = null;
        try {
            String string;
            PackageInfo packageInfo = app.getPackageManager().getPackageInfo(app.getPackageName(), 0);
            version = packageInfo.versionName;
            if (Build.VERSION.SDK_INT >= 28) {
                PackageInfo packageInfo2 = packageInfo;
                Intrinsics.checkExpressionValueIsNotNull((Object)packageInfo2, (String)"packageInfo");
                string = String.valueOf(packageInfo2.getLongVersionCode());
            } else {
                string = String.valueOf(packageInfo.versionCode);
            }
            versionCode = string;
        }
        catch (PackageManager.NameNotFoundException e) {
            Logger.e("Failed to detect app versionName and versionCode", e);
            return new Pair((Object)EMPTY_STR, (Object)EMPTY_STR);
        }
        String string = version;
        if (string == null) {
            string = EMPTY_STR;
        }
        return new Pair((Object)string, (Object)versionCode);
    }

    @NotNull
    public final Pair<Integer, Integer> getViewportWidthAndHeight(@NotNull Application app) {
        Pair pair;
        Display display;
        Intrinsics.checkParameterIsNotNull((Object)app, (String)"app");
        Object object = app.getSystemService("window");
        if (!(object instanceof WindowManager)) {
            object = null;
        }
        WindowManager windowManager = (WindowManager)object;
        Object object2 = display = windowManager != null ? windowManager.getDefaultDisplay() : null;
        if (Build.VERSION.SDK_INT >= 17) {
            DisplayMetrics displayMetrics = new DisplayMetrics();
            Display display2 = display;
            if (display2 != null) {
                display2.getRealMetrics(displayMetrics);
            }
            pair = TuplesKt.to((Object)displayMetrics.widthPixels, (Object)displayMetrics.heightPixels);
        } else {
            Display display3 = display;
            Display display4 = display;
            pair = TuplesKt.to((Object)(display3 != null ? Integer.valueOf(display3.getWidth()) : null), (Object)(display4 != null ? Integer.valueOf(display4.getHeight()) : null));
        }
        return pair;
    }

    @JvmStatic
    public static final boolean hasTrackingHeader(@Nullable String header) {
        return header != null;
    }

    @JvmStatic
    public static final boolean checkTag(@Nullable String header) {
        boolean bl;
        if (header != null) {
            InstrumentationService instrumentationService = Instana.INSTANCE.getInstrumentationService$runtime_release();
            bl = instrumentationService != null ? instrumentationService.hasTag(header) : false;
        } else {
            bl = false;
        }
        return bl;
    }

    @JvmStatic
    public static final boolean isNotLibraryCallBoolean(@Nullable String url) {
        Object object;
        return url == null ? false : !StringsKt.contains$default((CharSequence)url, (CharSequence)((object = Instana.getConfig()) != null && (object = ((InstanaConfig)object).getReportingURL()) != null ? (CharSequence)object : (CharSequence)EMPTY_STR), (boolean)false, (int)2, null);
    }

    @JvmStatic
    public static /* synthetic */ void isAutoEnabled$annotations() {
    }

    public static final boolean isAutoEnabled() {
        InstanaConfig instanaConfig = Instana.getConfig();
        return (instanaConfig != null ? instanaConfig.getHttpCaptureConfig() : null) == HTTPCaptureConfig.AUTO;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @JvmStatic
    public static final boolean isBlacklistedURL(@NotNull String url) {
        boolean bl;
        void $this$mapTo$iv$iv;
        boolean bl2;
        Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
        Iterable $this$any$iv = Instana.INSTANCE.getInternalURLs$runtime_release();
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            bl2 = false;
        } else {
            for (Object element$iv : $this$any$iv) {
                Regex it = (Regex)element$iv;
                boolean bl3 = false;
                if (!it.matches((CharSequence)url)) continue;
                return true;
            }
            bl2 = false;
        }
        if (bl2) return true;
        Iterable $this$map$iv = Instana.getIgnoreURLs();
        boolean $i$f$map = false;
        Iterator iterator = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Pattern pattern = (Pattern)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl4 = false;
            void var10_14 = it;
            boolean bl5 = false;
            Regex regex = new Regex((Pattern)var10_14);
            collection.add(regex);
        }
        $this$any$iv = (List)destination$iv$iv;
        $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        iterator = $this$any$iv.iterator();
        do {
            Object element$iv;
            if (!iterator.hasNext()) return false;
            element$iv = iterator.next();
            Regex it = (Regex)element$iv;
            boolean bl6 = false;
            if (it.matches((CharSequence)url)) return true;
            if (it.matches((CharSequence)StringExtensionsKt.removeTrailing(url, "/"))) {
                return true;
            }
            bl = false;
        } while (!bl);
        return true;
    }

    private ConstantsAndUtil() {
    }
}

