/*
 * Decompiled with CFR 0.152.
 */
package com.instana.android.instrumentation;

import android.content.Context;
import com.instana.android.Instana;
import com.instana.android.core.InstanaConfig;
import com.instana.android.core.InstanaWorkManager;
import com.instana.android.core.event.models.Beacon;
import com.instana.android.core.event.models.ConnectionProfile;
import com.instana.android.core.event.models.ConnectionType;
import com.instana.android.core.event.models.EffectiveConnectionType;
import com.instana.android.core.util.ConstantsAndUtil;
import com.instana.android.core.util.HttpURLConnectionExtensionsKt;
import com.instana.android.core.util.Logger;
import com.instana.android.core.util.OkHttp3ExtensionsKt;
import com.instana.android.core.util.StopWatch;
import com.instana.android.instrumentation.HTTPCaptureConfig;
import com.instana.android.instrumentation.InstrumentationService;
import java.net.HttpURLConnection;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 !2\u00020\u0001:\u0001!B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u0006\u0010\u0013\u001a\u00020\u0014J\u000e\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u0017J\u0016\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019J\u0016\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0018\u001a\u00020\u0019J\u000e\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u001c\u001a\u00020\u001dJ\u0012\u0010\u001e\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0012\u0010\u001e\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0006\u0010\u001f\u001a\u00020\u0003J\u0006\u0010 \u001a\u00020\u0003R\u0010\u0010\f\u001a\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/instana/android/instrumentation/HTTPMarker;", "", "url", "", "viewName", "context", "Landroid/content/Context;", "manager", "Lcom/instana/android/core/InstanaWorkManager;", "config", "Lcom/instana/android/core/InstanaConfig;", "(Ljava/lang/String;Ljava/lang/String;Landroid/content/Context;Lcom/instana/android/core/InstanaWorkManager;Lcom/instana/android/core/InstanaConfig;)V", "carrierName", "connectionProfile", "Lcom/instana/android/core/event/models/ConnectionProfile;", "markerId", "sessionId", "stopWatch", "Lcom/instana/android/core/util/StopWatch;", "cancel", "", "finish", "connection", "Ljava/net/HttpURLConnection;", "error", "", "request", "Lokhttp3/Request;", "response", "Lokhttp3/Response;", "getBackendTraceId", "headerKey", "headerValue", "Companion", "runtime_release"})
public final class HTTPMarker {
    private final StopWatch stopWatch;
    private final String markerId;
    private String carrierName;
    private ConnectionProfile connectionProfile;
    private final String sessionId;
    private final String url;
    private final String viewName;
    private final Context context;
    private final InstanaWorkManager manager;
    private final InstanaConfig config;
    private static final String backendTraceIdHeaderKey = "Server-Timing";
    private static final Regex backendTraceIdParser;
    public static final Companion Companion;

    @NotNull
    public final String headerKey() {
        return "X-INSTANA-ANDROID";
    }

    @NotNull
    public final String headerValue() {
        return this.markerId;
    }

    public final void cancel() {
        String errorMessage;
        this.stopWatch.stop();
        InstrumentationService instrumentationService = Instana.INSTANCE.getInstrumentationService$runtime_release();
        if (instrumentationService != null) {
            instrumentationService.removeTag(this.markerId);
        }
        if (this.sessionId == null) {
            Logger.e("Tried to end HTTPMarker with null sessionId");
            return;
        }
        String string = errorMessage = "Cancelled request";
        String string2 = null;
        Long l = null;
        Long l2 = null;
        Long l3 = null;
        Integer n = null;
        Beacon beacon = Beacon.Companion.newHttpRequest(this.config.getKey(), Instana.INSTANCE.getAppProfile$runtime_release(), Instana.INSTANCE.getDeviceProfile$runtime_release(), this.connectionProfile, Instana.INSTANCE.getUserProfile$runtime_release(), this.sessionId, this.viewName, Instana.getMeta().getAll(), this.stopWatch.getTotalTimeMillis(), null, this.url, string2, n, l3, l2, l, string);
        if (this.config.getHttpCaptureConfig() != HTTPCaptureConfig.NONE) {
            Logger.i("HttpRequest cancelled with: `url` " + this.url);
            this.manager.queue(beacon);
        }
    }

    public final void finish(@NotNull Response response) {
        Intrinsics.checkParameterIsNotNull((Object)response, (String)"response");
        this.stopWatch.stop();
        InstrumentationService instrumentationService = Instana.INSTANCE.getInstrumentationService$runtime_release();
        if (instrumentationService != null) {
            instrumentationService.removeTag(this.markerId);
        }
        if (this.sessionId == null) {
            Logger.e("Tried to end HTTPMarker with null sessionId");
            return;
        }
        String method = response.request().method();
        RequestBody requestBody = response.request().body();
        Long requestSize = requestBody != null ? Long.valueOf(requestBody.contentLength()) : null;
        ResponseBody responseBody = response.body();
        Long encodedResponseSize = responseBody != null ? Long.valueOf(responseBody.contentLength()) : null;
        Long decodedResponseSize = OkHttp3ExtensionsKt.decodedContentLength(response);
        String string = null;
        String string2 = this.getBackendTraceId(response);
        Long l = decodedResponseSize;
        Long l2 = encodedResponseSize;
        Long l3 = requestSize;
        Integer n = response.code();
        Beacon beacon = Beacon.Companion.newHttpRequest(this.config.getKey(), Instana.INSTANCE.getAppProfile$runtime_release(), Instana.INSTANCE.getDeviceProfile$runtime_release(), this.connectionProfile, Instana.INSTANCE.getUserProfile$runtime_release(), this.sessionId, this.viewName, Instana.getMeta().getAll(), this.stopWatch.getTotalTimeMillis(), method, this.url, string2, n, l3, l2, l, string);
        if (this.config.getHttpCaptureConfig() != HTTPCaptureConfig.NONE) {
            Logger.i("HttpRequest finished with: `url` " + this.url);
            this.manager.queue(beacon);
        }
    }

    public final void finish(@NotNull Request request, @NotNull Throwable error) {
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        Intrinsics.checkParameterIsNotNull((Object)error, (String)"error");
        this.stopWatch.stop();
        InstrumentationService instrumentationService = Instana.INSTANCE.getInstrumentationService$runtime_release();
        if (instrumentationService != null) {
            instrumentationService.removeTag(this.markerId);
        }
        if (this.sessionId == null) {
            Logger.e("Tried to end HTTPMarker with null sessionId");
            return;
        }
        String method = request.method();
        RequestBody requestBody = request.body();
        Long requestSize = requestBody != null ? Long.valueOf(requestBody.contentLength()) : null;
        String string = error.toString();
        String string2 = null;
        Long l = null;
        Long l2 = null;
        Long l3 = requestSize;
        Integer n = null;
        Beacon beacon = Beacon.Companion.newHttpRequest(this.config.getKey(), Instana.INSTANCE.getAppProfile$runtime_release(), Instana.INSTANCE.getDeviceProfile$runtime_release(), this.connectionProfile, Instana.INSTANCE.getUserProfile$runtime_release(), this.sessionId, this.viewName, Instana.getMeta().getAll(), this.stopWatch.getTotalTimeMillis(), method, this.url, string2, n, l3, l2, l, string);
        if (this.config.getHttpCaptureConfig() != HTTPCaptureConfig.NONE) {
            Logger.i("HttpRequest finished with: `url` " + this.url);
            this.manager.queue(beacon);
        }
    }

    public final void finish(@NotNull HttpURLConnection connection) {
        String errorMessage;
        Intrinsics.checkParameterIsNotNull((Object)connection, (String)"connection");
        this.stopWatch.stop();
        InstrumentationService instrumentationService = Instana.INSTANCE.getInstrumentationService$runtime_release();
        if (instrumentationService != null) {
            instrumentationService.removeTag(this.markerId);
        }
        if (this.sessionId == null) {
            Logger.e("Tried to end HTTPMarker with null sessionId");
            return;
        }
        String method = connection.getRequestMethod();
        Long encodedResponseSize = HttpURLConnectionExtensionsKt.encodedResponseSizeOrNull(connection);
        Integer n = HttpURLConnectionExtensionsKt.decodedResponseSizeOrNull(connection);
        Long decodedResponseSize = n != null ? Long.valueOf(n.intValue()) : null;
        Integer responseCode = HttpURLConnectionExtensionsKt.responseCodeOrNull(connection);
        String string = errorMessage = HttpURLConnectionExtensionsKt.errorMessageOrNull(connection);
        String string2 = this.getBackendTraceId(connection);
        Long l = decodedResponseSize;
        Long l2 = encodedResponseSize;
        Long l3 = null;
        Integer n2 = responseCode;
        Beacon beacon = Beacon.Companion.newHttpRequest(this.config.getKey(), Instana.INSTANCE.getAppProfile$runtime_release(), Instana.INSTANCE.getDeviceProfile$runtime_release(), this.connectionProfile, Instana.INSTANCE.getUserProfile$runtime_release(), this.sessionId, this.viewName, Instana.getMeta().getAll(), this.stopWatch.getTotalTimeMillis(), method, this.url, string2, n2, l3, l2, l, string);
        if (this.config.getHttpCaptureConfig() != HTTPCaptureConfig.NONE) {
            Logger.i("HttpRequest finished with: `url` " + this.url);
            this.manager.queue(beacon);
        }
    }

    public final void finish(@NotNull HttpURLConnection connection, @NotNull Throwable error) {
        String errorMessage;
        Intrinsics.checkParameterIsNotNull((Object)connection, (String)"connection");
        Intrinsics.checkParameterIsNotNull((Object)error, (String)"error");
        this.stopWatch.stop();
        InstrumentationService instrumentationService = Instana.INSTANCE.getInstrumentationService$runtime_release();
        if (instrumentationService != null) {
            instrumentationService.removeTag(this.markerId);
        }
        if (this.sessionId == null) {
            Logger.e("Tried to end HTTPMarker with null sessionId");
            return;
        }
        String method = connection.getRequestMethod();
        Integer responseCode = HttpURLConnectionExtensionsKt.responseCodeOrNull(connection);
        String string = errorMessage = error.getMessage();
        String string2 = this.getBackendTraceId(connection);
        Long l = null;
        Long l2 = null;
        Long l3 = null;
        Integer n = responseCode;
        Beacon beacon = Beacon.Companion.newHttpRequest(this.config.getKey(), Instana.INSTANCE.getAppProfile$runtime_release(), Instana.INSTANCE.getDeviceProfile$runtime_release(), this.connectionProfile, Instana.INSTANCE.getUserProfile$runtime_release(), this.sessionId, this.viewName, Instana.getMeta().getAll(), this.stopWatch.getTotalTimeMillis(), method, this.url, string2, n, l3, l2, l, string);
        if (this.config.getHttpCaptureConfig() != HTTPCaptureConfig.NONE) {
            Logger.i("HttpRequest finished with: `url` " + this.url);
            this.manager.queue(beacon);
        }
    }

    private final String getBackendTraceId(HttpURLConnection connection) {
        String string;
        String string2 = connection.getHeaderField(backendTraceIdHeaderKey);
        if (string2 != null) {
            String string3 = string2;
            boolean bl = false;
            boolean bl2 = false;
            String it = string3;
            boolean bl3 = false;
            Object object = backendTraceIdParser.matchEntire((CharSequence)it);
            string = object != null && (object = object.getGroupValues()) != null ? (String)object.get(1) : null;
        } else {
            string = null;
        }
        return string;
    }

    private final String getBackendTraceId(Response response) {
        String string;
        String string2 = Response.header$default((Response)response, (String)backendTraceIdHeaderKey, null, (int)2, null);
        if (string2 != null) {
            String string3 = string2;
            boolean bl = false;
            boolean bl2 = false;
            String it = string3;
            boolean bl3 = false;
            Object object = backendTraceIdParser.matchEntire((CharSequence)it);
            string = object != null && (object = object.getGroupValues()) != null ? (String)object.get(1) : null;
        } else {
            string = null;
        }
        return string;
    }

    public HTTPMarker(@NotNull String url, @Nullable String viewName, @NotNull Context context, @NotNull InstanaWorkManager manager, @NotNull InstanaConfig config) {
        block7: {
            EffectiveConnectionType effectiveConnectionType;
            ConnectionType connectionType;
            ConnectionType connectionType2;
            String string;
            String string2;
            InstrumentationService $this$run;
            boolean bl;
            boolean bl2;
            HTTPMarker hTTPMarker;
            InstrumentationService instrumentationService;
            Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            Intrinsics.checkParameterIsNotNull((Object)manager, (String)"manager");
            Intrinsics.checkParameterIsNotNull((Object)config, (String)"config");
            this.url = url;
            this.viewName = viewName;
            this.context = context;
            this.manager = manager;
            this.config = config;
            this.stopWatch = new StopWatch();
            String string3 = UUID.randomUUID().toString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"UUID.randomUUID().toString()");
            this.markerId = string3;
            this.stopWatch.start();
            this.sessionId = Instana.getSessionId();
            HTTPMarker hTTPMarker2 = this;
            InstrumentationService instrumentationService2 = Instana.INSTANCE.getInstrumentationService$runtime_release();
            if (instrumentationService2 != null) {
                instrumentationService = instrumentationService2;
                hTTPMarker = hTTPMarker2;
                bl2 = false;
                bl = false;
                $this$run = instrumentationService;
                boolean bl3 = false;
                string2 = ConstantsAndUtil.INSTANCE.getCarrierName($this$run.getConnectivityManager(), $this$run.getTelephonyManager());
                hTTPMarker2 = hTTPMarker;
                string = string2;
            } else {
                string = null;
            }
            InstrumentationService instrumentationService3 = Instana.INSTANCE.getInstrumentationService$runtime_release();
            if (instrumentationService3 != null) {
                instrumentationService = instrumentationService3;
                string2 = string;
                hTTPMarker = hTTPMarker2;
                bl2 = false;
                bl = false;
                $this$run = instrumentationService;
                boolean bl4 = false;
                connectionType2 = ConstantsAndUtil.INSTANCE.getConnectionType($this$run.getConnectivityManager());
                hTTPMarker2 = hTTPMarker;
                string = string2;
                connectionType = connectionType2;
            } else {
                connectionType = null;
            }
            InstrumentationService instrumentationService4 = Instana.INSTANCE.getInstrumentationService$runtime_release();
            if (instrumentationService4 != null) {
                instrumentationService = instrumentationService4;
                connectionType2 = connectionType;
                string2 = string;
                hTTPMarker = hTTPMarker2;
                bl2 = false;
                bl = false;
                $this$run = instrumentationService;
                boolean bl5 = false;
                EffectiveConnectionType effectiveConnectionType2 = ConstantsAndUtil.INSTANCE.getCellularConnectionType(this.context, $this$run.getConnectivityManager(), $this$run.getTelephonyManager());
                hTTPMarker2 = hTTPMarker;
                string = string2;
                connectionType = connectionType2;
                effectiveConnectionType = effectiveConnectionType2;
            } else {
                effectiveConnectionType = null;
            }
            EffectiveConnectionType effectiveConnectionType3 = effectiveConnectionType;
            ConnectionType connectionType3 = connectionType;
            String string4 = string;
            hTTPMarker2.connectionProfile = new ConnectionProfile(string4, connectionType3, effectiveConnectionType3);
            InstrumentationService instrumentationService5 = Instana.INSTANCE.getInstrumentationService$runtime_release();
            if (instrumentationService5 == null) break block7;
            instrumentationService = instrumentationService5;
            bl2 = false;
            bl = false;
            $this$run = instrumentationService;
            boolean bl6 = false;
            this.carrierName = $this$run.getTelephonyManager().getNetworkOperatorName();
            if (Intrinsics.areEqual((Object)this.carrierName, (Object)"")) {
                this.carrierName = null;
            }
            $this$run.addTag(this.markerId);
        }
    }

    static {
        Companion = new Companion(null);
        String string = "^.* ?intid;desc=([^,]+)?.*$";
        boolean bl = false;
        backendTraceIdParser = new Regex(string);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/instana/android/instrumentation/HTTPMarker$Companion;", "", "()V", "backendTraceIdHeaderKey", "", "backendTraceIdParser", "Lkotlin/text/Regex;", "runtime_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

