/*
 * Decompiled with CFR 0.152.
 */
package com.instana.android.instrumentation.aspects;

import com.instana.android.Instana;
import com.instana.android.core.util.ConstantsAndUtil;
import com.instana.android.core.util.Logger;
import com.instana.android.instrumentation.HTTPMarker;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.ProtocolException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.NoAspectBoundException;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.AfterThrowing;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;

@Aspect
public class UrlConnectionAspect {
    private final Map<String, HTTPMarker> httpMarkers = new ConcurrentHashMap<String, HTTPMarker>();
    private static /* synthetic */ Throwable ajc$initFailureCause;
    public static /* synthetic */ UrlConnectionAspect ajc$perSingletonInstance;

    static {
        try {
            UrlConnectionAspect.ajc$perSingletonInstance = new UrlConnectionAspect();
        }
        catch (Throwable throwable) {
            ajc$initFailureCause = throwable;
        }
    }

    @Pointcut(value="call(* java.net.URL.openConnection())", argNames="")
    /* synthetic */ void ajc$pointcut$$openConnectionMethodCall$250() {
    }

    @AfterReturning(pointcut="openConnectionMethodCall()", returning="connection", argNames="connection")
    public void ajc$afterReturning$com_instana_android_instrumentation_aspects_UrlConnectionAspect$1$e6574508(HttpURLConnection connection) {
        Logger.i("HttpURLConnection: intercepting openConnection");
        String header = connection.getRequestProperty("X-INSTANA-ANDROID");
        String url = connection.getURL().toString();
        if (ConstantsAndUtil.isAutoEnabled() && !ConstantsAndUtil.checkTag(header) && ConstantsAndUtil.isNotLibraryCallBoolean(url) && !ConstantsAndUtil.isBlacklistedURL(url)) {
            HTTPMarker marker = Instana.startCapture(url);
            connection.setRequestProperty(marker.headerKey(), marker.headerValue());
            this.httpMarkers.put(marker.headerValue(), marker);
        }
    }

    @Pointcut(value="(target(connection) && call(* java.net.HttpURLConnection.disconnect()))", argNames="connection")
    /* synthetic */ void ajc$pointcut$$disconnectMethodCall$501(HttpURLConnection httpURLConnection) {
    }

    @Before(value="disconnectMethodCall(connection)", argNames="connection")
    public void ajc$before$com_instana_android_instrumentation_aspects_UrlConnectionAspect$2$6634abfe(HttpURLConnection connection) {
        HTTPMarker marker;
        Logger.i("HttpURLConnection: intercepting disconnect");
        String header = connection.getRequestProperty("X-INSTANA-ANDROID");
        String url = connection.getURL().toString();
        if (ConstantsAndUtil.isAutoEnabled() && ConstantsAndUtil.isNotLibraryCallBoolean(url) && ConstantsAndUtil.checkTag(header) && (marker = this.httpMarkers.get(header)) != null) {
            marker.finish(connection);
            this.httpMarkers.remove(header);
        }
    }

    @Pointcut(value="call(* java.net.HttpURLConnection.getOutputStream())", argNames="")
    /* synthetic */ void ajc$pointcut$$outputStream$7bb() {
    }

    @AfterThrowing(pointcut="outputStream()", throwing="e", argNames="e")
    public void ajc$afterThrowing$com_instana_android_instrumentation_aspects_UrlConnectionAspect$3$d4c660a2(IOException e, JoinPoint thisJoinPoint) {
        this.handleException(thisJoinPoint, e);
    }

    @Pointcut(value="call(* java.net.HttpURLConnection.getInputStream())", argNames="")
    /* synthetic */ void ajc$pointcut$$inputStream$876() {
    }

    @AfterThrowing(pointcut="inputStream()", throwing="e", argNames="e")
    public void ajc$afterThrowing$com_instana_android_instrumentation_aspects_UrlConnectionAspect$4$894dc66b(IOException e, JoinPoint thisJoinPoint) {
        this.handleException(thisJoinPoint, e);
    }

    @Pointcut(value="call(* java.net.HttpURLConnection.setRequestMethod(..))", argNames="")
    /* synthetic */ void ajc$pointcut$$setRequestMethod$92e() {
    }

    @AfterThrowing(pointcut="setRequestMethod()", throwing="e", argNames="e")
    public void ajc$afterThrowing$com_instana_android_instrumentation_aspects_UrlConnectionAspect$5$9b1ee48f(ProtocolException e, JoinPoint thisJoinPoint) {
        this.handleException(thisJoinPoint, e);
    }

    @Pointcut(value="call(* java.net.HttpURLConnection.connect())", argNames="")
    /* synthetic */ void ajc$pointcut$$connect$9fa() {
    }

    @AfterThrowing(pointcut="connect()", throwing="e", argNames="e")
    public void ajc$afterThrowing$com_instana_android_instrumentation_aspects_UrlConnectionAspect$6$dd79eb6b(IOException e, JoinPoint thisJoinPoint) {
        this.handleException(thisJoinPoint, e);
    }

    private void handleException(JoinPoint joinPoint, Throwable e) {
        Logger.i("HttpURLConnection: handling exception");
        if (joinPoint.getTarget() instanceof HttpURLConnection) {
            HTTPMarker marker;
            HttpURLConnection urlConnection = (HttpURLConnection)joinPoint.getTarget();
            String header = urlConnection.getRequestProperty("X-INSTANA-ANDROID");
            String url = urlConnection.getURL().toString();
            if (ConstantsAndUtil.isAutoEnabled() && ConstantsAndUtil.hasTrackingHeader(header) && ConstantsAndUtil.isNotLibraryCallBoolean(url) && ConstantsAndUtil.checkTag(header) && (marker = this.httpMarkers.get(header)) != null) {
                marker.finish(urlConnection, e);
                this.httpMarkers.remove(header);
            }
        }
    }

    public static UrlConnectionAspect aspectOf() {
        if (ajc$perSingletonInstance == null) {
            throw new NoAspectBoundException("com_instana_android_instrumentation_aspects_UrlConnectionAspect", ajc$initFailureCause);
        }
        return ajc$perSingletonInstance;
    }

    public static boolean hasAspect() {
        return ajc$perSingletonInstance != null;
    }
}

