/*
 * Decompiled with CFR 0.152.
 */
package com.instana.android.performance.anr;

import com.instana.android.core.util.Logger;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00060\u0001j\u0002`\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0006\u0010\u0006\u001a\u00020\u0007J\u0010\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\nH\u0002J3\u0010\u000b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0003\u001a\u00020\u00042\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0002\u00a2\u0006\u0002\u0010\u0011\u00a8\u0006\u0012"}, d2={"Lcom/instana/android/performance/anr/AnrException;", "Ljava/lang/Exception;", "Lkotlin/Exception;", "thread", "Ljava/lang/Thread;", "(Ljava/lang/Thread;)V", "logProcessMap", "", "printProcessMap", "ps", "Ljava/io/PrintStream;", "printThread", "l", "Ljava/util/Locale;", "stack", "", "Ljava/lang/StackTraceElement;", "(Ljava/io/PrintStream;Ljava/util/Locale;Ljava/lang/Thread;[Ljava/lang/StackTraceElement;)V", "runtime_release"})
public final class AnrException
extends Exception {
    public final void logProcessMap() {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(bos);
        this.printProcessMap(ps);
        byte[] byArray = bos.toByteArray();
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"bos.toByteArray()");
        byte[] byArray2 = byArray;
        boolean bl = false;
        Logger.i(new String(byArray2, Charsets.UTF_8));
    }

    private final void printProcessMap(PrintStream ps) {
        Map<Thread, StackTraceElement[]> stackTraces = Thread.getAllStackTraces();
        ps.println("Process map:");
        for (Thread thread : stackTraces.keySet()) {
            StackTraceElement[] stackTraceElementArray;
            if (stackTraces.get(thread) == null) continue;
            boolean bl = false;
            StackTraceElement[] stackTraceElementArray2 = stackTraceElementArray;
            boolean bl2 = false;
            if (!(!(stackTraceElementArray2.length == 0))) continue;
            Locale locale = Locale.getDefault();
            Intrinsics.checkExpressionValueIsNotNull((Object)locale, (String)"Locale.getDefault()");
            Thread thread2 = thread;
            Intrinsics.checkExpressionValueIsNotNull((Object)thread2, (String)"thread");
            StackTraceElement[] stackTraceElementArray3 = stackTraces.get(thread);
            if (stackTraceElementArray3 == null) {
                Intrinsics.throwNpe();
            }
            this.printThread(ps, locale, thread2, stackTraceElementArray3);
            ps.println();
        }
    }

    private final void printThread(PrintStream ps, Locale l, Thread thread, StackTraceElement[] stack) {
        StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
        String string = "\t%s (%s)";
        Object[] objectArray = new Object[]{thread.getName(), thread.getState()};
        PrintStream printStream = ps;
        int n = 0;
        String string2 = String.format(l, string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"java.lang.String.format(locale, format, *args)");
        String string3 = string2;
        printStream.println(string3);
        for (StackTraceElement element : stack) {
            StringCompanionObject stringCompanionObject2 = StringCompanionObject.INSTANCE;
            String string4 = "\t\t%s.%s(%s:%d)";
            Object[] objectArray2 = new Object[]{element.getClassName(), element.getMethodName(), element.getFileName(), element.getLineNumber()};
            printStream = ps;
            boolean bl = false;
            Intrinsics.checkExpressionValueIsNotNull((Object)String.format(l, string4, Arrays.copyOf(objectArray2, objectArray2.length)), (String)"java.lang.String.format(locale, format, *args)");
            printStream.println(string3);
        }
    }

    public AnrException(@NotNull Thread thread) {
        Intrinsics.checkParameterIsNotNull((Object)thread, (String)"thread");
        super("ANR detected");
        this.setStackTrace(thread.getStackTrace());
    }
}

