/*
 * Decompiled with CFR 0.152.
 */
package com.instana.android.performance.anr;

import android.os.Handler;
import android.os.Looper;
import com.instana.android.core.util.Logger;
import com.instana.android.performance.PerformanceMonitorConfig;
import com.instana.android.performance.anr.AnrException;
import com.instana.android.performance.anr.AnrSupervisor;
import com.instana.android.performance.anr.AnrSupervisorCallback;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0005\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\u0017\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0012\u001a\u00020\u0013H\u0002J\b\u0010\u0014\u001a\u00020\u0013H\u0016J\u0006\u0010\u0015\u001a\u00020\u0013J\u0006\u0010\u0016\u001a\u00020\u0013R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u000e\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\r8F@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0010\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\tR\u000e\u0010\u0011\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/instana/android/performance/anr/AnrSupervisorRunnable;", "Ljava/lang/Runnable;", "performanceMonitorConfig", "Lcom/instana/android/performance/PerformanceMonitorConfig;", "anrCallback", "Lcom/instana/android/performance/anr/AnrSupervisor$AnrCallback;", "(Lcom/instana/android/performance/PerformanceMonitorConfig;Lcom/instana/android/performance/anr/AnrSupervisor$AnrCallback;)V", "duration", "", "Ljava/lang/Long;", "handler", "Landroid/os/Handler;", "<set-?>", "", "isStopped", "()Z", "startTime", "stopped", "checkStopped", "", "run", "stop", "unStop", "Companion", "runtime_release"})
public final class AnrSupervisorRunnable
implements Runnable {
    private final Handler handler;
    private boolean stopped;
    private boolean isStopped;
    private Long startTime;
    private Long duration;
    private final PerformanceMonitorConfig performanceMonitorConfig;
    private final AnrSupervisor.AnrCallback anrCallback;
    private static final long TEST_TIMEOUT = 5L;
    public static final Companion Companion = new Companion(null);

    public final synchronized boolean isStopped() {
        return this.isStopped;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.isStopped = false;
        while (!Thread.interrupted()) {
            try {
                AnrSupervisorCallback callback = new AnrSupervisorCallback();
                boolean bl = false;
                boolean bl2 = false;
                synchronized (callback) {
                    boolean bl3 = false;
                    this.handler.post((Runnable)callback);
                    ((Object)callback).wait(this.performanceMonitorConfig.getAnrThresholdMs());
                    if (!callback.isCalled$runtime_release()) {
                        this.startTime = System.currentTimeMillis();
                        callback.wait();
                    } else if (this.startTime != null) {
                        long l = System.currentTimeMillis();
                        Long l2 = this.startTime;
                        if (l2 == null) {
                            Intrinsics.throwNpe();
                        }
                        this.duration = l - l2;
                        Logger.i("UI Thread blocked for " + this.duration);
                        Looper looper = this.handler.getLooper();
                        Intrinsics.checkExpressionValueIsNotNull((Object)looper, (String)"this.handler.looper");
                        Thread thread = looper.getThread();
                        Intrinsics.checkExpressionValueIsNotNull((Object)thread, (String)"this.handler.looper.thread");
                        AnrException e = new AnrException(thread);
                        Long l3 = this.duration;
                        if (l3 == null) {
                            Intrinsics.throwNpe();
                        }
                        this.anrCallback.onAppNotResponding(e, l3);
                        this.startTime = null;
                    }
                    Unit unit = Unit.INSTANCE;
                }
                this.checkStopped();
                TimeUnit.SECONDS.sleep(5L);
            }
            catch (InterruptedException e) {
                Logger.e("Failed to run ANRSupervisor", e);
                break;
            }
        }
        this.isStopped = true;
    }

    private final synchronized void checkStopped() throws InterruptedException {
        if (this.stopped) {
            TimeUnit.SECONDS.sleep(1L);
            if (this.stopped) {
                throw (Throwable)new InterruptedException();
            }
        }
    }

    public final synchronized void stop() {
        this.stopped = true;
    }

    public final synchronized void unStop() {
        this.stopped = false;
    }

    public AnrSupervisorRunnable(@NotNull PerformanceMonitorConfig performanceMonitorConfig, @NotNull AnrSupervisor.AnrCallback anrCallback) {
        Intrinsics.checkParameterIsNotNull((Object)performanceMonitorConfig, (String)"performanceMonitorConfig");
        Intrinsics.checkParameterIsNotNull((Object)anrCallback, (String)"anrCallback");
        this.performanceMonitorConfig = performanceMonitorConfig;
        this.anrCallback = anrCallback;
        this.handler = new Handler(Looper.getMainLooper());
        this.isStopped = true;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/instana/android/performance/anr/AnrSupervisorRunnable$Companion;", "", "()V", "TEST_TIMEOUT", "", "runtime_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

