/*
 * Decompiled with CFR 0.152.
 */
package com.instana.android.session;

import android.content.Context;
import android.net.ConnectivityManager;
import android.telephony.TelephonyManager;
import androidx.annotation.RestrictTo;
import com.instana.android.Instana;
import com.instana.android.core.InstanaConfig;
import com.instana.android.core.InstanaWorkManager;
import com.instana.android.core.event.models.Beacon;
import com.instana.android.core.event.models.ConnectionProfile;
import com.instana.android.core.util.ConstantsAndUtil;
import com.instana.android.core.util.Logger;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lcom/instana/android/session/SessionService;", "", "context", "Landroid/content/Context;", "manager", "Lcom/instana/android/core/InstanaWorkManager;", "config", "Lcom/instana/android/core/InstanaConfig;", "(Landroid/content/Context;Lcom/instana/android/core/InstanaWorkManager;Lcom/instana/android/core/InstanaConfig;)V", "getContext", "()Landroid/content/Context;", "runtime_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY})
public final class SessionService {
    @NotNull
    private final Context context;

    @NotNull
    public final Context getContext() {
        return this.context;
    }

    public SessionService(@NotNull Context context, @NotNull InstanaWorkManager manager, @NotNull InstanaConfig config) {
        ConnectivityManager cm;
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)manager, (String)"manager");
        Intrinsics.checkParameterIsNotNull((Object)config, (String)"config");
        this.context = context;
        String string = UUID.randomUUID().toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"UUID.randomUUID().toString()");
        String sessionId = string;
        Object object = this.context.getSystemService("phone");
        if (!(object instanceof TelephonyManager)) {
            object = null;
        }
        TelephonyManager tm = (TelephonyManager)object;
        Object object2 = this.context.getSystemService("connectivity");
        if (!(object2 instanceof ConnectivityManager)) {
            object2 = null;
        }
        ConnectionProfile connectionProfile = new ConnectionProfile((cm = (ConnectivityManager)object2) != null && tm != null ? ConstantsAndUtil.INSTANCE.getCarrierName(cm, tm) : null, cm != null ? ConstantsAndUtil.INSTANCE.getConnectionType(cm) : null, cm != null && tm != null ? ConstantsAndUtil.INSTANCE.getCellularConnectionType(this.context, cm, tm) : null);
        Beacon session = Beacon.Companion.newSessionStart(config.getKey(), Instana.INSTANCE.getAppProfile$runtime_release(), Instana.INSTANCE.getDeviceProfile$runtime_release(), connectionProfile, Instana.INSTANCE.getUserProfile$runtime_release(), sessionId, Instana.getView(), Instana.getMeta().getAll());
        Instana.setSessionId$runtime_release(sessionId);
        Logger.i("Session started with: `id` " + sessionId);
        manager.queue(session);
    }
}

