/*
 * Decompiled with CFR 0.152.
 */
package com.instana.android.view;

import android.content.Context;
import android.net.ConnectivityManager;
import android.telephony.TelephonyManager;
import androidx.annotation.RestrictTo;
import com.instana.android.Instana;
import com.instana.android.core.InstanaConfig;
import com.instana.android.core.InstanaWorkManager;
import com.instana.android.core.event.models.Beacon;
import com.instana.android.core.event.models.ConnectionProfile;
import com.instana.android.core.util.ConstantsAndUtil;
import com.instana.android.core.util.Logger;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\nR\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/instana/android/view/ViewChangeService;", "", "context", "Landroid/content/Context;", "manager", "Lcom/instana/android/core/InstanaWorkManager;", "config", "Lcom/instana/android/core/InstanaConfig;", "(Landroid/content/Context;Lcom/instana/android/core/InstanaWorkManager;Lcom/instana/android/core/InstanaConfig;)V", "appKey", "", "cm", "Landroid/net/ConnectivityManager;", "tm", "Landroid/telephony/TelephonyManager;", "sendViewChange", "", "viewName", "runtime_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY})
public final class ViewChangeService {
    private final String appKey;
    private final ConnectivityManager cm;
    private final TelephonyManager tm;
    private final Context context;
    private final InstanaWorkManager manager;

    public final void sendViewChange(@NotNull String viewName) {
        Intrinsics.checkParameterIsNotNull((Object)viewName, (String)"viewName");
        String sessionId = Instana.getSessionId();
        if (sessionId == null) {
            Logger.e("Tried send CustomEvent with null sessionId");
            return;
        }
        ConnectionProfile connectionProfile = new ConnectionProfile(ConstantsAndUtil.INSTANCE.getCarrierName(this.cm, this.tm), ConstantsAndUtil.INSTANCE.getConnectionType(this.cm), ConstantsAndUtil.INSTANCE.getCellularConnectionType(this.context, this.cm, this.tm));
        Beacon view = Beacon.Companion.newViewChange(this.appKey, Instana.INSTANCE.getAppProfile$runtime_release(), Instana.INSTANCE.getDeviceProfile$runtime_release(), connectionProfile, Instana.INSTANCE.getUserProfile$runtime_release(), sessionId, viewName, Instana.getMeta().getAll());
        Logger.i("View changed with: `name` " + viewName);
        this.manager.queue(view);
    }

    public ViewChangeService(@NotNull Context context, @NotNull InstanaWorkManager manager, @NotNull InstanaConfig config) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)manager, (String)"manager");
        Intrinsics.checkParameterIsNotNull((Object)config, (String)"config");
        this.context = context;
        this.manager = manager;
        this.appKey = config.getKey();
        Object object = this.context.getSystemService("connectivity");
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type android.net.ConnectivityManager");
        }
        this.cm = (ConnectivityManager)object;
        Object object2 = this.context.getSystemService("phone");
        if (object2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type android.telephony.TelephonyManager");
        }
        this.tm = (TelephonyManager)object2;
    }
}

