/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate.http.apache;

import com.intuit.karate.http.HttpLogModifier;
import com.intuit.karate.http.HttpRequest;
import com.intuit.karate.http.HttpUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.TreeSet;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;

public class LoggingUtils {
    private LoggingUtils() {
    }

    private static Collection<String> sortKeys(Header[] headers) {
        TreeSet<String> keys = new TreeSet<String>();
        for (Header header : headers) {
            keys.add(header.getName());
        }
        return keys;
    }

    private static void logHeaderLine(HttpLogModifier logModifier, StringBuilder sb, int id, char prefix, String key, Header[] headers) {
        sb.append(id).append(' ').append(prefix).append(' ').append(key).append(": ");
        if (headers.length == 1) {
            if (logModifier == null) {
                sb.append(headers[0].getValue());
            } else {
                sb.append(logModifier.header(key, headers[0].getValue()));
            }
        } else {
            ArrayList<String> list = new ArrayList<String>(headers.length);
            for (Header header : headers) {
                if (logModifier == null) {
                    list.add(header.getValue());
                    continue;
                }
                list.add(logModifier.header(key, header.getValue()));
            }
            sb.append(list);
        }
        sb.append('\n');
    }

    public static void logHeaders(HttpLogModifier logModifier, StringBuilder sb, int id, char prefix, org.apache.http.HttpRequest request, HttpRequest actual) {
        for (String key : LoggingUtils.sortKeys(request.getAllHeaders())) {
            Header[] headers = request.getHeaders(key);
            LoggingUtils.logHeaderLine(logModifier, sb, id, prefix, key, headers);
            for (Header header : headers) {
                actual.addHeader(header.getName(), header.getValue());
            }
        }
    }

    public static void logHeaders(HttpLogModifier logModifier, StringBuilder sb, int id, char prefix, HttpResponse response) {
        for (String key : LoggingUtils.sortKeys(response.getAllHeaders())) {
            Header[] headers = response.getHeaders(key);
            LoggingUtils.logHeaderLine(logModifier, sb, id, prefix, key, headers);
        }
    }

    public static boolean isPrintable(HttpEntity entity) {
        if (entity == null) {
            return false;
        }
        return entity.getContentType() != null && HttpUtils.isPrintable((String)entity.getContentType().getValue());
    }
}

