/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate.cucumber;

import com.intuit.karate.FileUtils;
import cucumber.runtime.CucumberException;
import cucumber.runtime.formatter.StrictAware;
import cucumber.runtime.io.URLOutputStream;
import cucumber.runtime.io.UTF8OutputStreamWriter;
import gherkin.formatter.Formatter;
import gherkin.formatter.Reporter;
import gherkin.formatter.model.Background;
import gherkin.formatter.model.Examples;
import gherkin.formatter.model.Feature;
import gherkin.formatter.model.Match;
import gherkin.formatter.model.Result;
import gherkin.formatter.model.Scenario;
import gherkin.formatter.model.ScenarioOutline;
import gherkin.formatter.model.Step;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class KarateJunitFormatter
implements Formatter,
Reporter,
StrictAware {
    private static final Logger logger = LoggerFactory.getLogger(KarateJunitFormatter.class);
    private final Writer out;
    private final Document doc;
    private final Element rootElement;
    private TestCase testCase;
    private Element root;
    private boolean strict;
    private final String featurePath;
    private final String reportPath;
    private int currentScenario;
    private int testCount;
    private int failCount;
    private int skipCount;
    private double timeTaken;

    public int getTestCount() {
        return this.testCount;
    }

    public int getFailCount() {
        return this.failCount;
    }

    public int getSkipCount() {
        return this.skipCount;
    }

    public double getTimeTaken() {
        return this.timeTaken;
    }

    public boolean isFail() {
        return this.failCount > 0;
    }

    public String getFeaturePath() {
        return this.featurePath;
    }

    private static boolean isScenarioOutline(Scenario scenario) {
        return scenario.getKeyword().equals("Scenario Outline");
    }

    public KarateJunitFormatter(String featurePath, String reportPath) throws IOException {
        this.featurePath = featurePath;
        this.reportPath = reportPath;
        logger.debug(">> {}", (Object)reportPath);
        URL url = FileUtils.toFileUrl(reportPath);
        this.out = new UTF8OutputStreamWriter((OutputStream)new URLOutputStream(url));
        try {
            this.doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            this.rootElement = this.doc.createElement("testsuite");
            this.doc.appendChild(this.rootElement);
        }
        catch (ParserConfigurationException e) {
            throw new CucumberException("Error while processing unit report", (Throwable)e);
        }
    }

    public void feature(Feature feature) {
        logger.trace("feature: {}", (Object)feature);
        this.testCase = new TestCase();
        this.testCase.treatSkippedAsFailure = this.strict;
        this.testCase.feature = feature;
    }

    public void background(Background background) {
        logger.trace("background: {}", (Object)background);
    }

    public void scenario(Scenario scenario) {
        logger.trace("scenario: {}", (Object)scenario);
    }

    public void scenarioOutline(ScenarioOutline scenarioOutline) {
        logger.trace("scenarioOutline: {}", (Object)scenarioOutline);
    }

    public void step(Step step) {
        logger.trace("step: {}", (Object)step);
        this.testCase.steps.add(step);
    }

    private void printStatsToConsole() {
        System.out.println("---------------------------------------------------------");
        System.out.println("feature: " + this.featurePath);
        System.out.println("report: " + this.reportPath);
        System.out.println(String.format("scenarios: %2d | failed: %2d | skipped: %2d | time: %f", this.testCount, this.failCount, this.skipCount, this.timeTaken));
        System.out.println("---------------------------------------------------------");
    }

    public void done() {
        try {
            String featureName = StringUtils.trimToNull((String)this.testCase.feature.getName());
            if (featureName == null) {
                featureName = this.featurePath;
            }
            this.rootElement.setAttribute("name", featureName);
            this.testCount = Integer.valueOf(this.rootElement.getAttribute("tests"));
            this.failCount = this.rootElement.getElementsByTagName("failure").getLength();
            this.rootElement.setAttribute("failures", String.valueOf(this.failCount));
            this.skipCount = this.rootElement.getElementsByTagName("skipped").getLength();
            this.rootElement.setAttribute("skipped", String.valueOf(this.skipCount));
            this.timeTaken = this.sumTimes(this.rootElement.getElementsByTagName("testcase"));
            this.rootElement.setAttribute("time", this.formatTime(this.timeTaken));
            this.printStatsToConsole();
            if (this.rootElement.getElementsByTagName("testcase").getLength() == 0) {
                this.addDummyTestCase();
            }
            TransformerFactory transfac = TransformerFactory.newInstance();
            Transformer trans = transfac.newTransformer();
            trans.setOutputProperty("indent", "yes");
            StreamResult result = new StreamResult(this.out);
            DOMSource source = new DOMSource(this.doc);
            trans.transform(source, result);
        }
        catch (TransformerException e) {
            throw new CucumberException("Error while transforming.", (Throwable)e);
        }
        logger.trace("<< {}", (Object)this.reportPath);
    }

    public void startOfScenarioLifeCycle(Scenario scenario) {
        logger.trace("startOfScenarioLifeCycle: {}", (Object)scenario);
        this.testCase.steps.clear();
        this.testCase.results.clear();
        ++this.currentScenario;
        this.testCase.scenario = scenario;
        this.root = this.testCase.createTestCaseElement(this.doc);
        this.testCase.writeElement(this.doc, this.root);
        this.rootElement.appendChild(this.root);
        this.increaseAttributeValue(this.rootElement, "tests");
    }

    public void endOfScenarioLifeCycle(Scenario scenario) {
        logger.trace("endOfScenarioLifeCycle: {}", (Object)scenario);
        if (this.testCase.steps.isEmpty()) {
            this.testCase.handleEmptyTestCase(this.doc, this.root);
        }
    }

    private void addDummyTestCase() {
        Element dummy = this.doc.createElement("testcase");
        dummy.setAttribute("classname", "dummy");
        dummy.setAttribute("name", "dummy");
        this.rootElement.appendChild(dummy);
        Element skipped = this.doc.createElement("skipped");
        skipped.setAttribute("message", "No features found");
        dummy.appendChild(skipped);
    }

    public void result(Result result) {
        logger.trace("result: {}", (Object)result);
        if ("failed".equals(result.getStatus())) {
            logger.error("failed feature: {}", (Object)this.featurePath, (Object)result.getError());
        }
        this.testCase.results.add(result);
        this.testCase.updateElement(this.doc, this.root);
    }

    public void before(Match match, Result result) {
        logger.trace("before: {} {}", (Object)match, (Object)result);
        this.handleHook(result);
    }

    public void after(Match match, Result result) {
        logger.debug("after: {} {}", (Object)match, (Object)result);
        this.handleHook(result);
    }

    private void handleHook(Result result) {
        this.testCase.hookResults.add(result);
        this.testCase.updateElement(this.doc, this.root);
    }

    private double sumTimes(NodeList testCaseNodes) {
        double totalDurationSecondsForAllTimes = 0.0;
        for (int i = 0; i < testCaseNodes.getLength(); ++i) {
            try {
                double testCaseTime = Double.parseDouble(testCaseNodes.item(i).getAttributes().getNamedItem("time").getNodeValue());
                totalDurationSecondsForAllTimes += testCaseTime;
                continue;
            }
            catch (NumberFormatException e) {
                throw new CucumberException((Throwable)e);
            }
            catch (NullPointerException e) {
                throw new CucumberException((Throwable)e);
            }
        }
        return totalDurationSecondsForAllTimes;
    }

    private String formatTime(double time) {
        DecimalFormat nfmt = (DecimalFormat)NumberFormat.getNumberInstance(Locale.US);
        nfmt.applyPattern("0.######");
        return nfmt.format(time);
    }

    private void increaseAttributeValue(Element element, String attribute) {
        int value = 0;
        if (element.hasAttribute(attribute)) {
            value = Integer.parseInt(element.getAttribute(attribute));
        }
        element.setAttribute(attribute, String.valueOf(++value));
    }

    public void examples(Examples examples) {
    }

    public void match(Match match) {
    }

    public void embedding(String mimeType, byte[] data) {
    }

    public void write(String text) {
    }

    public void uri(String uri) {
    }

    public void close() {
    }

    public void eof() {
    }

    public void syntaxError(String state, String event, List<String> legalEvents, String uri, Integer line) {
    }

    public void setStrict(boolean strict) {
        this.strict = strict;
        if (this.testCase != null) {
            this.testCase.treatSkippedAsFailure = strict;
        }
    }

    private class TestCase {
        private final DecimalFormat NUMBER_FORMAT = (DecimalFormat)NumberFormat.getNumberInstance(Locale.US);
        Scenario scenario;
        private Feature feature;
        private int exampleNumber;
        private boolean treatSkippedAsFailure = false;
        final List<Step> steps = new ArrayList<Step>();
        final List<Result> results = new ArrayList<Result>();
        final List<Result> hookResults = new ArrayList<Result>();

        private TestCase(Scenario scenario) {
            this.scenario = scenario;
            this.NUMBER_FORMAT.applyPattern("0.######");
        }

        private TestCase() {
            this((Scenario)null);
        }

        private Element createTestCaseElement(Document doc) {
            return doc.createElement("testcase");
        }

        private void writeElement(Document doc, Element tc) {
            tc.setAttribute("classname", KarateJunitFormatter.this.featurePath);
            tc.setAttribute("name", this.calculateElementName(this.scenario));
        }

        private String calculateElementName(Scenario scenario) {
            String scenarioName = StringUtils.trimToNull((String)scenario.getName());
            if (scenarioName == null) {
                scenarioName = KarateJunitFormatter.this.currentScenario + "";
            }
            if (KarateJunitFormatter.isScenarioOutline(scenario)) {
                return scenarioName + " (" + ++this.exampleNumber + ")";
            }
            return scenarioName;
        }

        public void updateElement(Document doc, Element tc) {
            Element child;
            tc.setAttribute("time", this.calculateTotalDurationString());
            StringBuilder sb = new StringBuilder();
            this.addStepAndResultListing(sb);
            Result skipped = null;
            Result failed = null;
            for (Result result : this.results) {
                if ("failed".equals(result.getStatus())) {
                    failed = result;
                }
                if (!"undefined".equals(result.getStatus()) && !"pending".equals(result.getStatus())) continue;
                skipped = result;
            }
            for (Result result : this.hookResults) {
                if (failed == null && "failed".equals(result.getStatus())) {
                    failed = result;
                }
                if (skipped != null || !"pending".equals(result.getStatus())) continue;
                skipped = result;
            }
            if (failed != null) {
                this.addStackTrace(sb, failed);
                child = this.createElementWithMessage(doc, sb, "failure", failed.getErrorMessage());
            } else {
                child = skipped != null ? (this.treatSkippedAsFailure ? this.createElementWithMessage(doc, sb, "failure", "The scenario has pending or undefined step(s)") : this.createElement(doc, sb, "skipped")) : this.createElement(doc, sb, "system-out");
            }
            Node existingChild = tc.getFirstChild();
            if (existingChild == null) {
                tc.appendChild(child);
            } else {
                tc.replaceChild(child, existingChild);
            }
        }

        public void handleEmptyTestCase(Document doc, Element tc) {
            tc.setAttribute("time", this.calculateTotalDurationString());
            String resultType = this.treatSkippedAsFailure ? "failure" : "skipped";
            Element child = this.createElementWithMessage(doc, new StringBuilder(), resultType, "The scenario has no steps");
            tc.appendChild(child);
        }

        private String calculateTotalDurationString() {
            long totalDurationNanos = 0L;
            for (Result r : this.results) {
                totalDurationNanos += r.getDuration() == null ? 0L : r.getDuration();
            }
            for (Result r : this.hookResults) {
                totalDurationNanos += r.getDuration() == null ? 0L : r.getDuration();
            }
            double totalDurationSeconds = (double)totalDurationNanos / 1.0E9;
            return this.NUMBER_FORMAT.format(totalDurationSeconds);
        }

        private void addStepAndResultListing(StringBuilder sb) {
            for (int i = 0; i < this.steps.size(); ++i) {
                int length = sb.length();
                String resultStatus = "not executed";
                if (i < this.results.size()) {
                    resultStatus = this.results.get(i).getStatus();
                }
                sb.append(this.steps.get(i).getKeyword());
                sb.append(this.steps.get(i).getName());
                do {
                    sb.append(".");
                } while (sb.length() - length < 76);
                sb.append(resultStatus);
                sb.append("\n");
            }
        }

        private void addStackTrace(StringBuilder sb, Result failed) {
            sb.append("\nStackTrace:\n");
            StringWriter sw = new StringWriter();
            failed.getError().printStackTrace(new PrintWriter(sw));
            sb.append(sw.toString());
        }

        private Element createElementWithMessage(Document doc, StringBuilder sb, String elementType, String message) {
            Element child = this.createElement(doc, sb, elementType);
            child.setAttribute("message", message);
            return child;
        }

        private Element createElement(Document doc, StringBuilder sb, String elementType) {
            Element child = doc.createElement(elementType);
            child.appendChild(doc.createCDATASection(sb.toString()));
            return child;
        }
    }
}

