/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate.ui;

import com.intuit.karate.cucumber.FeatureSection;
import com.intuit.karate.ui.AppAction;
import com.intuit.karate.ui.AppSession;
import com.intuit.karate.ui.SectionPanel;
import java.util.ArrayList;
import java.util.List;
import javafx.scene.Node;
import javafx.scene.control.ScrollPane;
import javafx.scene.layout.VBox;

public class FeaturePanel
extends ScrollPane {
    private final VBox content = new VBox(0.0);
    private final AppSession session;
    private final List<SectionPanel> sectionPanels;

    public FeaturePanel(AppSession session) {
        this.setContent((Node)this.content);
        this.setFitToWidth(true);
        this.session = session;
        int sectionCount = session.getFeature().getSections().size();
        this.sectionPanels = new ArrayList<SectionPanel>(sectionCount);
        this.addSections();
    }

    private void addSections() {
        for (FeatureSection section : this.session.getFeature().getSections()) {
            SectionPanel sectionPanel = new SectionPanel(this.session, section);
            this.content.getChildren().add((Object)sectionPanel);
            if (!this.sectionPanels.isEmpty()) {
                sectionPanel.setExpanded(false);
            }
            this.sectionPanels.add(sectionPanel);
        }
    }

    public void action(AppAction action) {
        for (SectionPanel panel : this.sectionPanels) {
            panel.action(action);
        }
    }
}

