/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate.ui;

import com.intuit.karate.cucumber.ScenarioWrapper;
import com.intuit.karate.cucumber.StepWrapper;
import com.intuit.karate.ui.AppAction;
import com.intuit.karate.ui.AppSession;
import com.intuit.karate.ui.StepPanel;
import java.util.ArrayList;
import java.util.List;
import javafx.scene.Node;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.VBox;

public class ScenarioPanel
extends BorderPane {
    private final VBox content = new VBox(0.0);
    private final AppSession session;
    private ScenarioWrapper scenario;
    private final List<StepPanel> stepPanels;

    public ScenarioPanel(AppSession session, ScenarioWrapper scenario) {
        this.setCenter((Node)this.content);
        this.session = session;
        this.scenario = scenario;
        this.stepPanels = new ArrayList<StepPanel>(scenario.getSteps().size());
        this.initTitleAndContent();
    }

    private void initTitleAndContent() {
        for (StepWrapper step : this.scenario.getSteps()) {
            StepPanel stepPanel = new StepPanel(this.session, step);
            this.content.getChildren().add((Object)stepPanel);
            this.stepPanels.add(stepPanel);
        }
    }

    public void action(AppAction action) {
        this.scenario = this.session.refresh(this.scenario);
        for (StepPanel panel : this.stepPanels) {
            panel.action(action);
        }
    }
}

