/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate.ui;

import com.intuit.karate.cucumber.StepResult;
import com.intuit.karate.cucumber.StepWrapper;
import com.intuit.karate.ui.App;
import com.intuit.karate.ui.AppAction;
import com.intuit.karate.ui.AppSession;
import com.intuit.karate.ui.StepException;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.TextArea;
import javafx.scene.layout.AnchorPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StepPanel
extends AnchorPane {
    private static final Logger logger = LoggerFactory.getLogger(StepPanel.class);
    private final AppSession session;
    private final TextArea textArea;
    private final Button runButton;
    private String oldText;
    private StepWrapper step;
    private Boolean pass = null;
    private static final String STYLE_PASS = "-fx-base: #53B700";
    private static final String STYLE_FAIL = "-fx-base: #D52B1E";
    private static final String STYLE_METHOD = "-fx-base: #34BFFF";
    private static final String STYLE_DEFAULT = "-fx-base: #F0F0F0";
    private static final String STYLE_BACKGROUND = "-fx-text-fill: #8D9096";

    public StepPanel(AppSession session, StepWrapper step) {
        this.session = session;
        this.runButton = new Button("\u25ba");
        this.textArea = new TextArea();
        this.textArea.setFont(App.DEFAULT_FONT);
        this.textArea.setMinHeight(0.0);
        this.textArea.setWrapText(true);
        this.textArea.focusedProperty().addListener((val, before, after) -> {
            if (!after.booleanValue()) {
                this.rebuildFeatureIfTextChanged();
            }
        });
        this.step = step;
        this.initTextArea();
        this.runButton.setOnAction(e -> this.run());
        this.getChildren().addAll((Object[])new Node[]{this.textArea, this.runButton});
        StepPanel.setLeftAnchor((Node)this.textArea, (Double)0.0);
        StepPanel.setRightAnchor((Node)this.textArea, (Double)30.0);
        StepPanel.setBottomAnchor((Node)this.textArea, (Double)0.0);
        StepPanel.setRightAnchor((Node)this.runButton, (Double)0.0);
        StepPanel.setTopAnchor((Node)this.runButton, (Double)2.0);
        StepPanel.setBottomAnchor((Node)this.runButton, (Double)0.0);
    }

    private void rebuildFeatureIfTextChanged() {
        String newText = this.textArea.getText();
        if (!newText.equals(this.oldText)) {
            this.session.replace(this.step, newText);
        }
    }

    private void run() {
        this.rebuildFeatureIfTextChanged();
        StepResult result = this.step.run(this.session.backend);
        this.pass = result.isPass();
        this.initStyleColor();
        this.session.refreshVarsTable();
        if (!this.pass.booleanValue()) {
            throw new StepException(result);
        }
    }

    public void action(AppAction action) {
        switch (action) {
            case REFRESH: {
                this.step = this.session.refresh(this.step);
                this.initTextArea();
                break;
            }
            case RESET: {
                this.pass = null;
                this.initStyleColor();
                break;
            }
            case RUN: {
                if (this.pass != null) break;
                this.run();
            }
        }
    }

    private void initStyleColor() {
        if (this.pass == null) {
            this.runButton.setStyle("");
        } else if (this.pass.booleanValue()) {
            this.runButton.setStyle(STYLE_PASS);
        } else {
            this.runButton.setStyle(STYLE_FAIL);
        }
    }

    private void initTextArea() {
        this.oldText = this.step.getText();
        this.textArea.setText(this.oldText);
        int lineCount = this.step.getLineCount();
        if (lineCount == 1) {
            int wrapEstimate = this.oldText.length() / 40;
            lineCount = wrapEstimate > 1 ? wrapEstimate : 0;
        }
        this.textArea.setPrefRowCount(lineCount);
        if (this.step.isHttpCall()) {
            this.setStyle(STYLE_METHOD);
            this.textArea.setStyle(STYLE_METHOD);
        } else {
            this.setStyle(STYLE_DEFAULT);
        }
        if (this.step.isBackground()) {
            this.textArea.setStyle(STYLE_BACKGROUND);
        }
        this.initStyleColor();
    }
}

