/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate;

import com.intuit.karate.FileUtils;
import com.intuit.karate.Script;
import com.intuit.karate.ScriptEnv;
import com.intuit.karate.ScriptValue;
import com.intuit.karate.ScriptValueMap;
import com.intuit.karate.StringUtils;
import com.intuit.karate.exception.KarateFileNotFoundException;
import com.intuit.karate.http.Cookie;
import com.intuit.karate.http.HttpClient;
import com.intuit.karate.http.HttpConfig;
import com.intuit.karate.validator.Validator;
import java.util.Map;
import org.slf4j.Logger;

public class ScriptContext {
    public final Logger logger;
    private static final String KARATE_DOT_CONTEXT = "karate.context";
    public static final String KARATE_NAME = "karate";
    private static final String VAR_READ = "read";
    protected final ScriptValueMap vars;
    protected final Map<String, Validator> validators;
    protected final ScriptEnv env;
    private final ScriptValue readFunction;
    protected HttpClient client;
    protected HttpConfig config;

    public ScriptEnv getEnv() {
        return this.env;
    }

    public ScriptValueMap getVars() {
        return this.vars;
    }

    public ScriptValue getConfigHeaders() {
        return this.config.getHeaders();
    }

    public ScriptValue getConfigCookies() {
        return this.config.getCookies();
    }

    public void updateConfigCookies(Map<String, Cookie> cookies) {
        if (cookies == null) {
            return;
        }
        if (this.config.getCookies().isNull()) {
            this.config.setCookies(new ScriptValue(cookies));
        } else {
            Map<String, Object> map = this.config.getCookies().evalAsMap(this);
            map.putAll(cookies);
            this.config.setCookies(new ScriptValue(map));
        }
    }

    public boolean isLogPrettyRequest() {
        return this.config.isLogPrettyRequest();
    }

    public boolean isLogPrettyResponse() {
        return this.config.isLogPrettyResponse();
    }

    public boolean isPrintEnabled() {
        return this.config.isPrintEnabled();
    }

    public ScriptContext(ScriptEnv env, ScriptContext parent, Map<String, Object> arg) {
        this.env = env.refresh(null);
        this.logger = env.logger;
        if (parent != null) {
            this.vars = Script.clone(parent.vars);
            this.validators = parent.validators;
            this.config = new HttpConfig(parent.config);
        } else {
            this.vars = new ScriptValueMap();
            this.validators = Script.getDefaultValidators();
            this.config = new HttpConfig();
        }
        this.client = HttpClient.construct(this.config, this);
        this.readFunction = Script.eval(ScriptContext.getFileReaderFunction(), this);
        if (parent == null) {
            try {
                Script.callAndUpdateConfigAndAlsoVarsIfMapReturned(false, "read('classpath:karate-config.js')", null, this);
            }
            catch (Exception e) {
                Throwable cause = e.getCause();
                if (cause instanceof KarateFileNotFoundException) {
                    this.logger.warn("karate-config.js not found on the classpath, skipping bootstrap configuration");
                }
                throw new RuntimeException("bootstrap configuration error, evaluation of karate-config.js failed:", cause);
            }
        }
        if (arg != null) {
            for (Map.Entry<String, Object> entry : arg.entrySet()) {
                this.vars.put(entry.getKey(), entry.getValue());
            }
        }
        this.logger.trace("karate context init - initial properties: {}", (Object)this.vars);
    }

    private static String getFileReaderFunction() {
        return "function(path) {\n  var FileUtils = Java.type('" + FileUtils.class.getCanonicalName() + "');\n  return FileUtils.readFile(path, " + KARATE_DOT_CONTEXT + ").value;\n}";
    }

    public void configure(HttpConfig config) {
        this.config = config;
        this.client = HttpClient.construct(config, this);
    }

    public void configure(String key, String exp) {
        this.configure(key, Script.eval(exp, this));
    }

    public void configure(String key, ScriptValue value) {
        if ((key = StringUtils.trimToEmpty(key)).equals("headers")) {
            this.config.setHeaders(value);
            return;
        }
        if (key.equals("cookies")) {
            this.config.setCookies(value);
            return;
        }
        if (key.equals("logPrettyResponse")) {
            this.config.setLogPrettyResponse(value.isBooleanTrue());
            return;
        }
        if (key.equals("logPrettyRequest")) {
            this.config.setLogPrettyRequest(value.isBooleanTrue());
            return;
        }
        if (key.equals("printEnabled")) {
            this.config.setPrintEnabled(value.isBooleanTrue());
            return;
        }
        if (key.equals("httpClientClass")) {
            this.config.setClientClass(value.getAsString());
            this.client = HttpClient.construct(this.config, this);
            return;
        }
        if (key.equals("httpClientInstance")) {
            this.config.setClientInstance(value.getValue(HttpClient.class));
            this.client = HttpClient.construct(this.config, this);
            return;
        }
        if (key.equals("ssl")) {
            if (value.isString()) {
                this.config.setSslEnabled(true);
                this.config.setSslAlgorithm(value.getAsString());
            } else {
                this.config.setSslEnabled(value.isBooleanTrue());
            }
        } else if (key.equals("followRedirects")) {
            this.config.setFollowRedirects(value.isBooleanTrue());
        } else if (key.equals("connectTimeout")) {
            this.config.setConnectTimeout(Integer.valueOf(value.getAsString()));
        } else if (key.equals("readTimeout")) {
            this.config.setReadTimeout(Integer.valueOf(value.getAsString()));
        } else if (key.equals("proxy")) {
            if (value.isString()) {
                this.config.setProxyUri(value.getAsString());
            } else {
                Map<String, Object> map = value.getAsMap();
                this.config.setProxyUri((String)map.get("uri"));
                this.config.setProxyUsername((String)map.get("username"));
                this.config.setProxyPassword((String)map.get("password"));
            }
        } else if (key.equals("userDefined")) {
            this.config.setUserDefined(value.getAsMap());
        } else {
            throw new RuntimeException("unexpected 'configure' key: '" + key + "'");
        }
        this.client.configure(this.config, this);
    }

    public Map<String, Object> getVariableBindings() {
        Map<String, Object> map = Script.simplify(this.vars);
        if (this.readFunction != null) {
            map.put(VAR_READ, this.readFunction.getValue());
        }
        return map;
    }
}

