/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate;

import com.intuit.karate.CallCache;
import com.intuit.karate.Debug;
import com.intuit.karate.FileUtils;
import com.intuit.karate.StringUtils;
import com.intuit.karate.cucumber.KarateReporter;
import java.io.File;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScriptEnv {
    public final Logger logger;
    public final String env;
    public final File featureDir;
    public final String featureName;
    public final ClassLoader fileClassLoader;
    public final CallCache callCache;
    public final KarateReporter reporter;
    public final Debug debug;

    public ScriptEnv(String env, File featureDir, String featureName, ClassLoader fileClassLoader, CallCache callCache, Logger logger, KarateReporter reporter, Debug debug) {
        this.env = env;
        this.featureDir = featureDir;
        this.featureName = featureName;
        this.fileClassLoader = fileClassLoader;
        this.callCache = callCache;
        this.logger = logger;
        this.reporter = reporter;
        this.debug = debug;
    }

    public ScriptEnv(String env, File featureDir, String featureName, ClassLoader fileClassLoader, KarateReporter reporter) {
        this(env, featureDir, featureName, fileClassLoader, new CallCache(), LoggerFactory.getLogger((String)"com.intuit.karate"), reporter, new Debug());
    }

    public static ScriptEnv init(File featureDir, String featureName, ClassLoader classLoader) {
        return new ScriptEnv(null, featureDir, featureName, classLoader, null);
    }

    public static ScriptEnv init(String env, File featureDir) {
        return new ScriptEnv(env, featureDir, null, Thread.currentThread().getContextClassLoader(), null);
    }

    public static ScriptEnv init(String env, File featureFile, String[] searchPaths, Logger logger) {
        return new ScriptEnv(env, featureFile.getParentFile(), featureFile.getName(), FileUtils.createClassLoader(searchPaths), new CallCache(), logger, null, new Debug());
    }

    public ScriptEnv refresh(String in) {
        String karateEnv = StringUtils.trimToNull(in);
        if (karateEnv == null && (karateEnv = StringUtils.trimToNull(this.env)) == null) {
            karateEnv = StringUtils.trimToNull(System.getProperty("karate.env"));
        }
        return new ScriptEnv(karateEnv, this.featureDir, this.featureName, this.fileClassLoader, this.callCache, this.logger, this.reporter, this.debug);
    }

    public String toString() {
        return this.featureName + ", env: " + this.env + ", dir: " + this.featureDir;
    }
}

