/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate.cucumber;

import com.intuit.karate.cucumber.CucumberUtils;
import com.intuit.karate.cucumber.KarateBackend;
import com.intuit.karate.cucumber.KarateReporter;
import com.intuit.karate.cucumber.StepResult;
import cucumber.runtime.CucumberScenarioImpl;
import cucumber.runtime.CucumberStats;
import cucumber.runtime.Runtime;
import cucumber.runtime.RuntimeGlue;
import cucumber.runtime.RuntimeOptions;
import cucumber.runtime.io.ResourceLoader;
import gherkin.I18n;
import gherkin.formatter.Reporter;
import gherkin.formatter.model.Match;
import gherkin.formatter.model.Result;
import gherkin.formatter.model.Scenario;
import gherkin.formatter.model.Step;
import gherkin.formatter.model.Tag;
import java.util.Collections;
import java.util.Set;

public class KarateRuntime
extends Runtime {
    private final KarateBackend backend;
    private final CucumberStats stats;
    private CucumberScenarioImpl scenarioResult;
    private boolean failed;

    public KarateRuntime(ResourceLoader resourceLoader, ClassLoader classLoader, KarateBackend backend, RuntimeOptions runtimeOptions, RuntimeGlue glue) {
        super(resourceLoader, classLoader, Collections.singletonList(backend), runtimeOptions, glue);
        this.backend = backend;
        this.stats = new CucumberStats(runtimeOptions.isMonochrome());
    }

    private void addStepToCounterAndResult(Result result) {
        this.scenarioResult.add(result);
        this.stats.addStep(result);
    }

    public void runStep(String featurePath, Step step, Reporter reporter, I18n i18n) {
        if (this.failed) {
            if (reporter instanceof KarateReporter) {
                ((KarateReporter)reporter).karateStep(step);
            }
            reporter.match(Match.UNDEFINED);
            this.addStepToCounterAndResult(Result.SKIPPED);
            reporter.result(Result.SKIPPED);
            return;
        }
        StepResult result = CucumberUtils.runStep(featurePath, step, reporter, i18n, this.backend, false);
        if (!result.isPass()) {
            this.addError(result.getError());
            this.failed = true;
        }
        this.addStepToCounterAndResult(result.getResult());
    }

    public void buildBackendWorlds(Reporter reporter, Set<Tag> tags, Scenario gherkinScenario) {
        this.backend.buildWorld();
        this.scenarioResult = new CucumberScenarioImpl(reporter, tags, gherkinScenario);
    }

    public void disposeBackendWorlds(String scenarioDesignation) {
        this.stats.addScenario(this.scenarioResult.getStatus(), scenarioDesignation);
        this.backend.disposeWorld();
        this.failed = false;
    }

    public void printSummary() {
        this.stats.printStats(System.out, false);
    }
}

