/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate.junit5;

import com.intuit.karate.Suite;
import com.intuit.karate.core.FeatureCall;
import com.intuit.karate.core.FeatureResult;
import com.intuit.karate.core.FeatureRuntime;
import com.intuit.karate.core.ScenarioIterator;
import com.intuit.karate.core.ScenarioRuntime;
import java.net.URI;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.DynamicTest;

public class FeatureNode
implements Iterator<DynamicTest>,
Iterable<DynamicTest> {
    public final List<CompletableFuture> futures;
    public final Suite suite;
    public final FeatureRuntime featureRuntime;
    private final Iterator<ScenarioRuntime> scenarios;

    public FeatureNode(Suite suite, List<CompletableFuture> futures, FeatureCall featureCall, String tagSelector) {
        this.suite = suite;
        this.futures = futures;
        this.featureRuntime = FeatureRuntime.of((Suite)suite, (FeatureCall)featureCall);
        CompletableFuture future = new CompletableFuture();
        futures.add(future);
        this.featureRuntime.setNext(() -> future.complete(Boolean.TRUE));
        this.scenarios = new ScenarioIterator(this.featureRuntime).filterSelected().iterator();
    }

    @Override
    public boolean hasNext() {
        return this.scenarios.hasNext();
    }

    @Override
    public DynamicTest next() {
        ScenarioRuntime runtime = this.scenarios.next();
        return DynamicTest.dynamicTest((String)runtime.scenario.getRefIdAndName(), (URI)runtime.scenario.getUriToLineNumber(), () -> {
            if (this.featureRuntime.beforeHook()) {
                runtime.run();
                this.featureRuntime.result.addResult(runtime.result);
            } else {
                runtime.logger.info("before-feature hook returned [false], aborting: ", new Object[]{this.featureRuntime});
            }
            boolean failed = runtime.result.isFailed();
            if (!this.scenarios.hasNext()) {
                this.featureRuntime.afterFeature();
                FeatureResult result = this.featureRuntime.result;
                if (!result.isEmpty()) {
                    this.suite.saveFeatureResults(result);
                }
                this.saveSummaryIfAllComplete();
            }
            if (failed) {
                Assertions.fail((String)runtime.result.getError().getMessage());
            }
        });
    }

    @Override
    public Iterator<DynamicTest> iterator() {
        return this;
    }

    private void saveSummaryIfAllComplete() {
        for (CompletableFuture cf : this.futures) {
            if (cf.isDone()) continue;
            return;
        }
        this.suite.buildResults();
    }
}

