/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.bouncycastle.cert.ocsp;

import com.itextpdf.bouncycastle.asn1.ocsp.OCSPResponseBC;
import com.itextpdf.bouncycastle.cert.ocsp.OCSPExceptionBC;
import com.itextpdf.commons.bouncycastle.asn1.ocsp.IOCSPResponse;
import com.itextpdf.commons.bouncycastle.cert.ocsp.IOCSPResp;
import java.io.IOException;
import java.util.Objects;
import org.bouncycastle.cert.ocsp.OCSPException;
import org.bouncycastle.cert.ocsp.OCSPResp;

public class OCSPRespBC
implements IOCSPResp {
    private static final OCSPRespBC INSTANCE = new OCSPRespBC((OCSPResp)null);
    private static final int SUCCESSFUL = 0;
    private final OCSPResp ocspResp;

    public OCSPRespBC(OCSPResp ocspResp) {
        this.ocspResp = ocspResp;
    }

    public OCSPRespBC(IOCSPResponse ocspResponse) {
        this(new OCSPResp(((OCSPResponseBC)ocspResponse).getOcspResponse()));
    }

    public static OCSPRespBC getInstance() {
        return INSTANCE;
    }

    public OCSPResp getOcspResp() {
        return this.ocspResp;
    }

    public byte[] getEncoded() throws IOException {
        return this.ocspResp.getEncoded();
    }

    public int getStatus() {
        return this.ocspResp.getStatus();
    }

    public Object getResponseObject() throws OCSPExceptionBC {
        try {
            return this.ocspResp.getResponseObject();
        }
        catch (OCSPException e) {
            throw new OCSPExceptionBC(e);
        }
    }

    public int getSuccessful() {
        return 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OCSPRespBC that = (OCSPRespBC)o;
        return Objects.equals(this.ocspResp, that.ocspResp);
    }

    public int hashCode() {
        return Objects.hash(this.ocspResp);
    }

    public String toString() {
        return this.ocspResp.toString();
    }
}

