/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.forms.fields;

import com.itextpdf.kernel.pdf.IConformanceLevel;
import com.itextpdf.kernel.pdf.PdfAConformanceLevel;
import com.itextpdf.kernel.pdf.PdfDocument;

public abstract class FormFieldBuilder<T extends FormFieldBuilder<T>> {
    private final PdfDocument document;
    private final String formFieldName;
    private IConformanceLevel conformanceLevel = null;

    protected FormFieldBuilder(PdfDocument document, String formFieldName) {
        this.document = document;
        this.formFieldName = formFieldName;
        if (document != null) {
            this.conformanceLevel = document.getConformanceLevel();
        }
    }

    public PdfDocument getDocument() {
        return this.document;
    }

    public String getFormFieldName() {
        return this.formFieldName;
    }

    @Deprecated
    public PdfAConformanceLevel getConformanceLevel() {
        if (this.conformanceLevel instanceof PdfAConformanceLevel) {
            return (PdfAConformanceLevel)this.conformanceLevel;
        }
        return null;
    }

    @Deprecated
    public IConformanceLevel getGenericConformanceLevel() {
        return this.conformanceLevel;
    }

    @Deprecated
    public T setConformanceLevel(PdfAConformanceLevel conformanceLevel) {
        this.conformanceLevel = conformanceLevel;
        return this.getThis();
    }

    @Deprecated
    public T setGenericConformanceLevel(IConformanceLevel conformanceLevel) {
        this.conformanceLevel = conformanceLevel;
        return this.getThis();
    }

    protected abstract T getThis();
}

