/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.html2pdf.css.apply.util;

import com.itextpdf.html2pdf.attach.ProcessorContext;
import com.itextpdf.html2pdf.css.util.CssUtils;
import com.itextpdf.kernel.colors.Color;
import com.itextpdf.kernel.colors.DeviceRgb;
import com.itextpdf.kernel.pdf.xobject.PdfImageXObject;
import com.itextpdf.layout.IPropertyContainer;
import com.itextpdf.layout.property.Background;
import com.itextpdf.layout.property.BackgroundImage;
import java.util.Map;

public final class BackgroundApplierUtil {
    private BackgroundApplierUtil() {
    }

    public static void applyBackground(Map<String, String> cssProps, ProcessorContext context, IPropertyContainer element) {
        String backgroundImageStr;
        String backgroundColorStr = cssProps.get("background-color");
        if (backgroundColorStr != null && !"transparent".equals(backgroundColorStr)) {
            float[] rgbaColor = CssUtils.parseRgbaColor(backgroundColorStr);
            DeviceRgb color = new DeviceRgb(rgbaColor[0], rgbaColor[1], rgbaColor[2]);
            float opacity = rgbaColor[3];
            Background backgroundColor = new Background((Color)color, opacity);
            element.setProperty(6, (Object)backgroundColor);
        }
        if ((backgroundImageStr = cssProps.get("background-image")) != null && !backgroundImageStr.equals("none")) {
            String backgroundRepeatStr = cssProps.get("background-repeat");
            PdfImageXObject image = context.getResourceResolver().retrieveImage(CssUtils.extractUrl(backgroundImageStr));
            boolean repeatX = true;
            boolean repeatY = true;
            if (backgroundRepeatStr != null) {
                repeatX = backgroundRepeatStr.equals("repeat") || backgroundRepeatStr.equals("repeat-x");
                boolean bl = repeatY = backgroundRepeatStr.equals("repeat") || backgroundRepeatStr.equals("repeat-y");
            }
            if (image != null) {
                BackgroundImage backgroundImage = new BackgroundImage(image, repeatX, repeatY);
                element.setProperty(90, (Object)backgroundImage);
            }
        }
    }
}

